/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ode.scheduler.simple;

import java.io.InputStream;
import java.sql.Connection;

import javax.sql.DataSource;
import javax.transaction.TransactionManager;

import org.apache.ode.utils.GUID;
import org.h2.jdbcx.JdbcDataSource;



/**
 * Support class for creating a JDBC delegate (using in-mem HSQL db).
 * 
 * @author Maciej Szefler ( m s z e f l e r @ g m a i l . c o m )
 */
public class DelegateSupport {

    protected DataSource _ds;
    protected JdbcDelegate _del;

    public DelegateSupport() throws Exception {
    	this(null);
    }

    public DelegateSupport(TransactionManager txm) throws Exception {
    	initialize(txm);
    }

    protected void initialize(TransactionManager txm) throws Exception {
        JdbcDataSource h2 = new JdbcDataSource();
        h2.setURL("jdbc:h2:mem:" + new GUID().toString()+";DB_CLOSE_DELAY=-1");
        h2.setUser("sa");
        _ds = h2;
        
        setup();
        _del = new JdbcDelegate(_ds);
    }
    
    public DatabaseDelegate delegate() {
        return _del;
    }
    
    public void setup() throws Exception {
        Connection c = _ds.getConnection();
        try {
            StringBuffer sql = new StringBuffer();

            {
                InputStream in = getClass().getResourceAsStream("/simplesched-h2.sql");
                int v;
                while ((v = in.read()) != -1) {
                    sql.append((char) v);
                }
            }
            
            //c.createStatement().executeUpdate("CREATE FUNCTION mod(a BIGINT, b BIGINT) RETURNS BIGINT LANGUAGE JAVA DETERMINISTIC NO SQL EXTERNAL NAME 'CLASSPATH:org.apache.ode.scheduler.simple.DelegateSupport.mod';");
            c.createStatement().executeUpdate(sql.toString());
        } finally {
            c.close();
        }
        
    }
    
    public static long mod(long a, long b) {
        return a % b;
    }
}

