/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.elang.xquery10.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQStaticContext;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilerContext;
import org.apache.ode.bpel.compiler.api.ExpressionCompiler;
import org.apache.ode.bpel.compiler.bom.Expression;
import org.apache.ode.bpel.elang.xpath10.compiler.XPathMessages;
import org.apache.ode.bpel.elang.xpath10.compiler.XslCompilationErrorListener;
import org.apache.ode.bpel.elang.xpath10.o.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpFunctionResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.JaxpVariableResolver;
import org.apache.ode.bpel.elang.xpath20.compiler.WrappedResolverException;
import org.apache.ode.bpel.elang.xpath20.o.OXPath20ExpressionBPEL20;
import org.apache.ode.bpel.elang.xquery10.o.OXQuery10ExpressionBPEL20;
import org.apache.ode.bpel.o.OConstantVarType;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLValueExpression;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.o.OVarType;
import org.apache.ode.bpel.o.OXsdTypeVarType;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.NSContext;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsl.XslTransformHandler;
import org.apache.xml.utils.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XQuery10ExpressionCompilerImpl
implements ExpressionCompiler {
    protected static final Logger __log = LoggerFactory.getLogger(XQuery10ExpressionCompilerImpl.class);
    protected String _bpelNS;
    protected QName _qnLinkStatus;
    protected QName _qnVarProp;
    protected QName _qnVarData;
    protected QName _qnXslTransform;
    protected final XPathMessages __msgs = (XPathMessages)MessageBundle.getMessages(XPathMessages.class);
    protected Map<String, String> _properties = new HashMap<String, String>();
    protected CompilerContext _compilerContext;

    public XQuery10ExpressionCompilerImpl(String string) {
        this._bpelNS = string;
        this._qnLinkStatus = new QName(this._bpelNS, "getLinkStatus");
        this._qnVarProp = new QName(this._bpelNS, "getVariableProperty");
        this._qnVarData = new QName(this._bpelNS, "getVariableData");
        this._qnXslTransform = new QName(this._bpelNS, "doXslTransform");
        this._properties.put("runtime-class", "org.apache.ode.bpel.elang.xquery10.runtime.XQuery10ExpressionRuntime");
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        XslTransformHandler.getInstance().setTransformerFactory((TransformerFactory)transformerFactoryImpl);
    }

    @Override
    public void setCompilerContext(CompilerContext compilerContext) {
        this._compilerContext = compilerContext;
        XslCompilationErrorListener xslCompilationErrorListener = new XslCompilationErrorListener(compilerContext);
        XslTransformHandler.getInstance().setErrorListener((ErrorListener)xslCompilationErrorListener);
    }

    @Override
    public OExpression compileJoinCondition(Object object) throws CompilationException {
        return this._compile((Expression)object, true);
    }

    @Override
    public OExpression compile(Object object) throws CompilationException {
        return this._compile((Expression)object, false);
    }

    @Override
    public OLValueExpression compileLValue(Object object) throws CompilationException {
        return (OLValueExpression)this._compile((Expression)object, false);
    }

    private OExpression _compile(Expression expression, boolean bl) throws CompilationException {
        OXQuery10ExpressionBPEL20 oXQuery10ExpressionBPEL20 = new OXQuery10ExpressionBPEL20(this._compilerContext.getOProcess(), this._qnVarData, this._qnVarProp, this._qnLinkStatus, this._qnXslTransform, bl);
        oXQuery10ExpressionBPEL20.namespaceCtx = expression.getNamespaceContext();
        this.doJaxpCompile(oXQuery10ExpressionBPEL20, expression);
        return oXQuery10ExpressionBPEL20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJaxpCompile(OXQuery10ExpressionBPEL20 oXQuery10ExpressionBPEL20, Expression expression) throws CompilationException {
        Node node = expression.getExpression();
        if (node == null) {
            throw new CompilationException(this.__msgs.errEmptyExpression(expression.getURI(), new QName(expression.getElement().getNamespaceURI(), expression.getElement().getNodeName())));
        }
        if (node.getNodeType() != 3 && node.getNodeType() != 1 && node.getNodeType() != 4) {
            throw new CompilationException(this.__msgs.errUnexpectedNodeTypeForXPath(DOMUtils.domToString((Node)node)));
        }
        String string = DOMUtils.domToString((Node)node);
        if ((string = string.trim()).length() == 0) {
            throw new CompilationException(this.__msgs.warnXPath20Syntax(DOMUtils.domToString((Node)node), "empty string"));
        }
        try {
            Object object;
            QName qName;
            Object object2;
            Object object322;
            SaxonXQDataSource saxonXQDataSource = new SaxonXQDataSource(new Configuration());
            XQConnection xQConnection = saxonXQDataSource.getConnection();
            __log.debug("Compiling expression " + string);
            Configuration configuration = ((SaxonXQConnection)xQConnection).getConfiguration();
            configuration.setAllNodesUntyped(true);
            configuration.setHostLanguage(51);
            XQStaticContext xQStaticContext = xQConnection.getStaticContext();
            JaxpFunctionResolver jaxpFunctionResolver = new JaxpFunctionResolver(this._compilerContext, (OXPath20ExpressionBPEL20)oXQuery10ExpressionBPEL20, expression.getNamespaceContext(), this._bpelNS);
            JaxpVariableResolver jaxpVariableResolver = new JaxpVariableResolver(this._compilerContext, (OXPath10ExpressionBPEL20)oXQuery10ExpressionBPEL20);
            XQueryDeclarations xQueryDeclarations = new XQueryDeclarations();
            NSContext nSContext = expression.getNamespaceContext();
            Set set = nSContext.getPrefixes();
            if (!nSContext.getUriSet().contains(Namespaces.ODE_EXTENSION_NS)) {
                nSContext.register("ode", Namespaces.ODE_EXTENSION_NS);
            }
            for (Object object322 : set) {
                object2 = nSContext.getNamespaceURI((String)object322);
                xQStaticContext.declareNamespace((String)object322, (String)object2);
                if ("".equals(object322)) {
                    xQueryDeclarations.declareDefaultElementNamespace((String)object2);
                    continue;
                }
                if ("bpws".equals(object322)) {
                    xQueryDeclarations.declareNamespace("bpws", "java:org.apache.ode.bpel.elang.xquery10.compiler.XQuery10BpelFunctions");
                    continue;
                }
                xQueryDeclarations.declareNamespace((String)object322, (String)object2);
            }
            xQueryDeclarations.declareVariable(this.getQName(nSContext, Namespaces.ODE_EXTENSION_NS, "pid"), this.getQName(nSContext, Namespaces.XML_SCHEMA, "integer"));
            configuration.setSchemaValidationMode(4);
            List<OScope.Variable> list = this._compilerContext.getAccessibleVariables();
            object322 = new HashMap();
            for (String qNameArray : XQuery10ExpressionCompilerImpl.getVariableNames(string)) {
                OScope.Variable variable = this.getVariable(list, qNameArray);
                if (variable == null) continue;
                OVarType oVarType = variable.type;
                QName qName2 = this.getNameQName(qNameArray);
                qName = this.getTypeQName(qNameArray, oVarType);
                object322.put(qName2, qName);
                object = qName.getPrefix();
                if (object == null || "".equals(((String)object).trim())) {
                    object = this.getPrefixForUri(nSContext, qName.getNamespaceURI());
                }
                xQueryDeclarations.declareVariable(qNameArray);
            }
            oXQuery10ExpressionBPEL20.xquery = xQueryDeclarations.toString() + string;
            xQConnection.setStaticContext(xQStaticContext);
            object2 = xQConnection.prepareExpression(oXQuery10ExpressionBPEL20.xquery);
            node.setUserData("function-resolver", jaxpFunctionResolver, null);
            object2.bindItem(XQConstants.CONTEXT_ITEM, xQConnection.createItemFromNode(node, xQConnection.createNodeType()));
            for (QName qName2 : object2.getAllUnboundExternalVariables()) {
                qName = (QName)object322.get(qName2);
                object = jaxpVariableResolver.resolveVariable(qName2);
                if (qName == null) continue;
                if (object.getClass().getName().startsWith("java.lang")) {
                    object2.bindAtomicValue(qName2, object.toString(), xQConnection.createAtomicType(4));
                    continue;
                }
                if (object instanceof Node) {
                    object2.bindNode(qName2, (Node)object, xQConnection.createNodeType());
                    continue;
                }
                if (!(object instanceof NodeList)) continue;
                NodeList nodeList = (NodeList)object;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add(nodeList.item(i));
                }
                XQSequence i = xQConnection.createSequence(arrayList.iterator());
                object2.bindSequence(qName2, i);
            }
            try {
                object2.executeQuery();
            }
            catch (XQException xQException) {
            }
            finally {
                if (node != null) {
                    node.setUserData("function-resolver", null, null);
                }
            }
        }
        catch (XQException xQException) {
            __log.error("Couldn't validate properly expression " + string, (Throwable)xQException);
            throw new CompilationException(this.__msgs.errXQuery10Syntax(string, "Couldn't validate XQuery expression"));
        }
        catch (WrappedResolverException wrappedResolverException) {
            if (wrappedResolverException._compilationMsg != null) {
                throw new CompilationException(wrappedResolverException._compilationMsg, (Throwable)wrappedResolverException);
            }
            if (wrappedResolverException.getCause() instanceof CompilationException) {
                throw (CompilationException)wrappedResolverException.getCause();
            }
            throw wrappedResolverException;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this._properties;
    }

    private String getQName(NSContext nSContext, String string, String string2) {
        String string3 = this.getPrefixForUri(nSContext, string);
        return string3 == null ? string2 : string3 + ":" + string2;
    }

    private String getPrefixForUri(NSContext nSContext, String string) {
        Set set = nSContext.getPrefixes();
        for (String string2 : set) {
            String string3 = nSContext.getNamespaceURI(string2);
            if (string3 == null || !string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    protected static Collection<String> getVariableNames(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = string.indexOf("$");
        while (n != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            ++n;
            while (n < string.length() && XMLChar.isNCName((int)string.charAt(n))) {
                stringBuilder.append(string.charAt(n++));
            }
            linkedHashSet.add(stringBuilder.toString());
            string = string.substring(n);
            n = string.indexOf("$");
        }
        return linkedHashSet;
    }

    private OScope.Variable getVariable(List<OScope.Variable> list, String string) {
        String string2 = this.getVariableDeclaredName(string);
        for (OScope.Variable variable : list) {
            if (!variable.name.equals(string2)) continue;
            return variable;
        }
        return null;
    }

    private String getVariableDeclaredName(String string) {
        int n = string.indexOf(".");
        return n >= 0 ? string.substring(0, n) : string;
    }

    private String getVariablePartName(String string) {
        int n = string.indexOf(".");
        return n >= 0 ? string.substring(n + 1) : "";
    }

    private QName getNameQName(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(":");
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = "";
            string3 = string;
        }
        return new QName(string2, string3);
    }

    private QName getTypeQName(String string, OVarType oVarType) {
        QName qName = null;
        if (oVarType instanceof OConstantVarType) {
            qName = new QName(Namespaces.XML_SCHEMA, "string", "xs");
        } else if (oVarType instanceof OElementVarType) {
            qName = ((OElementVarType)oVarType).elementType;
        } else if (oVarType instanceof OMessageVarType) {
            OMessageVarType.Part part = (OMessageVarType.Part)((OMessageVarType)oVarType).parts.get(this.getVariablePartName(string));
            if (part != null) {
                qName = this.getTypeQName(string, part.type);
            }
        } else if (oVarType instanceof OXsdTypeVarType) {
            qName = ((OXsdTypeVarType)oVarType).xsdType;
        }
        return qName;
    }

    private static class XQueryDeclarations {
        StringBuffer declarations = new StringBuffer();

        public void declareVariable(String string, QName qName) {
            this.declareVariable(string, qName.getPrefix() + ":" + qName.getLocalPart());
        }

        public void declareVariable(String string, String string2) {
            this.declarations.append("declare variable ").append("$").append(string).append(" as ").append(string2).append(" external ").append(";\n");
        }

        public void declareVariable(String string) {
            this.declarations.append("declare variable ").append("$").append(string).append(" external ").append(";\n");
        }

        public void declareNamespace(String string, String string2) {
            this.declarations.append("declare namespace ").append(string).append("=").append("\"" + string2 + "\"").append(";\n");
        }

        public void declareDefaultElementNamespace(String string) {
            this.declarations.append("declare default element namespace ").append("\"" + string + "\"").append(";\n");
        }

        public String toString() {
            return this.declarations.toString();
        }
    }
}

