/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.wsdl;

import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.bom.BpelObject4WSDL;
import org.apache.ode.bpel.compiler.bom.BpelObjectFactory;
import org.apache.ode.bpel.compiler.wsdl.Messages;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BpelExtensionSerializer
implements ExtensionDeserializer,
ExtensionSerializer {
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private BpelObjectFactory _factory;

    public BpelExtensionSerializer(BpelObjectFactory bpelObjectFactory) {
        this._factory = bpelObjectFactory;
    }

    public void marshall(Class clazz, QName qName, ExtensibilityElement extensibilityElement, PrintWriter printWriter, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        throw new UnsupportedOperationException();
    }

    public ExtensibilityElement unmarshall(Class clazz, QName qName, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        BpelObject4WSDL bpelObject4WSDL;
        BpelExtensionSerializer.validateExtensibilityElementContext(element);
        try {
            bpelObject4WSDL = (BpelObject4WSDL)this._factory.createBpelObject(element, new URI(definition.getDocumentBaseURI()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        bpelObject4WSDL.setElementType(qName);
        bpelObject4WSDL.setRequired(false);
        bpelObject4WSDL.setTargetNamespace(definition.getTargetNamespace());
        return bpelObject4WSDL;
    }

    protected static QName derefQName(String string, Element element) throws WSDLException {
        String string2;
        int n = string.indexOf(":");
        if (n == -1) {
            string2 = DOMUtils.getNamespaceURIFromPrefix((Node)element, null);
        } else {
            if (n >= string.length() || n == 0) {
                String string3 = __msgs.msgMalformedQName(string);
                throw new WSDLException("INVALID_WSDL", string3);
            }
            String string4 = string.substring(0, n);
            string2 = DOMUtils.getMyNSContext((Element)element).getNamespaceURI(string4);
            if (string2 == null) {
                String string5 = __msgs.msgInvalidNamespacePrefix(string4);
                throw new WSDLException("INVALID_WSDL", string5);
            }
        }
        return new QName(string2, string.substring(n + 1, string.length()));
    }

    static void validateExtensibilityElementContext(Element element) throws WSDLException {
        Node node = element.getParentNode();
        if (node == null || node.getNodeType() != 1) {
            WSDLException wSDLException = new WSDLException("OTHER_ERROR", __msgs.msgCannotBeDocumentRootElement(DOMUtils.getNodeQName((Node)element).toString()));
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            throw wSDLException;
        }
        Element element2 = (Element)node;
        if (element2.getNamespaceURI() == null || !element2.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !element2.getLocalName().equals("definitions")) {
            WSDLException wSDLException = new WSDLException("OTHER_ERROR", __msgs.msgMustBeChildOfDef(DOMUtils.getNodeQName((Node)element).toString()));
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            throw wSDLException;
        }
    }

    protected String getAttribute(Element element, String string) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }
}

