/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler.bom;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class LocalEntityResolver
implements EntityResolver {
    private static final Logger __log = LoggerFactory.getLogger(LocalEntityResolver.class);
    private final HashMap<String, URL> _mappings = new HashMap();

    LocalEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        URL uRL;
        if (__log.isTraceEnabled()) {
            __log.trace("resolveEntity(" + string + "," + string2 + ")");
        }
        if ((uRL = this._mappings.get(string2)) == null) {
            uRL = this._mappings.get(string);
        }
        if (uRL == null) {
            if (__log.isDebugEnabled()) {
                __log.debug("resolveEntity(" + string + "," + string2 + ") failed (resource not found) ");
            }
            throw new IOException("Resource not found: " + string + " : " + string2);
        }
        if (__log.isDebugEnabled()) {
            __log.debug("resolveEntity(" + string + "," + string2 + ") ==> target");
        }
        return new InputSource(uRL.openStream());
    }

    void register(String string, URL uRL) {
        if (string == null) {
            throw new NullPointerException("id arg must not be null!");
        }
        if (uRL == null) {
            throw new NullPointerException("location arg must not be null for id " + string);
        }
        if (__log.isDebugEnabled()) {
            __log.debug("mapping " + string + " ==> " + uRL);
        }
        this._mappings.put(string, uRL);
    }
}

