/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private static final Logger __log = LoggerFactory.getLogger(WSDLLocatorImpl.class);
    private ResourceFinder _resourceFinder;
    private URI _base;
    private String _latest;

    public WSDLLocatorImpl(ResourceFinder resourceFinder, URI uRI) {
        this._resourceFinder = resourceFinder;
        this._base = uRI;
    }

    public InputSource getBaseInputSource() {
        try {
            InputSource inputSource = new InputSource();
            inputSource.setByteStream(this._resourceFinder.openResource(this._base));
            inputSource.setSystemId(this._base.toString());
            return inputSource;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public InputSource getImportInputSource(String string, String string2) {
        URI uRI;
        try {
            uRI = string == null ? this._base.resolve(string2) : new URI(string).resolve(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            __log.error("URI syntax error: " + string);
            return null;
        }
        __log.debug("getImportInputSource: parent=" + string + ", imprt=" + string2 + ", uri=" + uRI);
        InputSource inputSource = new InputSource();
        try {
            inputSource.setByteStream(this._resourceFinder.openResource(uRI));
        }
        catch (Exception exception) {
            return null;
        }
        inputSource.setSystemId(uRI.toString());
        this._latest = uRI.toString();
        return inputSource;
    }

    public String getBaseURI() {
        return this._base.toString();
    }

    public String getLatestImportURI() {
        return this._latest;
    }

    public void close() {
        this._resourceFinder = null;
    }
}

