/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.PickGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OPickReceive;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;

abstract class PickReceiveGenerator
extends DefaultActivityGenerator {
    protected static final CommonCompilationMessages __cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    protected static final PickGeneratorMessages __cmsgs = (PickGeneratorMessages)MessageBundle.getMessages(PickGeneratorMessages.class);

    PickReceiveGenerator() {
    }

    @Override
    public OActivity newInstance(Activity activity) {
        return new OPickReceive(this._context.getOProcess(), this._context.getCurrent());
    }

    protected OPickReceive.OnMessage compileOnMessage(String string, String string2, String string3, String string4, QName qName, boolean bl, Collection<Correlation> collection, String string5) {
        OPickReceive.OnMessage onMessage = new OPickReceive.OnMessage(this._context.getOProcess());
        onMessage.partnerLink = this._context.resolvePartnerLink(string2);
        onMessage.operation = this._context.resolveMyRoleOperation(onMessage.partnerLink, string3);
        if (onMessage.operation.getInput() != null && onMessage.operation.getInput().getMessage() != null) {
            onMessage.variable = this._context.resolveMessageVariable(string, onMessage.operation.getInput().getMessage().getQName());
        }
        onMessage.messageExchangeId = string4;
        onMessage.route = string5;
        if (qName != null && !qName.equals(onMessage.partnerLink.myRolePortType.getQName())) {
            throw new CompilationException(__cmsgsGeneral.errPortTypeMismatch(qName, onMessage.partnerLink.myRolePortType.getQName()));
        }
        if (bl) {
            onMessage.partnerLink.addCreateInstanceOperation(onMessage.operation);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Correlation correlation : collection) {
            if (hashSet.contains(correlation.getCorrelationSet())) {
                throw new CompilationException(__cmsgsGeneral.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
            }
            OScope.CorrelationSet correlationSet = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    if (bl) {
                        throw new CompilationException(__cmsgsGeneral.errUseOfUninitializedCorrelationSet(correlation.getCorrelationSet()));
                    }
                    onMessage.matchCorrelations.add(correlationSet);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, correlationSet, false);
                    break;
                }
                case YES: {
                    onMessage.initCorrelations.add(correlationSet);
                    break;
                }
                case JOIN: {
                    correlationSet.hasJoinUseCases = true;
                    onMessage.joinCorrelations.add(correlationSet);
                    onMessage.partnerLink.addCorrelationSetForOperation(onMessage.operation, correlationSet, true);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected value for correlation set enumeration!");
                }
            }
            for (OProcess.OProperty oProperty : correlationSet.properties) {
                this._context.resolvePropertyAlias(onMessage.variable, oProperty.name);
            }
            hashSet.add(correlation.getCorrelationSet());
        }
        if (!onMessage.partnerLink.hasMyRole()) {
            throw new CompilationException(__cmsgsGeneral.errNoMyRoleOnReceivePartnerLink(onMessage.partnerLink.getName()));
        }
        return onMessage;
    }
}

