/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.iapi;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.o.OFailureHandling;
import org.apache.ode.utils.CronExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public interface ProcessConf {
    public QName getProcessId();

    public QName getType();

    public long getVersion();

    public boolean isTransient();

    public InputStream getCBPInputStream();

    public long getCBPFileSize();

    public String getBpelDocument();

    public URI getBaseURI();

    public Date getDeployDate();

    public String getDeployer();

    public ProcessState getState();

    public List<File> getFiles();

    public Map<QName, Node> getProcessProperties();

    public String getPackage();

    public Definition getDefinitionForService(QName var1);

    public Definition getDefinitionForPortType(QName var1);

    public Map<String, Endpoint> getProvideEndpoints();

    public Map<String, Endpoint> getInvokeEndpoints();

    public Map<String, PartnerRoleConfig> getPartnerRoleConfig();

    public boolean isSharedService(QName var1);

    public List<Element> getExtensionElement(QName var1);

    public boolean isEventEnabled(List<String> var1, BpelEvent.TYPE var2);

    public Map<String, String> getEndpointProperties(EndpointReference var1);

    public boolean isCleanupCategoryEnabled(boolean var1, CLEANUP_CATEGORY var2);

    public Set<CLEANUP_CATEGORY> getCleanupCategories(boolean var1);

    public List<CronJob> getCronJobs();

    public static class CleanupInfo
    implements Serializable {
        private List<String> _filters = new ArrayList<String>();
        private final Set<CLEANUP_CATEGORY> _categories = EnumSet.noneOf(CLEANUP_CATEGORY.class);

        public void setFilters(List<String> list) {
            this._filters = list;
        }

        public List<String> getFilters() {
            return this._filters;
        }

        public Set<CLEANUP_CATEGORY> getCategories() {
            return this._categories;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CleanupInfo: filters=");
            stringBuffer.append(this._filters);
            stringBuffer.append(", categories=");
            stringBuffer.append(this._categories);
            return stringBuffer.toString();
        }
    }

    public static class CronJob {
        private CronExpression _cronExpression;
        private final List<Scheduler.JobDetails> runnableDetailList = new ArrayList<Scheduler.JobDetails>();

        public void setCronExpression(CronExpression cronExpression) {
            this._cronExpression = cronExpression;
        }

        public CronExpression getCronExpression() {
            return this._cronExpression;
        }

        public List<Scheduler.JobDetails> getRunnableDetailList() {
            return this.runnableDetailList;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Cron[");
            stringBuffer.append(this._cronExpression);
            stringBuffer.append("] ");
            stringBuffer.append(this.runnableDetailList);
            return stringBuffer.toString();
        }
    }

    public static enum CLEANUP_CATEGORY {
        INSTANCE,
        VARIABLES,
        MESSAGES,
        CORRELATIONS,
        EVENTS;


        public static CLEANUP_CATEGORY fromString(String string) {
            return CLEANUP_CATEGORY.valueOf(CLEANUP_CATEGORY.class, string.toUpperCase());
        }
    }

    public static class PartnerRoleConfig {
        public final OFailureHandling failureHandling;
        public final boolean usePeer2Peer;

        public PartnerRoleConfig(OFailureHandling oFailureHandling, boolean bl) {
            this.failureHandling = oFailureHandling;
            this.usePeer2Peer = bl;
        }
    }
}

