/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.evt;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import org.apache.ode.bpel.evt.EventContext;
import org.apache.ode.utils.CollectionUtils;

public abstract class BpelEvent
implements Serializable {
    public transient EventContext eventContext;
    private Date _timestamp = new Date();
    private int _lineNo = -1;

    public int getLineNo() {
        return this._lineNo;
    }

    public void setLineNo(int n) {
        this._lineNo = n;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(Date date) {
        this._timestamp = date;
    }

    public String toString() {
        Method[] methodArray;
        StringBuilder stringBuilder = new StringBuilder("\n" + BpelEvent.eventName(this) + ":");
        for (Method method : methodArray = this.getClass().getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            try {
                String string = method.getName().substring(3);
                Object object = method.invoke((Object)this, CollectionUtils.EMPTY_OBJECT_ARRAY);
                if (object == null) continue;
                stringBuilder.append("\n\t").append(string).append(" = ").append(object == null ? "null" : object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    public static String eventName(BpelEvent bpelEvent) {
        String string = bpelEvent.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public abstract TYPE getType();

    public static enum TYPE {
        dataHandling,
        activityLifecycle,
        scopeHandling,
        instanceLifecycle,
        correlation;

    }
}

