/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.utils.xsd.SchemaModel;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.util.LSInputListImpl;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.LSInputList;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.ls.LSInput;

public class SchemaModelImpl
implements SchemaModel {
    private static final Logger __log = LoggerFactory.getLogger(SchemaModelImpl.class);
    private XSModel _model;

    private SchemaModelImpl(XSModel xSModel) {
        if (xSModel == null) {
            throw new IllegalArgumentException("Null model.");
        }
        this._model = xSModel;
    }

    public static final SchemaModel newModel(Map<URI, byte[]> map) {
        DOMInputImpl dOMInputImpl;
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        InternalSchemaResolver internalSchemaResolver = new InternalSchemaResolver();
        xMLSchemaLoader.setEntityResolver((XMLEntityResolver)internalSchemaResolver);
        xMLSchemaLoader.setParameter("error-handler", (Object)new SchemaErrorHandler());
        String[] stringArray = new String[map.size()];
        byte[][] byArrayArray = new byte[map.size()][];
        int n = 0;
        for (Map.Entry<URI, byte[]> entry : map.entrySet()) {
            stringArray[n] = entry.getKey().toASCIIString();
            byArrayArray[n] = entry.getValue();
            internalSchemaResolver.put(entry.getKey(), entry.getValue());
            ++n;
        }
        LSInput[] lSInputArray = new LSInput[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dOMInputImpl = new DOMInputImpl();
            dOMInputImpl.setSystemId(stringArray[i]);
            dOMInputImpl.setByteStream((InputStream)new ByteArrayInputStream(byArrayArray[i]));
            lSInputArray[i] = dOMInputImpl;
        }
        LSInputListImpl lSInputListImpl = new LSInputListImpl(lSInputArray, lSInputArray.length);
        dOMInputImpl = xMLSchemaLoader.loadInputList((LSInputList)lSInputListImpl);
        return new SchemaModelImpl((XSModel)dOMInputImpl);
    }

    @Override
    public boolean isCompatible(QName qName, QName qName2) {
        XSTypeDefinition xSTypeDefinition;
        XSTypeDefinition xSTypeDefinition2;
        if (this.knowsElementType(qName)) {
            xSTypeDefinition2 = this._model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(qName)) {
            xSTypeDefinition2 = this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + qName);
        }
        if (this.knowsElementType(qName2)) {
            xSTypeDefinition = this._model.getElementDeclaration(qName2.getLocalPart(), qName2.getNamespaceURI()).getTypeDefinition();
        } else if (this.knowsSchemaType(qName2)) {
            xSTypeDefinition = this._model.getTypeDefinition(qName2.getLocalPart(), qName2.getNamespaceURI());
        } else {
            throw new IllegalArgumentException("unknown schema type: " + qName2);
        }
        return xSTypeDefinition2.derivedFromType(xSTypeDefinition, (short)0) || xSTypeDefinition.derivedFromType(xSTypeDefinition2, (short)0);
    }

    @Override
    public boolean isSimpleType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        XSTypeDefinition xSTypeDefinition = this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI());
        return xSTypeDefinition != null && xSTypeDefinition.getTypeCategory() == 16;
    }

    @Override
    public boolean knowsElementType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI()) != null;
    }

    @Override
    public boolean knowsSchemaType(QName qName) {
        if (qName == null) {
            throw new NullPointerException("Null type argument!");
        }
        return this._model.getTypeDefinition(qName.getLocalPart(), qName.getNamespaceURI()) != null;
    }

    public static class InternalSchemaResolver
    implements XMLEntityResolver {
        private Map<String, byte[]> _schemas = new HashMap<String, byte[]>();

        public void put(URI uRI, byte[] byArray) {
            this._schemas.put(uRI.toASCIIString(), byArray);
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
            XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
            String string = "";
            if (xMLResourceIdentifier.getNamespace() != null && this._schemas.get(xMLResourceIdentifier.getNamespace()) != null) {
                string = xMLResourceIdentifier.getNamespace();
            } else if (xMLResourceIdentifier.getLiteralSystemId() != null && this._schemas.get(xMLResourceIdentifier.getLiteralSystemId()) != null) {
                string = xMLResourceIdentifier.getLiteralSystemId();
            } else if (xMLResourceIdentifier.getExpandedSystemId() != null && this._schemas.get(xMLResourceIdentifier.getExpandedSystemId()) != null) {
                string = xMLResourceIdentifier.getExpandedSystemId();
            } else if (xMLResourceIdentifier.getBaseSystemId() != null && this._schemas.get(xMLResourceIdentifier.getBaseSystemId()) != null) {
                string = xMLResourceIdentifier.getBaseSystemId();
            } else {
                if (__log.isDebugEnabled()) {
                    __log.debug("Available schemas " + this._schemas.keySet());
                }
                throw new IllegalStateException("Schema " + xMLResourceIdentifier + " not captured");
            }
            xMLInputSource.setByteStream((InputStream)new ByteArrayInputStream(this._schemas.get(string)));
            return xMLInputSource;
        }
    }

    private static class SchemaErrorHandler
    implements DOMErrorHandler {
        private SchemaErrorHandler() {
        }

        @Override
        public boolean handleError(DOMError dOMError) {
            boolean bl = dOMError.getSeverity() == 1;
            __log.warn("Schema error", (Throwable)((Exception)dOMError.getRelatedException()));
            __log.warn(dOMError.getLocation().getUri() + ":" + dOMError.getLocation().getLineNumber());
            __log.warn("", dOMError.getRelatedData());
            __log.warn("", dOMError.getRelatedException());
            return bl;
        }
    }
}

