/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    static final Pattern PATTERN = Pattern.compile("P(\\d+Y)?(\\d+M)?(\\d+D)?(T(\\d+H)?(\\d+M)?((\\d+\\.?\\d*|\\.\\d+)S)?)?");
    static final int YEAR_MG = 1;
    static final int MONTH_MG = 2;
    static final int DAY_MG = 3;
    static final int HOUR_MG = 5;
    static final int MIN_MG = 6;
    static final int SEC_MG = 8;
    private int _years;
    private int _months;
    private int _days;
    private int _hours;
    private int _minutes;
    private BigDecimal _seconds;

    public Duration(String string) {
        Matcher matcher = PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad duration: " + string);
        }
        this._years = Duration.parseInt(matcher.group(1));
        this._months = Duration.parseInt(matcher.group(2));
        this._days = Duration.parseInt(matcher.group(3));
        this._hours = Duration.parseInt(matcher.group(5));
        this._minutes = Duration.parseInt(matcher.group(6));
        this._seconds = matcher.group(8) == null ? null : new BigDecimal(matcher.group(8));
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this._years);
        calendar.add(2, this._months);
        calendar.add(5, this._days);
        calendar.add(10, this._hours);
        calendar.add(12, this._minutes);
        calendar.add(13, this._seconds == null ? 0 : this._seconds.intValue());
        if (this._seconds != null) {
            BigDecimal bigDecimal = this._seconds.subtract(this._seconds.setScale(0, 1));
            int n = bigDecimal.movePointRight(3).intValue();
            calendar.add(14, n);
        }
    }

    private static int parseInt(String string) {
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string.substring(0, string.length() - 1));
    }
}

