/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.sax;

import org.apache.ode.utils.msg.CommonMessages;
import org.apache.ode.utils.msg.MessageBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class LoggingErrorHandler
implements ErrorHandler {
    private static final Logger __log = LoggerFactory.getLogger(LoggingErrorHandler.class);
    private Logger _l;
    private static final String WARNING = MessageBundle.getMessages(CommonMessages.class).strWarning().toUpperCase();
    private static final String ERROR = MessageBundle.getMessages(CommonMessages.class).strError().toUpperCase();
    private static final String FATAL = MessageBundle.getMessages(CommonMessages.class).strFatal().toUpperCase();

    public LoggingErrorHandler() {
        this._l = __log;
    }

    public LoggingErrorHandler(Logger logger) {
        this._l = logger;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug(this.formatMessage(WARNING, sAXParseException));
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug(this.formatMessage(ERROR, sAXParseException));
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this._l.isDebugEnabled()) {
            this._l.debug(this.formatMessage(FATAL, sAXParseException));
        }
    }

    private String formatMessage(String string, SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (sAXParseException.getSystemId() != null) {
            stringBuffer.append(sAXParseException.getSystemId());
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        stringBuffer.append(':');
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getMessage());
        return stringBuffer.toString();
    }
}

