/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.fs;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger __log = LoggerFactory.getLogger(FileUtils.class);

    public static boolean isAbsolute(String string) {
        return new File(string).isAbsolute();
    }

    public static boolean isRelative(String string) {
        return !FileUtils.isAbsolute(string);
    }

    public static boolean deepDelete(File file) {
        if (file.exists()) {
            if (__log.isDebugEnabled()) {
                __log.debug("deleting: " + file.getAbsolutePath());
            }
            if (file.delete()) {
                return true;
            }
            if (file.isDirectory()) {
                boolean bl = true;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    bl &= FileUtils.deepDelete(fileArray[i]);
                }
                return bl ? file.delete() : false;
            }
            __log.error("Unable to deepDelete file " + file.getAbsolutePath() + "; this may be caused by a descriptor leak and should be reported.");
            return false;
        }
        return true;
    }

    public static List<File> directoryEntriesInPath(File file) {
        return FileUtils.directoryEntriesInPath(file, null);
    }

    public static List<File> directoryEntriesInPath(File file, FileFilter fileFilter) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null!");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist!");
        }
        ArrayList<File> arrayList = new ArrayList<File>(32);
        if (file.isFile()) {
            if (fileFilter == null || fileFilter != null && fileFilter.accept(file)) {
                arrayList.add(file);
            }
            return arrayList;
        }
        FileUtils.directoryEntriesInPath(arrayList, file, fileFilter);
        return arrayList;
    }

    private static void directoryEntriesInPath(List<File> list, File file, FileFilter fileFilter) {
        File[] fileArray;
        if (fileFilter == null || fileFilter != null && fileFilter.accept(file)) {
            list.add(file);
        }
        if ((fileArray = file.listFiles()) != null) {
            TreeSet<File> treeSet = new TreeSet<File>();
            TreeSet<File> treeSet2 = new TreeSet<File>();
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    treeSet.add(file2);
                    continue;
                }
                if (fileFilter != null && (fileFilter == null || !fileFilter.accept(file2))) continue;
                treeSet2.add(file2);
            }
            list.addAll(treeSet2);
            for (File file3 : treeSet) {
                FileUtils.directoryEntriesInPath(list, file3, fileFilter);
            }
        }
    }

    public static String encodePath(String string) {
        return string.replaceAll(" ", "%20");
    }

    public static void main(String[] stringArray) {
        List<File> list = FileUtils.directoryEntriesInPath(new File("/tmp/test"));
        for (File object2 : list) {
            System.out.println(object2);
        }
        System.out.println("########");
        TreeSet<File> treeSet = new TreeSet<File>(list);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            System.out.println(file);
        }
    }
}

