/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class FlagWithArgument
implements CommandlineFragment {
    private String _name;
    private String _argName;
    private String _description;
    private String _arg;
    private boolean _isOptional = false;

    public FlagWithArgument(String string, String string2, String string3, boolean bl) {
        this._name = "-" + string;
        this._description = string3;
        this._argName = string2;
        this._isOptional = bl;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    public void setOptional(boolean bl) {
        this._isOptional = bl;
    }

    @Override
    public List<String> consume(List<String> list) throws CommandlineSyntaxException {
        if (!list.contains(this._name)) {
            if (!this._isOptional) {
                throw new CommandlineSyntaxException("The " + this._name + " flag with an argument is required.");
            }
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        int n = arrayList.indexOf(this._name);
        if (n == arrayList.size() - 1 || arrayList.get(n + 1).startsWith("-")) {
            throw new CommandlineSyntaxException("The " + this._name + " flag requires an argument.");
        }
        this._arg = arrayList.get(n + 1);
        arrayList.remove(n + 1);
        arrayList.remove(n);
        return arrayList;
    }

    @Override
    public void reset() {
        this._arg = null;
    }

    public boolean isSet() {
        return this._arg != null;
    }

    public String getValue() {
        return this._arg;
    }

    @Override
    public String getUsage() {
        return this._name + " <" + this._argName + ">";
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public boolean validate() {
        return true;
    }
}

