/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.ode.utils.Version;
import org.apache.ode.utils.cli.CommandLineMessages;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.Flag;
import org.apache.ode.utils.cli.Fragments;
import org.apache.ode.utils.cli.XorGroup;
import org.apache.ode.utils.fs.TempFileManager;
import org.apache.ode.utils.msg.MessageBundle;

public abstract class BaseCommandlineTool {
    public static final int TERSE = 0;
    public static final int VERBOSE = 1;
    public static final int EFFUSIVE = 2;
    private static boolean _tempFileManagerRegistered = false;
    private static Class CLAZZ = BaseCommandlineTool.class;
    private static final String LOGGING_PATTERN = "%p - %d{ISO8601} - <%c> %m%n";
    protected static final Flag HELP_FLAG = new Flag("h", "print usage and help to the console and exit.", false);
    protected static final Fragments HELP = new Fragments(new CommandlineFragment[]{HELP_FLAG});
    protected static final Flag QUIET_F = new Flag("q", "only produce error output in the event of an error.", false);
    protected static final Flag VERBOSE_F = new Flag("v", "produce verbose (INFO-level) logging output.", false);
    protected static final Flag VERYVERBOSE_F = new Flag("vv", "product effusive (DEBUG-level) logging output", false);
    protected static final XorGroup LOGGING = new XorGroup("set logging output verbosity from quiet (-q), to verbose (-v), to effusive (-vv).", true);
    private static final CommandLineMessages __msgs;

    public static void outputHeader() {
        if (QUIET_F.isSet()) {
            return;
        }
        System.out.println(__msgs.msgCliHeader(BaseCommandlineTool.getProgramName(), Version.getVersionName(), Version.getBuildDate()));
    }

    protected static void initLogging(int n) {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig loggerConfig = configuration.getLoggerConfig("");
        PatternLayout patternLayout = PatternLayout.createLayout((String)LOGGING_PATTERN, (Configuration)configuration, null, (Charset)Charset.forName("UTF-8"), (boolean)true, (boolean)false, null, null);
        ConsoleAppender consoleAppender = ConsoleAppender.createAppender((Layout)patternLayout, null, (String)"SYSTEM_OUT", (String)"stderr appender", (String)"false", (String)"true");
        AppenderRef appenderRef = BaseCommandlineTool.initialize("stderr appender", n);
        AppenderRef[] appenderRefArray = new AppenderRef[]{appenderRef};
        loggerConfig.addAppender((Appender)consoleAppender, appenderRef.getLevel(), null);
        loggerConfig.setLevel(appenderRef.getLevel());
        loggerContext.updateLoggers();
    }

    protected static void initLogFile() throws IOException {
        BaseCommandlineTool.initLogFile(BaseCommandlineTool.getLevel());
    }

    protected static void initLogFile(int n) throws IOException {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig loggerConfig = configuration.getLoggerConfig("");
        PatternLayout patternLayout = PatternLayout.createLayout((String)LOGGING_PATTERN, (Configuration)configuration, null, (Charset)Charset.forName("UTF-8"), (boolean)true, (boolean)false, null, null);
        FileAppender fileAppender = FileAppender.createAppender((String)(System.getProperty("ode.home") + "/logs/ode.log"), (String)"false", (String)"false", (String)"File", (String)"false", (String)"true", (String)"true", (String)"8192", (Layout)patternLayout, null, (String)"false", null, (Configuration)configuration);
        AppenderRef appenderRef = BaseCommandlineTool.initialize("File", n);
        AppenderRef[] appenderRefArray = new AppenderRef[]{appenderRef};
        loggerConfig.addAppender((Appender)fileAppender, appenderRef.getLevel(), null);
        loggerConfig.setLevel(appenderRef.getLevel());
        loggerContext.updateLoggers();
    }

    private static AppenderRef initialize(String string, int n) {
        Level level = null;
        switch (n) {
            case 2: {
                level = Level.DEBUG;
                break;
            }
            case 1: {
                level = Level.INFO;
                break;
            }
            default: {
                level = Level.WARN;
            }
        }
        return AppenderRef.createAppenderRef((String)string, (Level)level, null);
    }

    protected static void setClazz(Class clazz) {
        CLAZZ = clazz;
    }

    protected static String getProgramName() {
        return "java " + CLAZZ.getName();
    }

    protected static void initLogging() {
        BaseCommandlineTool.initLogging(BaseCommandlineTool.getLevel());
    }

    private static int getLevel() {
        if (QUIET_F.isSet()) {
            return 0;
        }
        if (VERBOSE_F.isSet()) {
            return 1;
        }
        if (VERYVERBOSE_F.isSet()) {
            return 2;
        }
        return -1;
    }

    protected static final synchronized void registerTempFileManager() {
        if (!_tempFileManagerRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    TempFileManager.cleanup();
                }
            });
        }
    }

    protected static void consoleErr(String string) {
        String string2 = BaseCommandlineTool.getProgramName();
        System.err.println(string2 + ": " + string);
    }

    static {
        LOGGING.addFragment(QUIET_F);
        LOGGING.addFragment(VERBOSE_F);
        LOGGING.addFragment(VERYVERBOSE_F);
        __msgs = MessageBundle.getMessages(CommandLineMessages.class);
    }
}

