/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ode.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDog<T, C extends Observer>
implements Runnable {
    public static final long DEFAULT_DELAY = 30000L;
    final Logger log = LoggerFactory.getLogger(WatchDog.class);
    private long expire;
    private T lastModif;
    private long delay = 30000L;
    private boolean existedBefore;
    private boolean warnedAlready;
    private boolean interrupted;
    protected Mutable<T> mutable;
    protected C observer;

    public WatchDog() {
    }

    public WatchDog(Mutable<T> mutable, long l) {
        this(mutable);
        this.delay = l;
    }

    public WatchDog(Mutable<T> mutable, C c) {
        this.mutable = mutable;
        this.observer = c;
    }

    public WatchDog(Mutable<T> mutable) {
        this.mutable = mutable;
    }

    public Mutable<T> getMutable() {
        return this.mutable;
    }

    public C getObserver() {
        return this.observer;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    @Override
    public void run() {
        try {
            while (!this.interrupted) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.check();
            }
        }
        catch (Exception exception) {
            this.log.warn("Exception occured. Thread will stop", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void check() {
        long l = System.currentTimeMillis();
        if (this.expire <= l) {
            this.observer.getLock().lock();
            this.expire = l + this.delay;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[" + this.mutable + "] check for changes");
                }
                if (this.mutable.exists()) {
                    this.existedBefore = true;
                    if (this.lastModif == null || this.mutable.hasChangedSince(this.lastModif)) {
                        this.lastModif = this.mutable.lastModified();
                        this.observer.onUpdate();
                        if (this.log.isInfoEnabled()) {
                            this.log.info("[" + this.mutable + "] updated");
                        }
                        this.warnedAlready = false;
                        return;
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug("[" + this.mutable + "] has not changed");
                    return;
                }
                if (!this.observer.isInitialized()) {
                    this.observer.init();
                    if (!this.log.isInfoEnabled()) return;
                    this.log.info("[" + this.mutable + "] initialized");
                    return;
                }
                if (this.existedBefore) {
                    this.existedBefore = false;
                    this.lastModif = null;
                    this.observer.onDelete();
                    if (this.log.isInfoEnabled()) {
                        this.log.info("[" + this.mutable + "] deleted");
                    }
                }
                if (this.warnedAlready) return;
                this.warnedAlready = true;
                if (!this.log.isInfoEnabled()) return;
                this.log.info("[" + this.mutable + "] does not exist.");
                return;
            }
            catch (Exception exception) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("[" + this.mutable + "] exception occurred during check.", (Throwable)exception);
                }
                this.expire = 0L;
                this.lastModif = null;
                this.existedBefore = false;
                this.warnedAlready = false;
                this.observer.reset();
                if (!this.log.isInfoEnabled()) throw new RuntimeException(exception);
                this.log.info("[" + this.mutable + "] resetted.");
                throw new RuntimeException(exception);
            }
            finally {
                this.observer.getLock().unlock();
            }
        } else {
            if (!this.log.isTraceEnabled()) return;
            this.log.trace("[" + this.mutable + "] wait period is not over");
        }
    }

    public static <C extends Observer> WatchDog<Long, C> watchFile(File file, C c) {
        return new WatchDog<Long, C>(new FileMutable(file), c);
    }

    public static <C extends Observer> WatchDog<Map<File, Long>, C> watchFiles(List<File> list, C c) {
        return new WatchDog<Map<File, Long>, C>(new FileSetMutable(list), c);
    }

    public static class DefaultObserver<A>
    implements Observer<A> {
        protected final ReadWriteLock lock = new ReentrantReadWriteLock();
        protected A object;

        @Override
        public boolean isInitialized() {
            return this.object != null;
        }

        @Override
        public void init() {
        }

        @Override
        public void reset() {
            this.object = null;
        }

        @Override
        public void onDelete() {
            this.init();
        }

        @Override
        public void onUpdate() {
            this.init();
        }

        @Override
        public Lock getLock() {
            return this.lock.writeLock();
        }

        @Override
        public A get() {
            this.lock.readLock().lock();
            try {
                A a = this.object;
                return a;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public static interface Observer<A> {
        public boolean isInitialized();

        public void init();

        public void reset();

        public void onDelete();

        public void onUpdate();

        public Lock getLock();

        public A get();
    }

    public static class FileSetMutable
    implements Mutable<Map<File, Long>> {
        File[] files;

        public FileSetMutable(Collection<File> collection) {
            this.files = new File[collection.size()];
            collection.toArray(this.files);
        }

        public FileSetMutable(File[] fileArray) {
            this.files = fileArray;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean hasChangedSince(Map<File, Long> map) {
            Object object = this.lastModified();
            return !CollectionUtils.equals((Map)object, map);
        }

        @Override
        public Map<File, Long> lastModified() {
            HashMap<File, Long> hashMap = new HashMap<File, Long>(this.files.length * 15 / 10);
            for (File file : this.files) {
                hashMap.put(file, file.lastModified());
            }
            return hashMap;
        }
    }

    public static class FileMutable
    implements Mutable<Long> {
        File file;

        public FileMutable(File file) {
            this.file = file;
        }

        @Override
        public boolean exists() {
            return this.file.exists();
        }

        @Override
        public boolean hasChangedSince(Long l) {
            return this.lastModified().longValue() != l.longValue();
        }

        @Override
        public Long lastModified() {
            return this.file.lastModified();
        }

        public String toString() {
            return this.file.toString();
        }
    }

    public static interface Mutable<T> {
        public boolean exists();

        public boolean hasChangedSince(T var1);

        public T lastModified();
    }
}

