/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.sound.MP3Frame;
import com.anotherbigidea.flash.sound.SoundDefinition;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class MP3Helper {
    public static SoundDefinition getSoundDefinition(InputStream inputStream) throws IOException {
        MP3Frame mP3Frame = MP3Frame.readFrame(inputStream);
        int n = mP3Frame.getSampleRate();
        boolean bl = mP3Frame.isStereo();
        int n2 = 0;
        if (n >= 44000) {
            n2 = 3;
        } else if (n >= 22000) {
            n2 = 2;
        } else if (n >= 11000) {
            n2 = 1;
        }
        int n3 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (mP3Frame != null) {
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            while (mP3Frame != null) {
                n3 += mP3Frame.getSamplesPerFrame();
                mP3Frame.write(byteArrayOutputStream);
                mP3Frame = MP3Frame.readFrame(inputStream);
            }
            byteArrayOutputStream.flush();
        }
        inputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new SoundDefinition(2, n2, true, bl, n3, byArray);
    }

    public static SoundStreamHead streamingBlocks(InputStream inputStream, int n, ArrayList arrayList) throws IOException {
        MP3Frame mP3Frame = MP3Frame.readFrame(inputStream);
        int n2 = mP3Frame.getSampleRate();
        int n3 = 0;
        int n4 = n2 / n;
        boolean bl = mP3Frame.isStereo();
        int n5 = 0;
        if (n2 >= 44000) {
            n5 = 3;
        } else if (n2 >= 22000) {
            n5 = 2;
        } else if (n2 >= 11000) {
            n5 = 1;
        }
        SoundStreamHead soundStreamHead = new SoundStreamHead(n5, true, bl, 2, n5, true, bl, n4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (mP3Frame != null) {
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            int n6 = 0;
            int n7 = n4 * (arrayList.size() + 1);
            while (mP3Frame != null && n3 + n6 < n7) {
                n6 += mP3Frame.getSamplesPerFrame();
                mP3Frame.write(byteArrayOutputStream);
                mP3Frame = MP3Frame.readFrame(inputStream);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray[0] = (byte)(n6 & 0xFF);
            byArray[1] = (byte)(n6 >> 8);
            n3 += n6;
            arrayList.add(byArray);
            byteArrayOutputStream.reset();
        }
        inputStream.close();
        double d = (double)n3 / (double)n2;
        int n8 = (int)(d * (double)n);
        while (arrayList.size() < n8) {
            arrayList.add(null);
        }
        return soundStreamHead;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        SWFWriter sWFWriter = new SWFWriter(stringArray[1]);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        tagWriter.header(5, -1L, 2000, 2000, 30, -1);
        tagWriter.tagSetBackgroundColor(new Color(255, 255, 255));
        ArrayList arrayList = new ArrayList();
        SoundStreamHead soundStreamHead = MP3Helper.streamingBlocks(fileInputStream, 30, arrayList);
        Iterator iterator = arrayList.iterator();
        soundStreamHead.write(tagWriter);
        if (iterator.hasNext()) {
            object = (byte[])iterator.next();
            tagWriter.tagSoundStreamBlock((byte[])object);
        }
        tagWriter.tagShowFrame();
        while (iterator.hasNext()) {
            object = (byte[])iterator.next();
            tagWriter.tagSoundStreamBlock((byte[])object);
            tagWriter.tagShowFrame();
        }
        object = tagWriter.tagDoAction();
        SWFActionBlock sWFActionBlock = object.start(0);
        sWFActionBlock.stop();
        sWFActionBlock.end();
        object.done();
        tagWriter.tagShowFrame();
        tagWriter.tagEnd();
    }
}

