/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
/**
 * Autogenerated by Avro
 * 
 * DO NOT EDIT DIRECTLY
 */
package org.apache.nutch.storage;

@SuppressWarnings("all")
/** A nested container representing parse status data captured from invocation of parsers on fetch of a WebPage */
public class ParseStatus extends
    org.apache.gora.persistency.impl.PersistentBase implements
    org.apache.avro.specific.SpecificRecord,
    org.apache.gora.persistency.Persistent {
  public static final org.apache.avro.Schema SCHEMA$ = new org.apache.avro.Schema.Parser()
      .parse("{\"type\":\"record\",\"name\":\"ParseStatus\",\"namespace\":\"org.apache.nutch.storage\",\"doc\":\"A nested container representing parse status data captured from invocation of parsers on fetch of a WebPage\",\"fields\":[{\"name\":\"majorCode\",\"type\":\"int\",\"doc\":\"Major parsing status' including NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded), FAILED (General failure. There may be a more specific error message in arguments.)\",\"default\":0},{\"name\":\"minorCode\",\"type\":\"int\",\"doc\":\"Minor parsing status' including SUCCESS_OK - Successful parse devoid of anomalies or issues, SUCCESS_REDIRECT - Parsed content contains a directive to redirect to another URL. The target URL can be retrieved from the arguments., FAILED_EXCEPTION - Parsing failed. An Exception occured which may be retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content was truncated, but the parser cannot handle incomplete content., FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed. Other related parts of the content are needed to complete parsing. The list of URLs to missing parts may be provided in arguments. The Fetcher may decide to fetch these parts at once, then put them into Content.metadata, and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed. There was no content to be parsed - probably caused by errors at protocol stage.\",\"default\":0},{\"name\":\"args\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"Optional arguments supplied to compliment and/or justify the parse status code.\",\"default\":[]}]}");

  /** Enum containing all data bean's fields. */
  public static enum Field {
    MAJOR_CODE(0, "majorCode"), MINOR_CODE(1, "minorCode"), ARGS(2, "args"), ;
    /**
     * Field's index.
     */
    private int index;

    /**
     * Field's name.
     */
    private String name;

    /**
     * Field's constructor
     * 
     * @param index
     *          field's index.
     * @param name
     *          field's name.
     */
    Field(int index, String name) {
      this.index = index;
      this.name = name;
    }

    /**
     * Gets field's index.
     * 
     * @return int field's index.
     */
    public int getIndex() {
      return index;
    }

    /**
     * Gets field's name.
     * 
     * @return String field's name.
     */
    public String getName() {
      return name;
    }

    /**
     * Gets field's attributes to string.
     * 
     * @return String field's attributes to string.
     */
    public String toString() {
      return name;
    }
  };

  public static final String[] _ALL_FIELDS = { "majorCode", "minorCode",
      "args", };

  /**
   * Gets the total field count.
   * 
   * @return int field count
   */
  public int getFieldsCount() {
    return ParseStatus._ALL_FIELDS.length;
  }

  /**
   * Major parsing status' including NOTPARSED (Parsing was not performed),
   * SUCCESS (Parsing succeeded), FAILED (General failure. There may be a more
   * specific error message in arguments.)
   */
  private int majorCode;
  /**
   * Minor parsing status' including SUCCESS_OK - Successful parse devoid of
   * anomalies or issues, SUCCESS_REDIRECT - Parsed content contains a directive
   * to redirect to another URL. The target URL can be retrieved from the
   * arguments., FAILED_EXCEPTION - Parsing failed. An Exception occured which
   * may be retrieved from the arguments., FAILED_TRUNCATED - Parsing failed.
   * Content was truncated, but the parser cannot handle incomplete content.,
   * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may
   * be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed. Other
   * related parts of the content are needed to complete parsing. The list of
   * URLs to missing parts may be provided in arguments. The Fetcher may decide
   * to fetch these parts at once, then put them into Content.metadata, and
   * supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed. There
   * was no content to be parsed - probably caused by errors at protocol stage.
   */
  private int minorCode;
  /**
   * Optional arguments supplied to compliment and/or justify the parse status
   * code.
   */
  private java.util.List<java.lang.CharSequence> args;

  public org.apache.avro.Schema getSchema() {
    return SCHEMA$;
  }

  // Used by DatumWriter. Applications should not call.
  public java.lang.Object get(int field$) {
    switch (field$) {
    case 0:
      return majorCode;
    case 1:
      return minorCode;
    case 2:
      return args;
    default:
      throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  // Used by DatumReader. Applications should not call.
  @SuppressWarnings(value = "unchecked")
  public void put(int field$, java.lang.Object value) {
    switch (field$) {
    case 0:
      majorCode = (java.lang.Integer) (value);
      break;
    case 1:
      minorCode = (java.lang.Integer) (value);
      break;
    case 2:
      args = (java.util.List<java.lang.CharSequence>) ((value instanceof org.apache.gora.persistency.Dirtyable) ? value
          : new org.apache.gora.persistency.impl.DirtyListWrapper(
              (java.util.List) value));
      break;
    default:
      throw new org.apache.avro.AvroRuntimeException("Bad index");
    }
  }

  /**
   * Gets the value of the 'majorCode' field. Major parsing status' including
   * NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded), FAILED
   * (General failure. There may be a more specific error message in arguments.)
   */
  public java.lang.Integer getMajorCode() {
    return majorCode;
  }

  /**
   * Sets the value of the 'majorCode' field. Major parsing status' including
   * NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded), FAILED
   * (General failure. There may be a more specific error message in arguments.)
   * * @param value the value to set.
   */
  public void setMajorCode(java.lang.Integer value) {
    this.majorCode = value;
    setDirty(0);
  }

  /**
   * Checks the dirty status of the 'majorCode' field. A field is dirty if it
   * represents a change that has not yet been written to the database. Major
   * parsing status' including NOTPARSED (Parsing was not performed), SUCCESS
   * (Parsing succeeded), FAILED (General failure. There may be a more specific
   * error message in arguments.) * @param value the value to set.
   */
  public boolean isMajorCodeDirty(java.lang.Integer value) {
    return isDirty(0);
  }

  /**
   * Gets the value of the 'minorCode' field. Minor parsing status' including
   * SUCCESS_OK - Successful parse devoid of anomalies or issues,
   * SUCCESS_REDIRECT - Parsed content contains a directive to redirect to
   * another URL. The target URL can be retrieved from the arguments.,
   * FAILED_EXCEPTION - Parsing failed. An Exception occured which may be
   * retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content
   * was truncated, but the parser cannot handle incomplete content.,
   * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may
   * be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed.
   * Other related parts of the content are needed to complete parsing. The list
   * of URLs to missing parts may be provided in arguments. The Fetcher may
   * decide to fetch these parts at once, then put them into Content.metadata,
   * and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed.
   * There was no content to be parsed - probably caused by errors at protocol
   * stage.
   */
  public java.lang.Integer getMinorCode() {
    return minorCode;
  }

  /**
   * Sets the value of the 'minorCode' field. Minor parsing status' including
   * SUCCESS_OK - Successful parse devoid of anomalies or issues,
   * SUCCESS_REDIRECT - Parsed content contains a directive to redirect to
   * another URL. The target URL can be retrieved from the arguments.,
   * FAILED_EXCEPTION - Parsing failed. An Exception occured which may be
   * retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content
   * was truncated, but the parser cannot handle incomplete content.,
   * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may
   * be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed.
   * Other related parts of the content are needed to complete parsing. The list
   * of URLs to missing parts may be provided in arguments. The Fetcher may
   * decide to fetch these parts at once, then put them into Content.metadata,
   * and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed.
   * There was no content to be parsed - probably caused by errors at protocol
   * stage. * @param value the value to set.
   */
  public void setMinorCode(java.lang.Integer value) {
    this.minorCode = value;
    setDirty(1);
  }

  /**
   * Checks the dirty status of the 'minorCode' field. A field is dirty if it
   * represents a change that has not yet been written to the database. Minor
   * parsing status' including SUCCESS_OK - Successful parse devoid of anomalies
   * or issues, SUCCESS_REDIRECT - Parsed content contains a directive to
   * redirect to another URL. The target URL can be retrieved from the
   * arguments., FAILED_EXCEPTION - Parsing failed. An Exception occured which
   * may be retrieved from the arguments., FAILED_TRUNCATED - Parsing failed.
   * Content was truncated, but the parser cannot handle incomplete content.,
   * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may
   * be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed.
   * Other related parts of the content are needed to complete parsing. The list
   * of URLs to missing parts may be provided in arguments. The Fetcher may
   * decide to fetch these parts at once, then put them into Content.metadata,
   * and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed.
   * There was no content to be parsed - probably caused by errors at protocol
   * stage. * @param value the value to set.
   */
  public boolean isMinorCodeDirty(java.lang.Integer value) {
    return isDirty(1);
  }

  /**
   * Gets the value of the 'args' field. Optional arguments supplied to
   * compliment and/or justify the parse status code.
   */
  public java.util.List<java.lang.CharSequence> getArgs() {
    return args;
  }

  /**
   * Sets the value of the 'args' field. Optional arguments supplied to
   * compliment and/or justify the parse status code. * @param value the value
   * to set.
   */
  public void setArgs(java.util.List<java.lang.CharSequence> value) {
    this.args = (value instanceof org.apache.gora.persistency.Dirtyable) ? value
        : new org.apache.gora.persistency.impl.DirtyListWrapper(value);
    setDirty(2);
  }

  /**
   * Checks the dirty status of the 'args' field. A field is dirty if it
   * represents a change that has not yet been written to the database. Optional
   * arguments supplied to compliment and/or justify the parse status code. * @param
   * value the value to set.
   */
  public boolean isArgsDirty(java.util.List<java.lang.CharSequence> value) {
    return isDirty(2);
  }

  /** Creates a new ParseStatus RecordBuilder */
  public static org.apache.nutch.storage.ParseStatus.Builder newBuilder() {
    return new org.apache.nutch.storage.ParseStatus.Builder();
  }

  /** Creates a new ParseStatus RecordBuilder by copying an existing Builder */
  public static org.apache.nutch.storage.ParseStatus.Builder newBuilder(
      org.apache.nutch.storage.ParseStatus.Builder other) {
    return new org.apache.nutch.storage.ParseStatus.Builder(other);
  }

  /**
   * Creates a new ParseStatus RecordBuilder by copying an existing ParseStatus
   * instance
   */
  public static org.apache.nutch.storage.ParseStatus.Builder newBuilder(
      org.apache.nutch.storage.ParseStatus other) {
    return new org.apache.nutch.storage.ParseStatus.Builder(other);
  }

  private static java.nio.ByteBuffer deepCopyToReadOnlyBuffer(
      java.nio.ByteBuffer input) {
    java.nio.ByteBuffer copy = java.nio.ByteBuffer.allocate(input.capacity());
    int position = input.position();
    input.reset();
    int mark = input.position();
    int limit = input.limit();
    input.rewind();
    input.limit(input.capacity());
    copy.put(input);
    input.rewind();
    copy.rewind();
    input.position(mark);
    input.mark();
    copy.position(mark);
    copy.mark();
    input.position(position);
    copy.position(position);
    input.limit(limit);
    copy.limit(limit);
    return copy.asReadOnlyBuffer();
  }

  /**
   * RecordBuilder for ParseStatus instances.
   */
  public static class Builder extends
      org.apache.avro.specific.SpecificRecordBuilderBase<ParseStatus> implements
      org.apache.avro.data.RecordBuilder<ParseStatus> {

    private int majorCode;
    private int minorCode;
    private java.util.List<java.lang.CharSequence> args;

    /** Creates a new Builder */
    private Builder() {
      super(org.apache.nutch.storage.ParseStatus.SCHEMA$);
    }

    /** Creates a Builder by copying an existing Builder */
    private Builder(org.apache.nutch.storage.ParseStatus.Builder other) {
      super(other);
    }

    /** Creates a Builder by copying an existing ParseStatus instance */
    private Builder(org.apache.nutch.storage.ParseStatus other) {
      super(org.apache.nutch.storage.ParseStatus.SCHEMA$);
      if (isValidValue(fields()[0], other.majorCode)) {
        this.majorCode = (java.lang.Integer) data().deepCopy(
            fields()[0].schema(), other.majorCode);
        fieldSetFlags()[0] = true;
      }
      if (isValidValue(fields()[1], other.minorCode)) {
        this.minorCode = (java.lang.Integer) data().deepCopy(
            fields()[1].schema(), other.minorCode);
        fieldSetFlags()[1] = true;
      }
      if (isValidValue(fields()[2], other.args)) {
        this.args = (java.util.List<java.lang.CharSequence>) data().deepCopy(
            fields()[2].schema(), other.args);
        fieldSetFlags()[2] = true;
      }
    }

    /** Gets the value of the 'majorCode' field */
    public java.lang.Integer getMajorCode() {
      return majorCode;
    }

    /** Sets the value of the 'majorCode' field */
    public org.apache.nutch.storage.ParseStatus.Builder setMajorCode(int value) {
      validate(fields()[0], value);
      this.majorCode = value;
      fieldSetFlags()[0] = true;
      return this;
    }

    /** Checks whether the 'majorCode' field has been set */
    public boolean hasMajorCode() {
      return fieldSetFlags()[0];
    }

    /** Clears the value of the 'majorCode' field */
    public org.apache.nutch.storage.ParseStatus.Builder clearMajorCode() {
      fieldSetFlags()[0] = false;
      return this;
    }

    /** Gets the value of the 'minorCode' field */
    public java.lang.Integer getMinorCode() {
      return minorCode;
    }

    /** Sets the value of the 'minorCode' field */
    public org.apache.nutch.storage.ParseStatus.Builder setMinorCode(int value) {
      validate(fields()[1], value);
      this.minorCode = value;
      fieldSetFlags()[1] = true;
      return this;
    }

    /** Checks whether the 'minorCode' field has been set */
    public boolean hasMinorCode() {
      return fieldSetFlags()[1];
    }

    /** Clears the value of the 'minorCode' field */
    public org.apache.nutch.storage.ParseStatus.Builder clearMinorCode() {
      fieldSetFlags()[1] = false;
      return this;
    }

    /** Gets the value of the 'args' field */
    public java.util.List<java.lang.CharSequence> getArgs() {
      return args;
    }

    /** Sets the value of the 'args' field */
    public org.apache.nutch.storage.ParseStatus.Builder setArgs(
        java.util.List<java.lang.CharSequence> value) {
      validate(fields()[2], value);
      this.args = value;
      fieldSetFlags()[2] = true;
      return this;
    }

    /** Checks whether the 'args' field has been set */
    public boolean hasArgs() {
      return fieldSetFlags()[2];
    }

    /** Clears the value of the 'args' field */
    public org.apache.nutch.storage.ParseStatus.Builder clearArgs() {
      args = null;
      fieldSetFlags()[2] = false;
      return this;
    }

    @Override
    public ParseStatus build() {
      try {
        ParseStatus record = new ParseStatus();
        record.majorCode = fieldSetFlags()[0] ? this.majorCode
            : (java.lang.Integer) defaultValue(fields()[0]);
        record.minorCode = fieldSetFlags()[1] ? this.minorCode
            : (java.lang.Integer) defaultValue(fields()[1]);
        record.args = fieldSetFlags()[2] ? this.args
            : (java.util.List<java.lang.CharSequence>) new org.apache.gora.persistency.impl.DirtyListWrapper(
                (java.util.List) defaultValue(fields()[2]));
        return record;
      } catch (Exception e) {
        throw new org.apache.avro.AvroRuntimeException(e);
      }
    }
  }

  public ParseStatus.Tombstone getTombstone() {
    return TOMBSTONE;
  }

  public ParseStatus newInstance() {
    return newBuilder().build();
  }

  private static final Tombstone TOMBSTONE = new Tombstone();

  public static final class Tombstone extends ParseStatus implements
      org.apache.gora.persistency.Tombstone {

    private Tombstone() {
    }

    /**
     * Gets the value of the 'majorCode' field. Major parsing status' including
     * NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded),
     * FAILED (General failure. There may be a more specific error message in
     * arguments.)
     */
    public java.lang.Integer getMajorCode() {
      throw new java.lang.UnsupportedOperationException(
          "Get is not supported on tombstones");
    }

    /**
     * Sets the value of the 'majorCode' field. Major parsing status' including
     * NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded),
     * FAILED (General failure. There may be a more specific error message in
     * arguments.) * @param value the value to set.
     */
    public void setMajorCode(java.lang.Integer value) {
      throw new java.lang.UnsupportedOperationException(
          "Set is not supported on tombstones");
    }

    /**
     * Checks the dirty status of the 'majorCode' field. A field is dirty if it
     * represents a change that has not yet been written to the database. Major
     * parsing status' including NOTPARSED (Parsing was not performed), SUCCESS
     * (Parsing succeeded), FAILED (General failure. There may be a more
     * specific error message in arguments.) * @param value the value to set.
     */
    public boolean isMajorCodeDirty(java.lang.Integer value) {
      throw new java.lang.UnsupportedOperationException(
          "IsDirty is not supported on tombstones");
    }

    /**
     * Gets the value of the 'minorCode' field. Minor parsing status' including
     * SUCCESS_OK - Successful parse devoid of anomalies or issues,
     * SUCCESS_REDIRECT - Parsed content contains a directive to redirect to
     * another URL. The target URL can be retrieved from the arguments.,
     * FAILED_EXCEPTION - Parsing failed. An Exception occured which may be
     * retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content
     * was truncated, but the parser cannot handle incomplete content.,
     * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content
     * may be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing
     * failed. Other related parts of the content are needed to complete
     * parsing. The list of URLs to missing parts may be provided in arguments.
     * The Fetcher may decide to fetch these parts at once, then put them into
     * Content.metadata, and supply them for re-parsing., FAILED_MISING_CONTENT
     * - Parsing failed. There was no content to be parsed - probably caused by
     * errors at protocol stage.
     */
    public java.lang.Integer getMinorCode() {
      throw new java.lang.UnsupportedOperationException(
          "Get is not supported on tombstones");
    }

    /**
     * Sets the value of the 'minorCode' field. Minor parsing status' including
     * SUCCESS_OK - Successful parse devoid of anomalies or issues,
     * SUCCESS_REDIRECT - Parsed content contains a directive to redirect to
     * another URL. The target URL can be retrieved from the arguments.,
     * FAILED_EXCEPTION - Parsing failed. An Exception occured which may be
     * retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content
     * was truncated, but the parser cannot handle incomplete content.,
     * FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content
     * may be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing
     * failed. Other related parts of the content are needed to complete
     * parsing. The list of URLs to missing parts may be provided in arguments.
     * The Fetcher may decide to fetch these parts at once, then put them into
     * Content.metadata, and supply them for re-parsing., FAILED_MISING_CONTENT
     * - Parsing failed. There was no content to be parsed - probably caused by
     * errors at protocol stage. * @param value the value to set.
     */
    public void setMinorCode(java.lang.Integer value) {
      throw new java.lang.UnsupportedOperationException(
          "Set is not supported on tombstones");
    }

    /**
     * Checks the dirty status of the 'minorCode' field. A field is dirty if it
     * represents a change that has not yet been written to the database. Minor
     * parsing status' including SUCCESS_OK - Successful parse devoid of
     * anomalies or issues, SUCCESS_REDIRECT - Parsed content contains a
     * directive to redirect to another URL. The target URL can be retrieved
     * from the arguments., FAILED_EXCEPTION - Parsing failed. An Exception
     * occured which may be retrieved from the arguments., FAILED_TRUNCATED -
     * Parsing failed. Content was truncated, but the parser cannot handle
     * incomplete content., FAILED_INVALID_FORMAT - Parsing failed. Invalid
     * format e.g. the content may be corrupted or of wrong type.,
     * FAILED_MISSING_PARTS - Parsing failed. Other related parts of the content
     * are needed to complete parsing. The list of URLs to missing parts may be
     * provided in arguments. The Fetcher may decide to fetch these parts at
     * once, then put them into Content.metadata, and supply them for
     * re-parsing., FAILED_MISING_CONTENT - Parsing failed. There was no content
     * to be parsed - probably caused by errors at protocol stage. * @param
     * value the value to set.
     */
    public boolean isMinorCodeDirty(java.lang.Integer value) {
      throw new java.lang.UnsupportedOperationException(
          "IsDirty is not supported on tombstones");
    }

    /**
     * Gets the value of the 'args' field. Optional arguments supplied to
     * compliment and/or justify the parse status code.
     */
    public java.util.List<java.lang.CharSequence> getArgs() {
      throw new java.lang.UnsupportedOperationException(
          "Get is not supported on tombstones");
    }

    /**
     * Sets the value of the 'args' field. Optional arguments supplied to
     * compliment and/or justify the parse status code. * @param value the value
     * to set.
     */
    public void setArgs(java.util.List<java.lang.CharSequence> value) {
      throw new java.lang.UnsupportedOperationException(
          "Set is not supported on tombstones");
    }

    /**
     * Checks the dirty status of the 'args' field. A field is dirty if it
     * represents a change that has not yet been written to the database.
     * Optional arguments supplied to compliment and/or justify the parse status
     * code. * @param value the value to set.
     */
    public boolean isArgsDirty(java.util.List<java.lang.CharSequence> value) {
      throw new java.lang.UnsupportedOperationException(
          "IsDirty is not supported on tombstones");
    }

  }

}
