/*
 * Decompiled with CFR 0.152.
 */
package org.epistem.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private String mIndent;
    private int mIndentLevel = 0;
    private char mLineSep;
    private boolean mStartOfLine = true;

    public IndentingPrintWriter(Writer writer) {
        this(writer, "    ", 0);
    }

    public IndentingPrintWriter(Writer writer, String string, int n) {
        super(writer);
        this.mIndent = string;
        this.mIndentLevel = n;
        String string2 = System.getProperty("line.separator");
        this.mLineSep = string2.charAt(string2.length() - 1);
    }

    public String getIndent() {
        return this.mIndent;
    }

    public int getIndentLevel() {
        return this.mIndentLevel;
    }

    public void setIndent(String string) {
        this.mIndent = string;
    }

    public void setIndentLevel(int n) {
        this.mIndentLevel = n;
    }

    public void indent() {
        ++this.mIndentLevel;
    }

    public void unindent() {
        this.mIndentLevel = this.mIndentLevel > 0 ? this.mIndentLevel - 1 : 0;
    }

    private void writeIndent() {
        for (int i = 0; i < this.mIndentLevel; ++i) {
            this.print(this.mIndent);
        }
    }

    public void write(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.write(cArray[i]);
        }
    }

    public void writeField(String string, int n, boolean bl) {
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 <= 0) {
            this.write(string);
            return;
        }
        if (!bl) {
            this.write(string);
        }
        while (n3-- > 0) {
            this.write(" ");
        }
        if (bl) {
            this.write(string);
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(int n) {
        if (this.mStartOfLine) {
            this.mStartOfLine = false;
            this.writeIndent();
        }
        super.write(n);
        if (n == 10 || n == this.mLineSep) {
            this.mStartOfLine = true;
        }
    }

    public void write(String string, int n, int n2) {
        this.write(string.toCharArray(), n, n2);
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void println() {
        super.println();
        this.mStartOfLine = true;
    }
}

