/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.io;

import com.anotherbigidea.io.OutputStreamWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class OutStream
extends OutputStreamWrapper {
    private int mBitBuf;
    private int mBitPos;

    public OutStream(OutputStream outputStream) {
        super(outputStream);
        this.initBits();
    }

    protected OutStream() {
        super(null);
    }

    public void writeSBits(int n, int n2) throws IOException {
        long l = n2 & Integer.MAX_VALUE;
        if (n2 < 0) {
            l |= 1L << n - 1;
        }
        this.writeUBits(n, l);
    }

    public void flush() throws IOException {
        this.flushBits();
        super.flush();
    }

    public void writeCompressed() {
        this.setOutputStream(new DeflaterOutputStream(this.getOutputStream(), new Deflater(9)));
    }

    public void flushBits() throws IOException {
        if (this.mBitPos == 0) {
            return;
        }
        super.write(this.mBitBuf);
        this.mBitBuf = 0;
        this.mBitPos = 0;
    }

    public void writeUBits(int n, long l) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.mBitPos == 0) {
            this.mBitPos = 8;
        }
        int n2 = n;
        while (n2 > 0) {
            while (this.mBitPos > 0 && n2 > 0) {
                if (OutStream.getBit(n2, l)) {
                    this.mBitBuf = OutStream.setBit(this.mBitPos, this.mBitBuf);
                }
                --n2;
                --this.mBitPos;
            }
            if (this.mBitPos != 0) continue;
            this.writeUI8(this.mBitBuf);
            this.mBitBuf = 0;
            if (n2 <= 0) continue;
            this.mBitPos = 8;
        }
    }

    public static boolean getBit(int n, long l) {
        return (l & 1L << n - 1) != 0L;
    }

    public static int setBit(int n, int n2) {
        return n2 | 1 << n - 1;
    }

    public void write(byte[] byArray) throws IOException {
        this.flushBits();
        if (byArray != null && byArray.length > 0) {
            super.write(byArray);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.flushBits();
        if (byArray != null && n2 > 0) {
            super.write(byArray, n, n2);
        }
    }

    public void writeUI8(int n) throws IOException {
        this.flushBits();
        super.write(n);
    }

    public void writeUI16(int n) throws IOException {
        this.flushBits();
        super.write(n & 0xFF);
        super.write(n >> 8);
    }

    public void writeSI16(short s) throws IOException {
        this.flushBits();
        super.write(s & 0xFF);
        super.write(s >> 8);
    }

    public void writeUI32(long l) throws IOException {
        this.flushBits();
        super.write((int)(l & 0xFFL));
        super.write((int)(l >> 8));
        super.write((int)(l >> 16));
        super.write((int)(l >> 24));
    }

    public int writeString(String string, String string2) throws IOException {
        if (string == null) {
            string = "";
        }
        byte[] byArray = string.getBytes(string2);
        this.writeString(byArray);
        return byArray.length + 1;
    }

    public void writeString(byte[] byArray) throws IOException {
        this.flushBits();
        if (byArray != null) {
            super.write(byArray);
        }
        super.write(0);
    }

    public static int getStringLength(byte[] byArray) {
        if (byArray == null) {
            return 1;
        }
        return byArray.length + 1;
    }

    public static int getStringLength(String string) {
        if (string == null) {
            return 1;
        }
        byte[] byArray = string.getBytes();
        return byArray.length + 1;
    }

    private void initBits() {
        this.mBitBuf = 0;
        this.mBitPos = 0;
    }

    public static int determineSignedBitSize(int n) {
        int n2;
        if (n >= 0) {
            return OutStream.determineUnsignedBitSize(n) + 1;
        }
        long l = 0x40000000L;
        for (n2 = 31; n2 > 0 && ((long)n & l) != 0L; --n2) {
            l >>= 1;
        }
        if (n2 == 0) {
            return 2;
        }
        int n3 = n & (1 << n2) - 1;
        if (n3 == 0) {
            ++n2;
        }
        return n2 + 1;
    }

    public static int determineUnsignedBitSize(long l) {
        long l2 = 0x80000000L;
        for (int i = 32; i > 0; --i) {
            if ((l & l2) != 0L) {
                return i;
            }
            l2 >>= 1;
        }
        return 0;
    }

    public void writeFloat(float f) throws IOException {
        this.writeSI32(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeDouble(d);
        dataOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byte[] byArray2 = new byte[]{byArray[3], byArray[2], byArray[1], byArray[0], byArray[7], byArray[6], byArray[5], byArray[4]};
        this.write(byArray2);
    }

    public void writeSI32(int n) throws IOException {
        this.flushBits();
        super.write(n & 0xFF);
        super.write(n >> 8);
        super.write(n >> 16);
        super.write(n >> 24);
    }

    public static byte[] sintTo2Bytes(int n) {
        return new byte[]{OutStream.uintToByte(n & 0xFF), OutStream.uintToByte(n >> 8)};
    }

    public static byte[] uintTo2Bytes(int n) {
        return new byte[]{OutStream.uintToByte(n & 0xFF), OutStream.uintToByte(n >> 8)};
    }

    public static byte[] uintTo4Bytes(int n) {
        return new byte[]{OutStream.uintToByte(n & 0xFF), OutStream.uintToByte(n >> 8), OutStream.uintToByte(n >> 16), OutStream.uintToByte(n >> 24)};
    }

    public static byte uintToByte(int n) {
        int n2 = n & 1;
        byte by = (byte)(n >>= 1);
        by = (byte)(by << 1);
        by = (byte)(by | (byte)n2);
        return by;
    }

    public void write(int n) throws IOException {
        this.flushBits();
        super.write(n);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

