/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.SWFConstants;
import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.readers.ActionParser;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import com.anotherbigidea.io.InStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class TagParser
implements SWFTags,
SWFConstants,
SWFFileSignature {
    protected String mStringEncoding = "UTF-8";
    protected int mFlashVersion = 6;
    protected int currentTagLength;
    protected SWFTagTypes mTagtypes;

    public TagParser(SWFTagTypes sWFTagTypes) {
        this.mTagtypes = sWFTagTypes;
    }

    public void signature(String string) {
        if (this.mTagtypes instanceof SWFFileSignature) {
            ((SWFFileSignature)((Object)this.mTagtypes)).signature(string);
        }
    }

    public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        this.mTagtypes.header(n, l, n2, n3, n4, n5);
        if (n < 6) {
            this.mStringEncoding = "US-ASCII";
        }
        this.mFlashVersion = n;
    }

    public void tag(int n, boolean bl, byte[] byArray) throws IOException {
        this.currentTagLength = byArray != null ? byArray.length : 0;
        int n2 = this.currentTagLength;
        InStream inStream = n2 > 0 ? new InStream(byArray) : null;
        switch (n) {
            case 0: {
                this.mTagtypes.tagEnd();
                break;
            }
            case 1: {
                this.mTagtypes.tagShowFrame();
                break;
            }
            case 2: 
            case 22: 
            case 32: {
                this.parseDefineShape(n, inStream);
                break;
            }
            case 12: {
                this.parseDoAction(inStream);
                break;
            }
            case 59: {
                this.parseDoInitAction(inStream);
                break;
            }
            case 3: {
                this.mTagtypes.tagFreeCharacter(inStream.readUI16());
                break;
            }
            case 4: {
                this.parsePlaceObject(inStream, n2);
                break;
            }
            case 26: {
                this.parsePlaceObject2(inStream);
                break;
            }
            case 5: {
                this.mTagtypes.tagRemoveObject(inStream.readUI16(), inStream.readUI16());
                break;
            }
            case 28: {
                this.mTagtypes.tagRemoveObject2(inStream.readUI16());
                break;
            }
            case 9: {
                this.mTagtypes.tagSetBackgroundColor(new Color(inStream));
                break;
            }
            case 43: {
                this.parseFrameLabel(inStream, byArray);
                break;
            }
            case 39: {
                this.parseDefineSprite(inStream, n2);
                break;
            }
            case 24: {
                this.mTagtypes.tagProtect(n2 > 0 ? inStream.read(n2) : null);
                break;
            }
            case 58: {
                this.mTagtypes.tagEnableDebug(n2 > 0 ? inStream.read(n2) : null);
                break;
            }
            case 10: {
                this.parseDefineFont(inStream);
                break;
            }
            case 13: {
                this.parseFontInfo(inStream, n2, false);
                break;
            }
            case 62: {
                this.parseFontInfo(inStream, n2, true);
                break;
            }
            case 48: {
                this.parseDefineFont2(inStream);
                break;
            }
            case 37: {
                this.parseDefineTextField(inStream);
                break;
            }
            case 11: 
            case 33: {
                this.parseDefineText(n, inStream);
                break;
            }
            case 7: {
                this.parseDefineButton(inStream);
                break;
            }
            case 34: {
                this.parseDefineButton2(inStream);
                break;
            }
            case 23: {
                this.parseButtonCXForm(inStream);
                break;
            }
            case 56: {
                this.parseExport(inStream);
                break;
            }
            case 57: {
                this.parseImport(inStream);
                break;
            }
            case 38: {
                this.mTagtypes.tagDefineQuickTimeMovie(inStream.readUI16(), inStream.readString(this.mStringEncoding));
                break;
            }
            case 21: {
                this.parseDefineJPEG2(inStream, n2);
                break;
            }
            case 20: {
                this.parseDefineBitsLossless(inStream, n2, false);
                break;
            }
            case 36: {
                this.parseDefineBitsLossless(inStream, n2, true);
                break;
            }
            case 46: {
                this.parseMorphShape(inStream);
                break;
            }
            case 40: {
                this.mTagtypes.tagNameCharacter(byArray);
                break;
            }
            case 42: {
                this.mTagtypes.tagGeneratorText(byArray);
                break;
            }
            case 49: {
                this.mTagtypes.tagGeneratorCommand(byArray);
                break;
            }
            case 51: {
                this.mTagtypes.tagGenerator(byArray);
                break;
            }
            case 52: {
                this.mTagtypes.tagGeneratorFont(byArray);
                break;
            }
            case 41: {
                this.mTagtypes.tagSerialNumber(inStream.readString(this.mStringEncoding));
                break;
            }
            case 65: {
                this.mTagtypes.tagScriptLimits(inStream.readUI16(), inStream.readUI16());
                break;
            }
            case 66: {
                this.mTagtypes.tagTabOrder(inStream.readUI16(), inStream.readUI16());
                break;
            }
            case 14: {
                this.parseDefineSound(inStream);
                break;
            }
            case 15: {
                this.parseStartSound(inStream);
                break;
            }
            case 17: {
                this.parseDefineButtonSound(inStream);
                break;
            }
            case 18: {
                this.parseSoundStreamHead(true, inStream);
                break;
            }
            case 45: {
                this.parseSoundStreamHead(false, inStream);
                break;
            }
            case 19: {
                this.parseSoundStreamBlock(inStream);
                break;
            }
            case 6: {
                this.parseDefineBits(inStream);
                break;
            }
            case 8: {
                this.parseDefineJPEGTables(inStream);
                break;
            }
            case 35: {
                this.parseDefineBitsJPEG3(inStream);
                break;
            }
            case 64: {
                this.parseEnableDebugger2(inStream, n2);
                break;
            }
            case 60: {
                this.parseDefineVideoStream(inStream);
                break;
            }
            case 61: {
                this.parseVideoFrame(inStream, n2);
                break;
            }
            default: {
                this.mTagtypes.tag(n, bl, byArray);
            }
        }
    }

    protected void parseVideoFrame(InStream inStream, int n) throws IOException {
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI16();
        int n4 = inStream.readUI8();
        int n5 = n4 & 0xF;
        int n6 = n4 >> 4;
        byte[] byArray = inStream.read(n - 5);
        this.mTagtypes.tagVideoFrame(n2, n3, n6, n5, byArray);
    }

    protected void parseDefineVideoStream(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI16();
        int n4 = inStream.readUI16();
        int n5 = inStream.readUI8();
        int n6 = inStream.readUI8();
        this.mTagtypes.tagDefineVideoStream(n, n2, n3, n4, n5, n6);
    }

    protected void parseEnableDebugger2(InStream inStream, int n) throws IOException {
        int n2 = inStream.readUI16();
        this.mTagtypes.tagEnableDebug2(n > 2 ? inStream.read(n - 2) : null);
    }

    protected void parseFrameLabel(InStream inStream, byte[] byArray) throws IOException {
        int n;
        if (byArray != null && byArray.length >= 2 && byArray[(n = byArray.length) - 1] == 1 && byArray[n - 2] == 0) {
            this.mTagtypes.tagFrameLabel(inStream.readString(this.mStringEncoding), true);
            return;
        }
        this.mTagtypes.tagFrameLabel(inStream.readString(this.mStringEncoding));
    }

    protected void parseDefineSound(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        int n2 = (int)inStream.readUBits(4);
        int n3 = (int)inStream.readUBits(2);
        boolean bl = inStream.readUBits(1) != 0L;
        boolean bl2 = inStream.readUBits(1) != 0L;
        int n4 = (int)inStream.readUI32();
        byte[] byArray = inStream.read();
        this.mTagtypes.tagDefineSound(n, n2, n3, bl, bl2, n4, byArray);
    }

    protected void parseStartSound(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        SoundInfo soundInfo = new SoundInfo(inStream);
        this.mTagtypes.tagStartSound(n, soundInfo);
    }

    protected void parseDefineButtonSound(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        int n2 = inStream.readUI16();
        SoundInfo soundInfo = n2 == 0 ? null : new SoundInfo(inStream);
        int n3 = inStream.readUI16();
        SoundInfo soundInfo2 = n3 == 0 ? null : new SoundInfo(inStream);
        int n4 = inStream.readUI16();
        SoundInfo soundInfo3 = n4 == 0 ? null : new SoundInfo(inStream);
        int n5 = inStream.readUI16();
        SoundInfo soundInfo4 = n5 == 0 ? null : new SoundInfo(inStream);
        this.mTagtypes.tagDefineButtonSound(n, n2, soundInfo, n3, soundInfo2, n4, soundInfo3, n5, soundInfo4);
    }

    protected void parseSoundStreamHead(boolean bl, InStream inStream) throws IOException {
        int n = (int)inStream.readUBits(4);
        int n2 = (int)inStream.readUBits(2);
        boolean bl2 = inStream.readUBits(1) != 0L;
        boolean bl3 = inStream.readUBits(1) != 0L;
        int n3 = (int)inStream.readUBits(4);
        int n4 = (int)inStream.readUBits(2);
        boolean bl4 = inStream.readUBits(1) != 0L;
        boolean bl5 = inStream.readUBits(1) != 0L;
        int n5 = inStream.readUI16();
        if (bl) {
            this.mTagtypes.tagSoundStreamHead(n2, bl2, bl3, n3, n4, bl4, bl5, n5);
        } else {
            this.mTagtypes.tagSoundStreamHead2(n2, bl2, bl3, n3, n4, bl4, bl5, n5);
        }
    }

    protected void parseSoundStreamBlock(InStream inStream) throws IOException {
        this.mTagtypes.tagSoundStreamBlock(inStream.read());
    }

    protected void parseDefineBits(InStream inStream) throws IOException {
        this.mTagtypes.tagDefineBits(inStream.readUI16(), inStream.read());
    }

    protected void parseDefineJPEGTables(InStream inStream) throws IOException {
        this.mTagtypes.tagJPEGTables(inStream.read());
    }

    protected void parseDefineBitsJPEG3(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        int n2 = (int)inStream.readUI32();
        byte[] byArray = inStream.read(n2);
        byte[] byArray2 = inStream.read();
        this.mTagtypes.tagDefineBitsJPEG3(n, byArray, byArray2);
    }

    protected void parseMorphShape(InStream inStream) throws IOException {
        int n;
        int n2 = inStream.readUI16();
        Rect rect = new Rect(inStream);
        Rect rect2 = new Rect(inStream);
        int n3 = (int)inStream.readUI32();
        SWFShape sWFShape = this.mTagtypes.tagDefineMorphShape(n2, rect, rect2);
        if (sWFShape == null) {
            return;
        }
        int n4 = inStream.readUI8();
        if (n4 == 255) {
            n4 = inStream.readUI16();
        }
        for (n = 0; n < n4; ++n) {
            this.parseMorphFillStyle(inStream, sWFShape);
        }
        n = inStream.readUI8();
        if (n == 255) {
            n = inStream.readUI16();
        }
        for (int i = 0; i < n; ++i) {
            this.parseMorphLineStyle(inStream, sWFShape);
        }
        this.parseShape(inStream, sWFShape, false, true);
        this.parseShape(inStream, sWFShape, false, true);
    }

    protected void parseMorphLineStyle(InStream inStream, SWFShape sWFShape) throws IOException {
        int n = inStream.readUI16();
        int n2 = inStream.readUI16();
        AlphaColor alphaColor = new AlphaColor(inStream);
        AlphaColor alphaColor2 = new AlphaColor(inStream);
        sWFShape.defineLineStyle(n, alphaColor);
        sWFShape.defineLineStyle(n2, alphaColor2);
    }

    protected void parseMorphFillStyle(InStream inStream, SWFShape sWFShape) throws IOException {
        int n = inStream.readUI8();
        if (n == 0) {
            AlphaColor alphaColor = new AlphaColor(inStream);
            AlphaColor alphaColor2 = new AlphaColor(inStream);
            sWFShape.defineFillStyle(alphaColor);
            sWFShape.defineFillStyle(alphaColor2);
        } else if (n == 16 || n == 18) {
            Matrix matrix = new Matrix(inStream);
            Matrix matrix2 = new Matrix(inStream);
            int n2 = inStream.readUI8();
            int[] nArray = new int[n2];
            Color[] colorArray = new AlphaColor[n2];
            int[] nArray2 = new int[n2];
            Color[] colorArray2 = new AlphaColor[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = inStream.readUI8();
                colorArray[i] = new AlphaColor(inStream);
                nArray2[i] = inStream.readUI8();
                colorArray2[i] = new AlphaColor(inStream);
            }
            sWFShape.defineFillStyle(matrix, nArray, colorArray, n == 18);
            sWFShape.defineFillStyle(matrix2, nArray2, colorArray2, n == 18);
        } else if (n == 64 || n == 65) {
            int n3 = inStream.readUI16();
            Matrix matrix = new Matrix(inStream);
            Matrix matrix3 = new Matrix(inStream);
            sWFShape.defineFillStyle(n3, matrix, n == 65);
            sWFShape.defineFillStyle(n3, matrix3, n == 65);
        }
    }

    protected void parseDefineJPEG2(InStream inStream, int n) throws IOException {
        int n2 = inStream.readUI16();
        byte[] byArray = inStream.read(n - 2);
        this.mTagtypes.tagDefineBitsJPEG2(n2, byArray);
    }

    protected void parseDefineBitsLossless(InStream inStream, int n, boolean bl) throws IOException {
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI8();
        int n4 = inStream.readUI16();
        int n5 = inStream.readUI16();
        int n6 = 0;
        switch (n3) {
            case 3: {
                n6 = inStream.readUI8() + 1;
                break;
            }
            case 4: {
                n6 = inStream.readUI16() + 1;
                break;
            }
            case 5: {
                n6 = 0;
                break;
            }
            default: {
                throw new IOException("unknown bitmap format: " + n3);
            }
        }
        byte[] byArray = inStream.read(n - (int)inStream.getBytesRead());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        InStream inStream2 = new InStream(inflaterInputStream);
        Color[] colorArray = bl ? new AlphaColor[n6] : new Color[n6];
        for (int i = 0; i < n6; ++i) {
            colorArray[i] = bl ? new AlphaColor(inStream2) : new Color(inStream2);
        }
        byte[] byArray2 = inStream2.read();
        if (bl) {
            this.mTagtypes.tagDefineBitsLossless2(n2, n3, n4, n5, (AlphaColor[])colorArray, byArray2);
        } else {
            this.mTagtypes.tagDefineBitsLossless(n2, n3, n4, n5, colorArray, byArray2);
        }
    }

    protected void parseExport(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = inStream.readUI16();
            stringArray[i] = inStream.readString(this.mStringEncoding);
        }
        this.mTagtypes.tagExport(stringArray, nArray);
    }

    protected void parseImport(InStream inStream) throws IOException {
        String string = inStream.readString(this.mStringEncoding);
        int n = inStream.readUI16();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = inStream.readUI16();
            stringArray[i] = inStream.readString(this.mStringEncoding);
        }
        this.mTagtypes.tagImport(string, stringArray, nArray);
    }

    protected void parseDefineButton2(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        boolean bl = inStream.readUI8() != 0;
        int n2 = inStream.readUI16();
        Vector vector = ButtonRecord2.read(inStream);
        SWFActions sWFActions = this.mTagtypes.tagDefineButton2(n, bl, vector);
        if (sWFActions == null) {
            return;
        }
        while (n2 != 0) {
            n2 = inStream.readUI16();
            int n3 = inStream.readUI16();
            SWFActionBlock sWFActionBlock = sWFActions.start(n3);
            ActionParser actionParser = new ActionParser(sWFActionBlock, this.mFlashVersion);
            actionParser.parse(inStream);
        }
        sWFActions.done();
    }

    protected void parseButtonCXForm(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        ColorTransform colorTransform = new ColorTransform(inStream);
        this.mTagtypes.tagButtonCXForm(n, colorTransform);
    }

    protected void parseDefineButton(InStream inStream) throws IOException {
        Vector vector;
        int n = inStream.readUI16();
        SWFActions sWFActions = this.mTagtypes.tagDefineButton(n, vector = ButtonRecord.read(inStream));
        if (sWFActions == null) {
            return;
        }
        SWFActionBlock sWFActionBlock = sWFActions.start(0);
        ActionParser actionParser = new ActionParser(sWFActionBlock, this.mFlashVersion);
        actionParser.parse(inStream);
        sWFActions.done();
    }

    protected void parseDefineText(int n, InStream inStream) throws IOException {
        int n2;
        SWFText sWFText;
        int n3 = inStream.readUI16();
        Rect rect = new Rect(inStream);
        Matrix matrix = new Matrix(inStream);
        SWFText sWFText2 = sWFText = n == 11 ? this.mTagtypes.tagDefineText(n3, rect, matrix) : this.mTagtypes.tagDefineText2(n3, rect, matrix);
        if (sWFText == null) {
            return;
        }
        int n4 = inStream.readUI8();
        int n5 = inStream.readUI8();
        while ((n2 = inStream.readUI8()) != 0) {
            int n6;
            if ((n2 & 0x80) == 0) {
                n6 = n2 & 0x7F;
                int[] nArray = new int[n6];
                int[] nArray2 = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    nArray[i] = (int)inStream.readUBits(n4);
                    nArray2[i] = inStream.readSBits(n5);
                }
                sWFText.text(nArray, nArray2);
                continue;
            }
            n6 = n2;
            int n7 = 0;
            if ((n6 & 8) != 0) {
                n7 = inStream.readUI16();
            }
            if ((n6 & 4) != 0) {
                sWFText.color(n == 33 ? new AlphaColor(inStream) : new Color(inStream));
            }
            if ((n6 & 1) != 0) {
                sWFText.setX(inStream.readSI16());
            }
            if ((n6 & 2) != 0) {
                sWFText.setY(inStream.readSI16());
            }
            if ((n6 & 8) == 0) continue;
            int n8 = inStream.readUI16();
            sWFText.font(n7, n8);
        }
        sWFText.done();
    }

    protected void parseDefineTextField(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        Rect rect = new Rect(inStream);
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI16();
        int n4 = inStream.readUI16();
        AlphaColor alphaColor = new AlphaColor(inStream);
        int n5 = (n2 & 2) != 0 ? inStream.readUI16() : 0;
        int n6 = inStream.readUI8();
        int n7 = inStream.readUI16();
        int n8 = inStream.readUI16();
        int n9 = inStream.readUI16();
        int n10 = inStream.readUI16();
        String string = inStream.readString(this.mStringEncoding);
        String string2 = (n2 & 0x80) != 0 ? inStream.readString(this.mStringEncoding) : null;
        this.mTagtypes.tagDefineTextField(n, string, string2, rect, n2, alphaColor, n6, n3, n4, n5, n7, n8, n9, n10);
    }

    protected void parseDefineFont2(InStream inStream) throws IOException {
        SWFVectors sWFVectors;
        int n;
        int n2;
        int n3 = inStream.readUI16();
        int n4 = inStream.readUI8();
        int n5 = inStream.readUI8();
        int n6 = inStream.readUI8();
        String string = new String(inStream.read(n6));
        int n7 = inStream.readUI16();
        Vector<byte[]> vector = new Vector<byte[]>();
        int[] nArray = new int[n7 + 1];
        boolean bl = (n4 & 8) != 0;
        for (n2 = 0; n2 <= n7; ++n2) {
            nArray[n2] = bl ? (int)inStream.readUI32() : inStream.readUI16();
        }
        for (n2 = 1; n2 <= n7; ++n2) {
            int n8 = nArray[n2] - nArray[n2 - 1];
            byte[] byArray = inStream.read(n8);
            vector.addElement(byArray);
        }
        n2 = (n4 & 4) != 0 || n7 > 256 ? 1 : 0;
        int[] nArray2 = new int[n7];
        for (n = 0; n < n7; ++n) {
            nArray2[n] = n2 != 0 ? inStream.readUI16() : inStream.readUI8();
        }
        n = 0;
        short s = 0;
        short s2 = 0;
        int[] nArray3 = new int[]{};
        Rect[] rectArray = new Rect[]{};
        int[] nArray4 = new int[]{};
        int[] nArray5 = new int[]{};
        int[] nArray6 = new int[]{};
        if ((n4 & 0x80) != 0) {
            int n9;
            n = inStream.readSI16();
            s = inStream.readSI16();
            s2 = inStream.readSI16();
            nArray3 = new int[n7];
            for (n9 = 0; n9 < n7; ++n9) {
                nArray3[n9] = inStream.readSI16();
            }
            rectArray = new Rect[n7];
            for (n9 = 0; n9 < n7; ++n9) {
                rectArray[n9] = new Rect(inStream);
            }
            n9 = inStream.readUI16();
            nArray4 = new int[n9];
            nArray5 = new int[n9];
            nArray6 = new int[n9];
            for (int i = 0; i < n9; ++i) {
                nArray4[i] = n2 != 0 ? inStream.readUI16() : inStream.readUI8();
                nArray5[i] = n2 != 0 ? inStream.readUI16() : inStream.readUI8();
                nArray6[i] = inStream.readSI16();
            }
        }
        if ((sWFVectors = this.mTagtypes.tagDefineFont2(n3, n4, string, n7, n, s, s2, nArray2, nArray3, rectArray, nArray4, nArray5, nArray6)) == null) {
            return;
        }
        if (vector.isEmpty()) {
            sWFVectors.done();
        } else {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                byte[] byArray = (byte[])enumeration.nextElement();
                InStream inStream2 = new InStream(byArray);
                this.parseShape(inStream2, sWFVectors, false, false);
            }
        }
    }

    protected void parseFontInfo(InStream inStream, int n, boolean bl) throws IOException {
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI8();
        byte[] byArray = inStream.read(n3);
        String string = new String(byArray);
        int n4 = inStream.readUI8();
        int n5 = bl ? inStream.readUI8() : 0;
        boolean bl2 = (n4 & 1) != 0;
        int[] nArray = new int[bl2 ? n / 2 : (n -= 4 + n3)];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = bl2 ? inStream.readUI16() : inStream.readUI8();
        }
        if (bl) {
            this.mTagtypes.tagDefineFontInfo2(n2, string, n4, nArray, n5);
        } else {
            this.mTagtypes.tagDefineFontInfo(n2, string, n4, nArray);
        }
    }

    protected void parseDefineFont(InStream inStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inStream.readUI16();
        SWFVectors sWFVectors = this.mTagtypes.tagDefineFont(n4, n3 = (n2 = inStream.readUI16()) / 2);
        if (sWFVectors == null) {
            return;
        }
        for (n = 1; n < n3; ++n) {
            inStream.readUI16();
        }
        for (n = 0; n < n3; ++n) {
            this.parseShape(inStream, sWFVectors, false, false);
        }
    }

    protected void parseDefineSprite(InStream inStream, int n) throws IOException {
        long l = inStream.getBytesRead() + (long)n;
        int n2 = inStream.readUI16();
        int n3 = inStream.readUI16();
        SWFTagTypes sWFTagTypes = this.mTagtypes.tagDefineSprite(n2);
        if (sWFTagTypes == null) {
            return;
        }
        TagParser tagParser = new TagParser(sWFTagTypes);
        SWFReader sWFReader = new SWFReader((SWFTags)tagParser, inStream);
        tagParser.mFlashVersion = this.mFlashVersion;
        while (inStream.getBytesRead() < l && sWFReader.readOneTag() != 0) {
        }
    }

    protected void parsePlaceObject2(InStream inStream) throws IOException {
        boolean bl;
        boolean bl2 = inStream.readUBits(1) != 0L;
        boolean bl3 = inStream.readUBits(1) != 0L;
        boolean bl4 = inStream.readUBits(1) != 0L;
        boolean bl5 = inStream.readUBits(1) != 0L;
        boolean bl6 = inStream.readUBits(1) != 0L;
        boolean bl7 = inStream.readUBits(1) != 0L;
        boolean bl8 = inStream.readUBits(1) != 0L;
        boolean bl9 = inStream.readUBits(1) != 0L;
        int n = inStream.readUI16();
        int n2 = bl8 ? inStream.readUI16() : 0;
        Matrix matrix = bl7 ? new Matrix(inStream) : null;
        AlphaTransform alphaTransform = bl6 ? new AlphaTransform(inStream) : null;
        int n3 = bl5 ? inStream.readUI16() : -1;
        String string = bl4 ? inStream.readString(this.mStringEncoding) : null;
        int n4 = bl3 ? inStream.readUI16() : 0;
        int n5 = 0;
        boolean bl10 = bl = this.mFlashVersion >= 6;
        if (bl2) {
            inStream.readUI16();
            n5 = bl ? (int)inStream.readUI32() : inStream.readUI16();
        }
        SWFActions sWFActions = this.mTagtypes.tagPlaceObject2(bl9, n4, n, n2, matrix, alphaTransform, n3, string, n5);
        if (bl2 && sWFActions != null) {
            int n6 = 0;
            while ((n6 = bl ? (int)inStream.readUI32() : inStream.readUI16()) != 0) {
                int n7 = (int)inStream.readUI32();
                SWFActionBlock sWFActionBlock = null;
                if (bl && (n6 & 0x20000) != 0) {
                    int n8 = inStream.readUI8();
                    sWFActionBlock = sWFActions.start(n6, n8);
                } else {
                    sWFActionBlock = sWFActions.start(n6);
                }
                ActionParser actionParser = new ActionParser(sWFActionBlock, this.mFlashVersion);
                actionParser.parse(inStream);
            }
            sWFActions.done();
        }
    }

    protected void parsePlaceObject(InStream inStream, int n) throws IOException {
        this.mTagtypes.tagPlaceObject(inStream.readUI16(), inStream.readUI16(), new Matrix(inStream), inStream.getBytesRead() < (long)n ? new AlphaTransform(inStream) : null);
    }

    protected void parseDoAction(InStream inStream) throws IOException {
        SWFActions sWFActions = this.mTagtypes.tagDoAction();
        if (sWFActions == null) {
            return;
        }
        SWFActionBlock sWFActionBlock = sWFActions.start(0);
        ActionParser actionParser = new ActionParser(sWFActionBlock, this.mFlashVersion);
        actionParser.parse(inStream);
        sWFActions.done();
    }

    protected void parseDoInitAction(InStream inStream) throws IOException {
        int n = inStream.readUI16();
        SWFActions sWFActions = this.mTagtypes.tagDoInitAction(n);
        if (sWFActions == null) {
            return;
        }
        SWFActionBlock sWFActionBlock = sWFActions.start(0);
        ActionParser actionParser = new ActionParser(sWFActionBlock, this.mFlashVersion);
        actionParser.parse(inStream);
        sWFActions.done();
    }

    protected void parseDefineShape(int n, InStream inStream) throws IOException {
        int n2 = inStream.readUI16();
        Rect rect = new Rect(inStream);
        SWFShape sWFShape = null;
        switch (n) {
            case 2: {
                sWFShape = this.mTagtypes.tagDefineShape(n2, rect);
                break;
            }
            case 22: {
                sWFShape = this.mTagtypes.tagDefineShape2(n2, rect);
                break;
            }
            case 32: {
                sWFShape = this.mTagtypes.tagDefineShape3(n2, rect);
                break;
            }
        }
        if (sWFShape == null) {
            return;
        }
        this.parseShape(inStream, sWFShape, true, n == 32);
    }

    protected void parseShape(InStream inStream, SWFVectors sWFVectors, boolean bl, boolean bl2) throws IOException {
        SWFShape sWFShape = sWFVectors instanceof SWFShape ? (SWFShape)sWFVectors : null;
        inStream.synchBits();
        if (bl) {
            this.parseStyles(inStream, sWFShape, bl2);
        }
        inStream.synchBits();
        int[] nArray = new int[]{(int)inStream.readUBits(4)};
        int[] nArray2 = new int[]{(int)inStream.readUBits(4)};
        while (true) {
            int n;
            int n2;
            if ((n2 = (int)inStream.readUBits(1)) == 1) {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8 = n = inStream.readUBits(1) == 0L ? 1 : 0;
                if (n != 0) {
                    n7 = (int)inStream.readUBits(4) + 2;
                    n6 = inStream.readSBits(n7);
                    n5 = inStream.readSBits(n7);
                    n4 = inStream.readSBits(n7);
                    n3 = inStream.readSBits(n7);
                    sWFVectors.curve(n6, n5, n4, n3);
                    continue;
                }
                n7 = (int)inStream.readUBits(4) + 2;
                n6 = inStream.readUBits(1) == 1L ? 1 : 0;
                n5 = 0;
                n4 = 0;
                if (n6 != 0) {
                    n5 = inStream.readSBits(n7);
                    n4 = inStream.readSBits(n7);
                } else {
                    int n9 = n3 = inStream.readUBits(1) == 1L ? 1 : 0;
                    if (n3 != 0) {
                        n4 = inStream.readSBits(n7);
                    } else {
                        n5 = inStream.readSBits(n7);
                    }
                }
                sWFVectors.line(n5, n4);
                continue;
            }
            n = (int)inStream.readUBits(5);
            if (n == 0) break;
            this.parseChangeRecord(inStream, n, sWFVectors, sWFShape, bl2, nArray, nArray2);
        }
        sWFVectors.done();
    }

    protected void parseChangeRecord(InStream inStream, int n, SWFVectors sWFVectors, SWFShape sWFShape, boolean bl, int[] nArray, int[] nArray2) throws IOException {
        int n2;
        boolean bl2;
        boolean bl3 = (n & 0x10) != 0;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 4) != 0;
        boolean bl6 = (n & 2) != 0;
        boolean bl7 = bl2 = (n & 1) != 0;
        if (bl2) {
            n2 = (int)inStream.readUBits(5);
            int n3 = inStream.readSBits(n2);
            int n4 = inStream.readSBits(n2);
            sWFVectors.move(n3, n4);
        }
        if (bl6) {
            n2 = (int)inStream.readUBits(nArray[0]);
            if (sWFShape != null) {
                sWFShape.setFillStyle0(n2);
            }
        }
        if (bl5) {
            n2 = (int)inStream.readUBits(nArray[0]);
            if (sWFShape != null) {
                sWFShape.setFillStyle1(n2);
            }
        }
        if (bl4) {
            n2 = (int)inStream.readUBits(nArray2[0]);
            if (sWFShape != null) {
                sWFShape.setLineStyle(n2);
            }
        }
        if (bl3) {
            this.parseStyles(inStream, sWFShape, bl);
            nArray[0] = (int)inStream.readUBits(4);
            nArray2[0] = (int)inStream.readUBits(4);
        }
    }

    protected void parseStyles(InStream inStream, SWFShape sWFShape, boolean bl) throws IOException {
        int n;
        int n2 = inStream.readUI8();
        if (n2 == 255) {
            n2 = inStream.readUI16();
        }
        for (n = 0; n < n2; ++n) {
            this.parseFillStyle(inStream, sWFShape, bl);
        }
        n = inStream.readUI8();
        if (n == 255) {
            n = inStream.readUI16();
        }
        for (int i = 0; i < n; ++i) {
            this.parseLineStyle(inStream, sWFShape, bl);
        }
    }

    public void parseLineStyle(InStream inStream, SWFShape sWFShape, boolean bl) throws IOException {
        Color color;
        int n = inStream.readUI16();
        Color color2 = color = bl ? new AlphaColor(inStream) : new Color(inStream);
        if (sWFShape != null) {
            sWFShape.defineLineStyle(n, color);
        }
    }

    public void parseFillStyle(InStream inStream, SWFShape sWFShape, boolean bl) throws IOException {
        int n = inStream.readUI8();
        if (n == 0) {
            Color color;
            Color color2 = color = bl ? new AlphaColor(inStream) : new Color(inStream);
            if (sWFShape != null) {
                sWFShape.defineFillStyle(color);
            }
        } else if (n == 16 || n == 18) {
            Matrix matrix = new Matrix(inStream);
            int n2 = inStream.readUI8();
            int[] nArray = new int[n2];
            Color[] colorArray = new Color[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = inStream.readUI8();
                colorArray[i] = bl ? new AlphaColor(inStream) : new Color(inStream);
            }
            if (sWFShape != null) {
                sWFShape.defineFillStyle(matrix, nArray, colorArray, n == 18);
            }
        } else if (n == 64 || n == 65) {
            int n3 = inStream.readUI16();
            Matrix matrix = new Matrix(inStream);
            if (sWFShape != null) {
                sWFShape.defineFillStyle(n3, matrix, n == 65);
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        SWFWriter sWFWriter = new SWFWriter(fileOutputStream);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        TagParser tagParser = new TagParser(tagWriter);
        SWFReader sWFReader = new SWFReader((SWFTags)tagParser, fileInputStream);
        sWFReader.readFile();
        fileOutputStream.flush();
        fileOutputStream.close();
        fileInputStream.close();
    }
}

