/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.swing.laf.flatlaf;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import org.netbeans.api.actions.Editable;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 * @author Karl Tauber
 */
@OptionsPanelController.Keywords(
    keywords={"#KW_FlatLafOptions"},
    location="Appearance",
    tabTitle="#FlatLaf_DisplayName"
)
public class FlatLafOptionsPanel extends javax.swing.JPanel {

    private static final RequestProcessor RP = new RequestProcessor(FlatLafOptionsPanel.class);

    private final FlatLafOptionsPanelController controller;

    /**
     * Creates new form FlatLafOptionsPanel
     */
    public FlatLafOptionsPanel(FlatLafOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        updateEnabled();
    }

    private void updateEnabled() {
        boolean supportsWindowDecorations = FlatLaf.supportsNativeWindowDecorations();
        useWindowDecorationsCheckBox.setEnabled(supportsWindowDecorations);
        unifiedTitleBarCheckBox.setEnabled(supportsWindowDecorations && useWindowDecorationsCheckBox.isSelected());
        menuBarEmbeddedCheckBox.setEnabled(supportsWindowDecorations && useWindowDecorationsCheckBox.isSelected());

        underlineMenuSelectionCheckBox.setEnabled(!SystemInfo.isMacOS);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        useWindowDecorationsCheckBox = new javax.swing.JCheckBox();
        menuBarEmbeddedCheckBox = new javax.swing.JCheckBox();
        unifiedTitleBarCheckBox = new javax.swing.JCheckBox();
        underlineMenuSelectionCheckBox = new javax.swing.JCheckBox();
        alwaysShowMnemonicsCheckBox = new javax.swing.JCheckBox();
        advPanel = new javax.swing.JPanel();
        customPropertiesLabel = new javax.swing.JLabel();
        customPropertiesButton = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));

        org.openide.awt.Mnemonics.setLocalizedText(useWindowDecorationsCheckBox, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.useWindowDecorationsCheckBox.text")); // NOI18N
        useWindowDecorationsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useWindowDecorationsCheckBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(menuBarEmbeddedCheckBox, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.menuBarEmbeddedCheckBox.text")); // NOI18N
        menuBarEmbeddedCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                menuBarEmbeddedCheckBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(unifiedTitleBarCheckBox, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.unifiedTitleBarCheckBox.text")); // NOI18N
        unifiedTitleBarCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                unifiedTitleBarCheckBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(underlineMenuSelectionCheckBox, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.underlineMenuSelectionCheckBox.text")); // NOI18N
        underlineMenuSelectionCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                underlineMenuSelectionCheckBoxActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(alwaysShowMnemonicsCheckBox, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.alwaysShowMnemonicsCheckBox.text")); // NOI18N
        alwaysShowMnemonicsCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                alwaysShowMnemonicsCheckBoxActionPerformed(evt);
            }
        });

        advPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.Advanced.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(customPropertiesLabel, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.customPropertiesLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(customPropertiesButton, org.openide.util.NbBundle.getMessage(FlatLafOptionsPanel.class, "FlatLafOptionsPanel.customPropertiesButton.text")); // NOI18N
        customPropertiesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                customPropertiesButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout advPanelLayout = new javax.swing.GroupLayout(advPanel);
        advPanel.setLayout(advPanelLayout);
        advPanelLayout.setHorizontalGroup(
            advPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(advPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(customPropertiesLabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(advPanelLayout.createSequentialGroup()
                        .addComponent(customPropertiesButton)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        advPanelLayout.setVerticalGroup(
            advPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(advPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(customPropertiesLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(customPropertiesButton)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(useWindowDecorationsCheckBox)
                    .addComponent(unifiedTitleBarCheckBox)
                    .addComponent(menuBarEmbeddedCheckBox)
                    .addComponent(underlineMenuSelectionCheckBox)
                    .addComponent(alwaysShowMnemonicsCheckBox))
                .addContainerGap(213, Short.MAX_VALUE))
            .addComponent(advPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(useWindowDecorationsCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(unifiedTitleBarCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(menuBarEmbeddedCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(underlineMenuSelectionCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(alwaysShowMnemonicsCheckBox)
                .addGap(18, 18, 18)
                .addComponent(advPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void useWindowDecorationsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useWindowDecorationsCheckBoxActionPerformed
        updateEnabled();
        fireChanged();
    }//GEN-LAST:event_useWindowDecorationsCheckBoxActionPerformed

    private void unifiedTitleBarCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_unifiedTitleBarCheckBoxActionPerformed
        fireChanged();
    }//GEN-LAST:event_unifiedTitleBarCheckBoxActionPerformed

    private void menuBarEmbeddedCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_menuBarEmbeddedCheckBoxActionPerformed
        fireChanged();
    }//GEN-LAST:event_menuBarEmbeddedCheckBoxActionPerformed

    private void underlineMenuSelectionCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_underlineMenuSelectionCheckBoxActionPerformed
        fireChanged();
    }//GEN-LAST:event_underlineMenuSelectionCheckBoxActionPerformed

    private void alwaysShowMnemonicsCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_alwaysShowMnemonicsCheckBoxActionPerformed
        fireChanged();
    }//GEN-LAST:event_alwaysShowMnemonicsCheckBoxActionPerformed

    private void customPropertiesButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_customPropertiesButtonActionPerformed
        RP.execute(() -> {
            try {
                FileObject lafFolder = FileUtil.createFolder(FileUtil.getConfigRoot(), "LookAndFeel"); // NOI18N
                FileObject customProp = lafFolder.getFileObject("FlatLaf.properties"); // NOI18N
                if (customProp == null) {
                    customProp = lafFolder.createData("FlatLaf.properties"); // NOI18N
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(customProp.getOutputStream()))) {
                        writer.append(NbBundle.getMessage(FlatLafOptionsPanel.class,
                                "FlatLafOptionsPanel.customProperties.content")); // NOI18N
                    }
                }
                DataObject dob = DataObject.find(customProp);
                Editable editable = dob.getLookup().lookup(Editable.class);
                editable.edit();
            } catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        });
    }//GEN-LAST:event_customPropertiesButtonActionPerformed

    private void fireChanged() {
        boolean isChanged = false;
        if(useWindowDecorationsCheckBox.isSelected() != FlatLafPrefs.isUseWindowDecorations()
                || unifiedTitleBarCheckBox.isSelected() != FlatLafPrefs.isUnifiedTitleBar()
                || menuBarEmbeddedCheckBox.isSelected() != FlatLafPrefs.isMenuBarEmbedded()
                || underlineMenuSelectionCheckBox.isSelected() != FlatLafPrefs.isUnderlineMenuSelection()
                || alwaysShowMnemonicsCheckBox.isSelected() != FlatLafPrefs.isAlwaysShowMnemonics()) {
            isChanged = true;
        }
        controller.changed(isChanged);
    }

    protected void load() {
        useWindowDecorationsCheckBox.setSelected(FlatLafPrefs.isUseWindowDecorations());
        unifiedTitleBarCheckBox.setSelected(FlatLafPrefs.isUnifiedTitleBar());
        menuBarEmbeddedCheckBox.setSelected(FlatLafPrefs.isMenuBarEmbedded());
        underlineMenuSelectionCheckBox.setSelected(FlatLafPrefs.isUnderlineMenuSelection());
        alwaysShowMnemonicsCheckBox.setSelected(FlatLafPrefs.isAlwaysShowMnemonics());

        updateEnabled();
    }

    protected boolean store() {
        FlatLafPrefs.setUseWindowDecorations(useWindowDecorationsCheckBox.isSelected());
        FlatLafPrefs.setUnifiedTitleBar(unifiedTitleBarCheckBox.isSelected());
        FlatLafPrefs.setMenuBarEmbedded(menuBarEmbeddedCheckBox.isSelected());
        FlatLafPrefs.setUnderlineMenuSelection(underlineMenuSelectionCheckBox.isSelected());
        FlatLafPrefs.setAlwaysShowMnemonics(alwaysShowMnemonicsCheckBox.isSelected());
        return false;
    }

    boolean valid() {
        // TODO check whether form is consistent and complete
        return true;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel advPanel;
    private javax.swing.JCheckBox alwaysShowMnemonicsCheckBox;
    private javax.swing.JButton customPropertiesButton;
    private javax.swing.JLabel customPropertiesLabel;
    private javax.swing.JCheckBox menuBarEmbeddedCheckBox;
    private javax.swing.JCheckBox underlineMenuSelectionCheckBox;
    private javax.swing.JCheckBox unifiedTitleBarCheckBox;
    private javax.swing.JCheckBox useWindowDecorationsCheckBox;
    // End of variables declaration//GEN-END:variables
}
