/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class FixImportsBottomPanel extends JPanel {

    private final JComboBox[] comboBoxes;
    private final ImportData importData;
    private ImportData.ItemVariant[] defaultVariants;
    private ImportData.ItemVariant[] dontUseVariants;
    private static final long serialVersionUID = 7771810767310773171L;

    public FixImportsBottomPanel(JComboBox[] comboBoxes, ImportData importData) {
        this.comboBoxes = comboBoxes;
        this.importData = importData;
        initComponents();
        init();
    }

    private void init() {
        int numberOfItems = importData.getItems().size();
        defaultVariants = new ImportData.ItemVariant[numberOfItems];
        dontUseVariants = new ImportData.ItemVariant[numberOfItems];
        for (int i = 0; i < numberOfItems; i++) {
            ImportData.DataItem dataItem = importData.getItems().get(i);
            defaultVariants[i] = dataItem.getDefaultVariant();
            dontUseVariants[i] = dataItem.getDefaultVariant();
            for (ImportData.ItemVariant variant : dataItem.getVariants()) {
                if (!variant.canBeUsed()) {
                    dontUseVariants[i] = variant;
                }
            }
        }
    }

    public boolean removeUnusedImports() {
        return removeUnusedImportsCheckBox.isSelected();
    }

    public boolean isPSR12Order() {
        return putInPSR12OrderCheckBox.isSelected();
    }

    public void setRemoveUnusedImports(boolean removeUnusedImports) {
        removeUnusedImportsCheckBox.setSelected(removeUnusedImports);
    }

    public void setPSR12Order(boolean isPSR12Order) {
        putInPSR12OrderCheckBox.setSelected(isPSR12Order);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        removeUnusedImportsCheckBox = new JCheckBox();
        putInPSR12OrderCheckBox = new JCheckBox();
        clearSuggestionsButton = new JButton();
        restoreDefaultsButton = new JButton();

        Mnemonics.setLocalizedText(removeUnusedImportsCheckBox, NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.removeUnusedImportsCheckBox.text")); // NOI18N

        Mnemonics.setLocalizedText(putInPSR12OrderCheckBox, NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.putInPSR12OrderCheckBox.text")); // NOI18N

        Mnemonics.setLocalizedText(clearSuggestionsButton, NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.clearSuggestionsButton.text")); // NOI18N
        clearSuggestionsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                clearSuggestionsButtonActionPerformed(evt);
            }
        });

        Mnemonics.setLocalizedText(restoreDefaultsButton, NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.restoreDefaultsButton.text")); // NOI18N
        restoreDefaultsButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                restoreDefaultsButtonActionPerformed(evt);
            }
        });

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(removeUnusedImportsCheckBox)
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(putInPSR12OrderCheckBox)
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(clearSuggestionsButton)
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(restoreDefaultsButton)
                .addContainerGap())
        );
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(removeUnusedImportsCheckBox)
                    .addComponent(clearSuggestionsButton)
                    .addComponent(restoreDefaultsButton)
                    .addComponent(putInPSR12OrderCheckBox))
                .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        removeUnusedImportsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.removeUnusedImportsCheckBox.AccessibleContext.accessibleDescription")); // NOI18N
        putInPSR12OrderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixImportsBottomPanel.class, "FixImportsBottomPanel.putInPSR12OrderCheckBox.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void clearSuggestionsButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_clearSuggestionsButtonActionPerformed
        for (int i = 0; i < comboBoxes.length; i++) {
            comboBoxes[i].setSelectedItem(dontUseVariants[i]);
        }
    }//GEN-LAST:event_clearSuggestionsButtonActionPerformed

    private void restoreDefaultsButtonActionPerformed(ActionEvent evt) {//GEN-FIRST:event_restoreDefaultsButtonActionPerformed
        for (int i = 0; i < comboBoxes.length; i++) {
            comboBoxes[i].setSelectedItem(defaultVariants[i]);
        }
    }//GEN-LAST:event_restoreDefaultsButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JButton clearSuggestionsButton;
    private JCheckBox putInPSR12OrderCheckBox;
    private JCheckBox removeUnusedImportsCheckBox;
    private JButton restoreDefaultsButton;
    // End of variables declaration//GEN-END:variables

}
