/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;

/**
 * Panel for displaying and editing the session factory properties
 * 
 * @author  Dongmei Cao
 */
public class PropertiesPanel extends SectionInnerPanel {

    public PropertiesPanel(SectionView view, final PUDataObject dObj, final PropertiesParamHolder propParam) {
        super(view);
        initComponents();
        PropertiesTableModel model = new PropertiesTableModel(propParam);
        PropertiesTablePanel panel = new PropertiesTablePanel(dObj, propParam, model);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        add(panel, gridBagConstraints);
    }

    @Override
    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    @Override
    public void setValue(javax.swing.JComponent source, Object value) {
    }

    @Override
    public void linkButtonPressed(Object obj, String id) {
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filler = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        filler.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(filler, gridBagConstraints);
    }// </editor-fold>
    // Variables declaration - do not modify
    private javax.swing.JPanel filler;
    // End of variables declaration
    
    public static class PropertiesParamHolder{
        private final PersistenceUnit pu;
        private final Provider prov;
        PropertiesParamHolder(PersistenceUnit pu, Provider prov){
            this.pu = pu;
            this.prov = prov;
        }
        public PersistenceUnit getPU(){
            return pu;
        }
        public Provider getProvider(){
            return prov;
        }
    }
}
