/* The following code was generated by JFlex 1.4.3 on 05.02.22, 21:49 */

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.javascript2.lexer;

import java.util.LinkedList;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

@org.netbeans.api.annotations.common.SuppressWarnings({"SF_SWITCH_FALLTHROUGH", "URF_UNREAD_FIELD", "DLS_DEAD_LOCAL_STORE", "DM_DEFAULT_ENCODING"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 05.02.22, 21:49 from the specification file
 * <tt>/home/matthias/src/netbeans/webcommon/javascript2.lexer/tools/JsColoringScanner.flex</tt>
 */
public final class JsColoringLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int REGEXPEND = 22;
  public static final int LCOMMENTEND = 24;
  public static final int INITIAL = 2;
  public static final int SSTRINGEND = 10;
  public static final int STRINGEND = 6;
  public static final int ERROR = 32;
  public static final int JSXEXPEND = 30;
  public static final int JSX = 26;
  public static final int SSTRING = 8;
  public static final int STRING = 4;
  public static final int JSXEXP = 28;
  public static final int TEMPLATEEXPEND = 18;
  public static final int REGEXP = 20;
  public static final int YYINITIAL = 0;
  public static final int TEMPLATEEXP = 16;
  public static final int TEMPLATEEND = 14;
  public static final int TEMPLATE = 12;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 
    16, 16
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\10\1\3\1\2\2\3\1\1\16\10\4\0\1\3\1\7\1\34"+
    "\1\6\1\33\1\107\1\103\1\36\1\71\1\72\1\5\1\105\1\76"+
    "\1\31\1\27\1\4\1\12\1\23\2\22\4\24\2\13\1\102\1\75"+
    "\1\37\1\70\1\100\1\77\1\110\1\20\1\25\1\20\1\26\1\30"+
    "\1\26\5\11\1\15\2\11\1\21\10\11\1\17\2\11\1\40\1\35"+
    "\1\41\1\106\1\14\1\32\1\45\1\42\1\47\1\56\1\44\1\60"+
    "\1\57\1\52\1\54\1\11\1\46\1\61\1\67\1\16\1\53\1\64"+
    "\1\11\1\43\1\50\1\51\1\55\1\65\1\63\1\66\1\62\1\11"+
    "\1\73\1\104\1\74\1\101\41\10\1\3\1\0\4\11\4\0\1\11"+
    "\2\0\1\10\7\0\1\11\4\0\1\11\5\0\27\11\1\0\37\11"+
    "\1\0\u01ca\11\4\0\14\11\16\0\5\11\7\0\1\11\1\0\1\11"+
    "\21\0\160\10\5\11\1\0\2\11\2\0\4\11\1\0\1\11\6\0"+
    "\1\11\1\0\3\11\1\0\1\11\1\0\24\11\1\0\123\11\1\0"+
    "\213\11\1\0\5\10\2\0\246\11\1\0\46\11\2\0\1\11\7\0"+
    "\47\11\7\0\1\11\1\0\55\10\1\0\1\10\1\0\2\10\1\0"+
    "\2\10\1\0\1\10\10\0\33\11\5\0\3\11\15\0\6\10\5\0"+
    "\1\11\4\0\13\10\1\0\1\10\3\0\53\11\37\10\4\0\2\11"+
    "\1\10\143\11\1\0\1\11\10\10\1\0\6\10\2\11\2\10\1\0"+
    "\4\10\2\11\12\10\3\11\2\0\1\11\17\0\1\10\1\11\1\10"+
    "\36\11\33\10\2\0\131\11\13\10\1\11\16\0\12\10\41\11\11\10"+
    "\2\11\4\0\1\11\5\0\26\11\4\10\1\11\11\10\1\11\3\10"+
    "\1\11\5\10\22\0\31\11\3\10\4\0\13\11\65\0\25\11\1\0"+
    "\10\11\26\0\60\10\66\11\3\10\1\11\22\10\1\11\7\10\12\11"+
    "\2\10\2\0\12\10\1\0\20\11\3\10\1\0\10\11\2\0\2\11"+
    "\2\0\26\11\1\0\7\11\1\0\1\11\3\0\4\11\2\0\1\10"+
    "\1\11\7\10\2\0\2\10\2\0\3\10\1\11\10\0\1\10\4\0"+
    "\2\11\1\0\3\11\2\10\2\0\12\10\4\11\7\0\2\11\4\0"+
    "\3\10\1\0\6\11\4\0\2\11\2\0\26\11\1\0\7\11\1\0"+
    "\2\11\1\0\2\11\1\0\2\11\2\0\1\10\1\0\5\10\4\0"+
    "\2\10\2\0\3\10\3\0\1\10\7\0\4\11\1\0\1\11\7\0"+
    "\14\10\3\11\1\10\13\0\3\10\1\0\11\11\1\0\3\11\1\0"+
    "\26\11\1\0\7\11\1\0\2\11\1\0\5\11\2\0\1\10\1\11"+
    "\10\10\1\0\3\10\1\0\3\10\2\0\1\11\17\0\2\11\2\10"+
    "\2\0\12\10\1\0\1\11\7\0\1\11\6\10\1\0\3\10\1\0"+
    "\10\11\2\0\2\11\2\0\26\11\1\0\7\11\1\0\2\11\1\0"+
    "\5\11\2\0\1\10\1\11\7\10\2\0\2\10\2\0\3\10\10\0"+
    "\2\10\4\0\2\11\1\0\3\11\2\10\2\0\12\10\1\0\1\11"+
    "\20\0\1\10\1\11\1\0\6\11\3\0\3\11\1\0\4\11\3\0"+
    "\2\11\1\0\1\11\1\0\2\11\3\0\2\11\3\0\3\11\3\0"+
    "\14\11\4\0\5\10\3\0\3\10\1\0\4\10\2\0\1\11\6\0"+
    "\1\10\16\0\12\10\11\0\1\11\6\0\4\10\1\0\10\11\1\0"+
    "\3\11\1\0\27\11\1\0\20\11\3\0\1\11\7\10\1\0\3\10"+
    "\1\0\4\10\7\0\2\10\1\0\3\11\5\0\2\11\2\10\2\0"+
    "\12\10\20\0\1\11\3\10\1\0\10\11\1\0\3\11\1\0\27\11"+
    "\1\0\12\11\1\0\5\11\2\0\1\10\1\11\7\10\1\0\3\10"+
    "\1\0\4\10\7\0\2\10\7\0\1\11\1\0\2\11\2\10\2\0"+
    "\12\10\1\0\2\11\15\0\4\10\1\0\10\11\1\0\3\11\1\0"+
    "\51\11\2\10\1\11\7\10\1\0\3\10\1\0\4\10\1\11\5\0"+
    "\3\11\1\10\7\0\3\11\2\10\2\0\12\10\12\0\6\11\2\0"+
    "\2\10\1\0\22\11\3\0\30\11\1\0\11\11\1\0\1\11\2\0"+
    "\7\11\3\0\1\10\4\0\6\10\1\0\1\10\1\0\10\10\6\0"+
    "\12\10\2\0\2\10\15\0\60\11\1\10\2\11\7\10\4\0\10\11"+
    "\10\10\1\0\12\10\47\0\2\11\1\0\1\11\2\0\2\11\1\0"+
    "\1\11\2\0\1\11\6\0\4\11\1\0\7\11\1\0\3\11\1\0"+
    "\1\11\1\0\1\11\2\0\2\11\1\0\4\11\1\10\2\11\6\10"+
    "\1\0\2\10\1\11\2\0\5\11\1\0\1\11\1\0\6\10\2\0"+
    "\12\10\2\0\4\11\40\0\1\11\27\0\2\10\6\0\12\10\13\0"+
    "\1\10\1\0\1\10\1\0\1\10\4\0\2\10\10\11\1\0\44\11"+
    "\4\0\24\10\1\0\2\10\5\11\13\10\1\0\44\10\11\0\1\10"+
    "\71\0\53\11\24\10\1\11\12\10\6\0\6\11\4\10\4\11\3\10"+
    "\1\11\3\10\2\11\7\10\3\11\4\10\15\11\14\10\1\11\17\10"+
    "\2\0\46\11\1\0\1\11\5\0\1\11\2\0\53\11\1\0\u014d\11"+
    "\1\0\4\11\2\0\7\11\1\0\1\11\1\0\4\11\2\0\51\11"+
    "\1\0\4\11\2\0\41\11\1\0\4\11\2\0\7\11\1\0\1\11"+
    "\1\0\4\11\2\0\17\11\1\0\71\11\1\0\4\11\2\0\103\11"+
    "\2\0\3\10\40\0\20\11\20\0\126\11\2\0\6\11\3\0\u026c\11"+
    "\2\0\21\11\1\0\32\11\5\0\113\11\3\0\13\11\7\0\15\11"+
    "\1\0\4\11\3\10\13\0\22\11\3\10\13\0\22\11\2\10\14\0"+
    "\15\11\1\0\3\11\1\0\2\10\14\0\64\11\40\10\3\0\1\11"+
    "\3\0\2\11\1\10\2\0\12\10\41\0\4\10\1\0\12\10\6\0"+
    "\130\11\10\0\5\11\2\10\42\11\1\10\1\11\5\0\106\11\12\0"+
    "\37\11\1\0\14\10\4\0\14\10\12\0\12\10\36\11\2\0\5\11"+
    "\13\0\54\11\4\0\32\11\6\0\12\10\46\0\27\11\5\10\4\0"+
    "\65\11\12\10\1\0\35\10\2\0\13\10\6\0\12\10\15\0\1\11"+
    "\10\0\16\10\102\0\5\10\57\11\21\10\7\11\4\0\12\10\21\0"+
    "\11\10\14\0\3\10\36\11\15\10\2\11\12\10\54\11\16\10\14\0"+
    "\44\11\24\10\10\0\12\10\3\0\3\11\12\10\44\11\2\0\11\11"+
    "\107\0\3\10\1\0\25\10\4\11\1\10\4\11\3\10\2\11\3\10"+
    "\6\0\300\11\72\10\1\0\5\10\u0116\11\2\0\6\11\2\0\46\11"+
    "\2\0\6\11\2\0\10\11\1\0\1\11\1\0\1\11\1\0\1\11"+
    "\1\0\37\11\2\0\65\11\1\0\7\11\1\0\1\11\3\0\3\11"+
    "\1\0\7\11\3\0\4\11\2\0\6\11\4\0\15\11\5\0\3\11"+
    "\1\0\7\11\16\0\5\10\32\0\5\10\20\0\2\11\23\0\1\11"+
    "\13\0\5\10\1\0\12\10\1\0\1\11\15\0\1\11\20\0\15\11"+
    "\3\0\40\11\20\0\15\10\4\0\1\10\3\0\14\10\21\0\1\11"+
    "\4\0\1\11\2\0\12\11\1\0\1\11\3\0\5\11\6\0\1\11"+
    "\1\0\1\11\1\0\1\11\1\0\4\11\1\0\13\11\2\0\4\11"+
    "\5\0\5\11\4\0\1\11\21\0\51\11\u0a77\0\57\11\1\0\57\11"+
    "\1\0\205\11\6\0\4\11\3\10\2\11\14\0\46\11\1\0\1\11"+
    "\5\0\1\11\2\0\70\11\7\0\1\11\17\0\1\10\27\11\11\0"+
    "\7\11\1\0\7\11\1\0\7\11\1\0\7\11\1\0\7\11\1\0"+
    "\7\11\1\0\7\11\1\0\7\11\1\0\40\10\57\0\1\11\u01d5\0"+
    "\3\11\31\0\11\11\6\10\1\0\5\11\2\0\5\11\4\0\126\11"+
    "\2\0\2\10\2\0\3\11\1\0\132\11\1\0\4\11\5\0\52\11"+
    "\2\0\136\11\21\0\33\11\65\0\20\11\u0200\0\u19b6\11\112\0\u51eb\11"+
    "\25\0\u048d\11\103\0\56\11\2\0\u010d\11\3\0\20\11\12\10\2\11"+
    "\24\0\57\11\1\10\4\0\12\10\1\0\37\11\2\10\120\11\2\10"+
    "\45\0\11\11\2\0\147\11\2\0\44\11\1\0\10\11\77\0\13\11"+
    "\1\10\3\11\1\10\4\11\1\10\27\11\5\10\20\0\1\11\7\0"+
    "\64\11\14\0\2\10\62\11\22\10\12\0\12\10\6\0\22\10\6\11"+
    "\3\0\1\11\1\0\1\11\2\0\12\10\34\11\10\10\2\0\27\11"+
    "\15\10\14\0\35\11\3\0\4\10\57\11\16\10\16\0\1\11\12\10"+
    "\6\0\5\11\1\10\12\11\12\10\5\11\1\0\51\11\16\10\11\0"+
    "\3\11\1\10\10\11\2\10\2\0\12\10\6\0\27\11\3\0\1\11"+
    "\3\10\62\11\1\10\1\11\3\10\2\11\2\10\5\11\2\10\1\11"+
    "\1\10\1\11\30\0\3\11\2\0\13\11\5\10\2\0\3\11\2\10"+
    "\12\0\6\11\2\0\6\11\2\0\6\11\11\0\7\11\1\0\7\11"+
    "\1\0\53\11\1\0\12\11\12\0\163\11\10\10\1\0\2\10\2\0"+
    "\12\10\6\0\u2ba4\11\14\0\27\11\4\0\61\11\u2104\0\u016e\11\2\0"+
    "\152\11\46\0\7\11\14\0\5\11\5\0\1\11\1\10\12\11\1\0"+
    "\15\11\1\0\5\11\1\0\1\11\1\0\2\11\1\0\2\11\1\0"+
    "\154\11\41\0\u016b\11\22\0\100\11\2\0\66\11\50\0\15\11\3\0"+
    "\20\10\20\0\20\10\3\0\2\11\30\0\3\11\31\0\1\11\6\0"+
    "\5\11\1\0\207\11\2\0\1\10\4\0\1\11\13\0\12\10\7\0"+
    "\32\11\4\0\1\11\1\0\32\11\13\0\131\11\3\0\6\11\2\0"+
    "\6\11\2\0\6\11\2\0\3\11\3\0\2\11\3\0\2\11\22\0"+
    "\3\10\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\14\0\1\1\4\0\2\2\1\3\2\4\1\5\1\6"+
    "\1\7\1\10\1\11\1\12\2\13\1\12\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\17\12\1\24"+
    "\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\1\41\1\42\1\43\1\44"+
    "\1\45\2\46\1\47\1\3\1\50\1\45\2\51\1\3"+
    "\1\52\1\45\1\53\1\45\1\3\1\54\1\3\1\55"+
    "\4\56\1\57\2\1\3\45\1\60\1\61\1\62\1\63"+
    "\1\3\1\46\1\64\1\3\1\65\1\66\1\67\1\10"+
    "\1\70\3\13\2\0\2\13\1\0\1\13\2\0\2\12"+
    "\1\0\1\71\1\72\1\73\1\74\17\12\1\75\1\76"+
    "\2\12\1\77\15\12\1\100\1\101\1\102\1\103\1\104"+
    "\1\105\1\106\1\107\1\110\1\111\1\112\1\113\1\114"+
    "\1\115\1\0\3\45\1\0\1\45\1\116\1\117\1\0"+
    "\1\120\3\0\1\121\4\0\1\122\1\123\5\13\1\0"+
    "\1\13\1\124\1\12\1\125\1\126\17\12\1\127\12\12"+
    "\1\130\2\12\1\131\7\12\1\132\1\12\1\133\1\134"+
    "\1\135\1\136\1\137\1\140\3\0\1\141\2\0\1\13"+
    "\1\0\1\142\2\12\1\143\1\144\3\12\1\145\7\12"+
    "\1\146\1\12\1\147\15\12\1\150\4\12\1\151\1\152"+
    "\1\0\1\13\1\153\3\12\1\154\1\155\1\156\1\12"+
    "\1\157\1\12\1\160\1\12\1\161\10\12\1\162\2\12"+
    "\1\163\1\164\4\12\1\165\1\13\1\166\1\12\1\167"+
    "\1\12\1\170\1\171\1\172\2\12\1\173\3\12\1\174"+
    "\5\12\1\175\1\13\1\176\5\12\1\177\1\200\2\12"+
    "\1\201\1\202\1\13\1\203\3\12\1\204\1\205\1\12"+
    "\1\13\1\12\1\206\1\12\1\207\1\13\1\210\1\211"+
    "\14\13";

  private static int [] zzUnpackAction() {
    int [] result = new int[395];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\111\0\222\0\333\0\u0124\0\u016d\0\u01b6\0\u01ff"+
    "\0\u0248\0\u0291\0\u02da\0\u0323\0\u036c\0\u03b5\0\u03fe\0\u0447"+
    "\0\u0490\0\u04d9\0\u0522\0\u04d9\0\u056b\0\u04d9\0\u05b4\0\u05fd"+
    "\0\u0646\0\u068f\0\u06d8\0\u0721\0\u076a\0\u07b3\0\u07fc\0\u0845"+
    "\0\u088e\0\u04d9\0\u04d9\0\u04d9\0\u08d7\0\u04d9\0\u04d9\0\u0920"+
    "\0\u0969\0\u09b2\0\u09fb\0\u0a44\0\u0a8d\0\u0ad6\0\u0b1f\0\u0b68"+
    "\0\u0bb1\0\u0bfa\0\u0c43\0\u0c8c\0\u0cd5\0\u0d1e\0\u0d67\0\u04d9"+
    "\0\u04d9\0\u04d9\0\u04d9\0\u04d9\0\u04d9\0\u0db0\0\u0df9\0\u04d9"+
    "\0\u04d9\0\u0e42\0\u0e8b\0\u0ed4\0\u0f1d\0\u0f66\0\u04d9\0\u0faf"+
    "\0\u0ff8\0\u04d9\0\u04d9\0\u1041\0\u04d9\0\u108a\0\u10d3\0\u04d9"+
    "\0\u111c\0\u04d9\0\u1165\0\u04d9\0\u11ae\0\u11f7\0\u04d9\0\u1240"+
    "\0\u04d9\0\u1289\0\u04d9\0\u12d2\0\u131b\0\u1364\0\u13ad\0\u04d9"+
    "\0\u04d9\0\u13f6\0\u11f7\0\u143f\0\u04d9\0\u04d9\0\u04d9\0\u1488"+
    "\0\u1488\0\u14d1\0\u151a\0\u04d9\0\u1563\0\u04d9\0\u15ac\0\u15f5"+
    "\0\u163e\0\u1687\0\u04d9\0\u16d0\0\u1719\0\u1762\0\u17ab\0\u17f4"+
    "\0\u183d\0\u1886\0\u18cf\0\u1918\0\u1961\0\u19aa\0\u04d9\0\u04d9"+
    "\0\u19f3\0\u04d9\0\u1a3c\0\u1a85\0\u1ace\0\u1b17\0\u1b60\0\u1ba9"+
    "\0\u1bf2\0\u1c3b\0\u1c84\0\u1ccd\0\u1d16\0\u1d5f\0\u1da8\0\u1df1"+
    "\0\u1e3a\0\u1e83\0\u0721\0\u1ecc\0\u1f15\0\u0721\0\u1f5e\0\u1fa7"+
    "\0\u1ff0\0\u2039\0\u2082\0\u20cb\0\u2114\0\u215d\0\u21a6\0\u21ef"+
    "\0\u2238\0\u2281\0\u22ca\0\u2313\0\u04d9\0\u04d9\0\u235c\0\u04d9"+
    "\0\u23a5\0\u04d9\0\u23ee\0\u04d9\0\u2437\0\u04d9\0\u04d9\0\u04d9"+
    "\0\u04d9\0\u2480\0\u24c9\0\u2512\0\u255b\0\u25a4\0\u25ed\0\u04d9"+
    "\0\u04d9\0\u1289\0\u04d9\0\u12d2\0\u131b\0\u2636\0\u04d9\0\u267f"+
    "\0\u1488\0\u26c8\0\u2711\0\u04d9\0\u04d9\0\u275a\0\u27a3\0\u27ec"+
    "\0\u2835\0\u287e\0\u28c7\0\u2910\0\u0721\0\u2959\0\u04d9\0\u04d9"+
    "\0\u29a2\0\u29eb\0\u2a34\0\u2a7d\0\u2ac6\0\u2b0f\0\u2b58\0\u2ba1"+
    "\0\u2bea\0\u2c33\0\u2c7c\0\u2cc5\0\u2d0e\0\u2d57\0\u2da0\0\u0721"+
    "\0\u2de9\0\u2e32\0\u2e7b\0\u2ec4\0\u2f0d\0\u2f56\0\u2f9f\0\u2fe8"+
    "\0\u3031\0\u307a\0\u0721\0\u30c3\0\u310c\0\u0721\0\u3155\0\u319e"+
    "\0\u31e7\0\u3230\0\u3279\0\u32c2\0\u330b\0\u0721\0\u3354\0\u04d9"+
    "\0\u04d9\0\u04d9\0\u339d\0\u04d9\0\u04d9\0\u33e6\0\u342f\0\u3478"+
    "\0\u04d9\0\u34c1\0\u27a3\0\u350a\0\u2835\0\u0721\0\u3553\0\u359c"+
    "\0\u0721\0\u0721\0\u35e5\0\u362e\0\u3677\0\u0721\0\u36c0\0\u3709"+
    "\0\u3752\0\u379b\0\u37e4\0\u382d\0\u3876\0\u0721\0\u38bf\0\u0721"+
    "\0\u3908\0\u3951\0\u399a\0\u39e3\0\u3a2c\0\u3a75\0\u3abe\0\u3b07"+
    "\0\u3b50\0\u3b99\0\u3be2\0\u3c2b\0\u3c74\0\u0721\0\u3cbd\0\u3d06"+
    "\0\u3d4f\0\u3d98\0\u0721\0\u04d9\0\u3de1\0\u3e2a\0\u0721\0\u3e73"+
    "\0\u3ebc\0\u3f05\0\u0721\0\u0721\0\u0721\0\u3f4e\0\u0721\0\u3f97"+
    "\0\u0721\0\u3fe0\0\u0721\0\u4029\0\u4072\0\u40bb\0\u4104\0\u414d"+
    "\0\u4196\0\u41df\0\u4228\0\u0721\0\u4271\0\u42ba\0\u0721\0\u0721"+
    "\0\u4303\0\u434c\0\u4395\0\u43de\0\u04d9\0\u4427\0\u0721\0\u4470"+
    "\0\u0721\0\u44b9\0\u0721\0\u0721\0\u0721\0\u4502\0\u454b\0\u0721"+
    "\0\u4594\0\u45dd\0\u4626\0\u0721\0\u466f\0\u46b8\0\u4701\0\u474a"+
    "\0\u4793\0\u0721\0\u47dc\0\u0721\0\u4825\0\u486e\0\u48b7\0\u4900"+
    "\0\u4949\0\u0721\0\u0721\0\u4992\0\u49db\0\u0721\0\u0721\0\u4a24"+
    "\0\u0721\0\u4a6d\0\u4ab6\0\u4aff\0\u0721\0\u0721\0\u4b48\0\u4b91"+
    "\0\u4bda\0\u0721\0\u4c23\0\u0721\0\u4c6c\0\u0721\0\u0721\0\u4cb5"+
    "\0\u4cfe\0\u4d47\0\u4d90\0\u4dd9\0\u4e22\0\u4e6b\0\u4eb4\0\u4efd"+
    "\0\u4f46\0\u4f8f\0\u4fd8";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[395];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\6\22\1\23\102\22\1\24\1\25\1\26\1\27\1\30"+
    "\1\31\1\32\1\33\1\24\1\34\1\35\1\36\2\34"+
    "\1\37\3\34\3\36\2\34\1\40\1\34\1\41\1\42"+
    "\1\34\1\43\1\24\1\44\1\45\1\46\1\47\1\50"+
    "\1\51\1\52\1\53\1\34\1\54\1\55\1\56\2\34"+
    "\1\57\1\34\1\60\1\34\1\61\1\62\1\63\1\64"+
    "\1\65\1\66\2\34\1\67\1\70\1\71\1\72\1\73"+
    "\1\74\1\75\1\76\1\77\1\100\1\101\1\102\1\103"+
    "\1\104\1\105\1\106\1\107\1\110\1\111\1\112\31\110"+
    "\1\113\1\114\53\110\34\24\1\115\54\24\1\116\1\117"+
    "\1\120\32\116\1\121\1\122\52\116\36\24\1\115\52\24"+
    "\32\123\1\124\1\125\1\123\1\126\53\123\32\24\1\127"+
    "\111\24\1\130\151\24\1\131\14\24\1\132\1\133\1\24"+
    "\1\132\2\133\27\132\1\134\2\132\1\135\50\132\2\133"+
    "\1\24\1\133\1\136\104\133\1\24\1\137\1\140\106\24"+
    "\4\141\1\142\30\141\1\143\1\141\1\144\33\141\1\145"+
    "\15\141\73\24\1\146\111\24\1\147\14\24\1\150\1\151"+
    "\1\112\106\150\120\0\1\152\103\0\1\26\111\0\1\27"+
    "\111\0\1\152\1\153\62\0\1\154\25\0\1\155\62\0"+
    "\1\156\31\0\1\157\2\0\6\157\3\0\2\157\1\0"+
    "\1\157\2\0\1\157\6\0\26\157\111\0\1\160\30\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\26\34\33\0"+
    "\1\161\1\162\1\0\2\163\1\164\1\0\1\165\1\166"+
    "\1\167\1\166\1\170\1\163\1\171\1\172\11\0\1\170"+
    "\1\0\1\172\6\0\1\165\2\0\1\163\1\0\2\163"+
    "\4\0\1\164\34\0\2\36\1\173\2\163\3\0\3\36"+
    "\1\0\1\163\1\171\1\172\13\0\1\172\11\0\1\163"+
    "\1\0\2\163\37\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\2\34\1\174\10\34\1\175\12\34\33\0\2\171"+
    "\6\0\3\171\2\0\1\176\112\0\1\177\36\0\1\200"+
    "\57\0\1\201\30\0\1\202\30\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\1\34\1\203\24\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\2\34\1\204\23\34"+
    "\31\0\6\34\1\205\10\34\1\0\1\34\2\0\1\34"+
    "\6\0\17\34\1\206\4\34\1\207\1\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\21\34\1\210\4\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\3\34"+
    "\1\211\5\34\1\212\5\34\1\213\6\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\7\34\1\214\3\34"+
    "\1\215\5\34\1\216\4\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\1\34\1\217\6\34\1\220\7\34"+
    "\1\221\5\34\31\0\6\34\1\222\10\34\1\0\1\34"+
    "\2\0\1\34\6\0\16\34\1\223\6\34\1\224\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\2\34\1\225"+
    "\6\34\1\226\14\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\3\34\1\227\5\34\1\230\1\231\1\232"+
    "\12\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\233\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\12\34\1\234\13\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\10\34\1\235\1\34\1\236"+
    "\13\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\1\34\1\237\1\34\1\240\7\34\1\241\12\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\3\34\1\242"+
    "\5\34\1\243\14\34\111\0\1\244\7\0\1\245\37\0"+
    "\1\246\47\0\1\247\101\0\1\250\7\0\1\251\100\0"+
    "\1\252\12\0\1\253\75\0\1\254\13\0\1\255\74\0"+
    "\1\256\14\0\1\257\73\0\1\260\110\0\1\261\20\0"+
    "\1\110\2\0\31\110\1\0\1\262\53\110\2\0\1\112"+
    "\106\0\1\141\1\263\1\110\7\141\1\264\7\141\2\264"+
    "\1\265\64\141\1\116\2\0\32\116\1\266\1\0\52\116"+
    "\2\0\1\120\106\0\1\141\1\267\1\116\7\141\1\264"+
    "\7\141\2\264\1\265\64\141\32\123\2\0\1\123\1\0"+
    "\53\123\73\0\1\270\15\0\2\141\1\0\106\141\73\0"+
    "\1\271\15\0\1\272\2\0\1\272\1\273\30\272\1\274"+
    "\2\272\1\275\51\272\2\0\106\272\1\275\2\0\32\275"+
    "\1\276\3\275\1\272\47\275\10\0\17\136\1\0\1\136"+
    "\2\0\1\136\6\0\26\136\23\0\1\140\206\0\1\277"+
    "\14\0\1\300\104\0\1\301\1\151\1\112\106\301\1\152"+
    "\2\0\106\152\5\302\1\303\103\302\70\0\1\304\30\0"+
    "\17\157\1\0\1\157\2\0\1\157\6\0\26\157\111\0"+
    "\1\305\32\0\1\161\1\162\1\0\1\163\4\0\1\166"+
    "\1\167\1\166\1\0\1\163\1\171\1\172\13\0\1\172"+
    "\11\0\1\163\1\0\2\163\41\0\2\162\6\0\3\162"+
    "\1\0\1\163\1\171\1\172\13\0\1\172\11\0\1\163"+
    "\1\0\1\163\42\0\2\306\4\0\1\306\1\0\5\306"+
    "\1\0\1\306\11\0\1\306\1\0\2\306\1\0\1\306"+
    "\6\0\1\306\1\0\1\306\42\0\1\307\7\0\3\307"+
    "\76\0\1\310\1\162\1\0\1\163\4\0\3\310\1\0"+
    "\1\163\1\171\1\172\13\0\1\172\11\0\1\163\1\0"+
    "\2\163\41\0\1\166\1\162\1\0\1\163\4\0\3\166"+
    "\1\0\1\163\1\171\1\172\13\0\1\172\11\0\1\163"+
    "\1\0\2\163\41\0\1\311\10\0\1\311\77\0\2\171"+
    "\6\0\3\171\1\0\1\163\1\0\1\172\13\0\1\172"+
    "\11\0\1\163\1\0\1\163\42\0\2\312\6\0\3\312"+
    "\4\0\1\313\53\0\1\313\15\0\2\314\1\173\5\0"+
    "\3\314\74\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\21\34\1\315\4\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\17\34\1\316\6\34\50\0\1\317\151\0"+
    "\1\320\30\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\321\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\7\34\1\322\16\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\13\34\1\323\12\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\6\34\1\324"+
    "\17\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\7\34\1\325\12\34\1\326\3\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\3\34\1\327\22\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\6\34\1\330"+
    "\1\331\16\34\31\0\6\34\1\332\10\34\1\0\1\34"+
    "\2\0\1\34\6\0\26\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\3\34\1\333\22\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\3\34\1\334\22\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\22\34"+
    "\1\335\3\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\12\34\1\336\13\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\13\34\1\337\4\34\1\340\5\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\1\34"+
    "\1\341\10\34\1\342\13\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\22\34\1\343\3\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\6\34\1\344\1\345"+
    "\16\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\22\34\1\346\3\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\1\347\15\34\1\350\1\351\6\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\17\34\1\352"+
    "\6\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\1\34\1\353\24\34\31\0\6\34\1\354\10\34\1\0"+
    "\1\34\2\0\1\34\6\0\26\34\31\0\6\34\1\355"+
    "\10\34\1\0\1\34\2\0\1\34\6\0\26\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\7\34\1\356"+
    "\16\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\357\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\12\34\1\360\13\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\7\34\1\361\16\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\11\34\1\362"+
    "\1\363\13\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\5\34\1\364\20\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\1\365\25\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\1\34\1\366\24\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\12\34\1\367"+
    "\13\34\111\0\1\370\110\0\1\371\110\0\1\372\7\0"+
    "\1\373\100\0\1\374\110\0\1\375\21\0\1\263\1\110"+
    "\106\0\1\110\1\0\32\110\1\0\1\262\53\110\12\0"+
    "\1\265\7\0\3\265\76\0\1\141\7\0\3\141\65\0"+
    "\1\267\1\116\106\0\1\116\1\0\33\116\1\266\1\0"+
    "\52\116\1\275\2\0\106\275\4\376\1\0\32\376\1\0"+
    "\33\376\1\0\4\376\1\0\10\376\5\302\1\377\103\302"+
    "\4\u0100\1\u0101\1\303\103\u0100\12\0\2\306\1\u0102\1\163"+
    "\2\0\1\306\1\0\5\306\1\0\1\306\11\0\1\306"+
    "\1\0\2\306\1\0\1\306\6\0\1\306\1\0\1\306"+
    "\1\163\41\0\1\307\1\0\1\u0103\5\0\3\307\76\0"+
    "\1\u0104\1\162\1\0\1\163\4\0\3\u0104\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\41\0\1\311\1\0\1\u0105\6\0\1\311\77\0\2\312"+
    "\6\0\3\312\1\0\1\163\27\0\1\163\1\0\1\163"+
    "\42\0\2\312\6\0\3\312\76\0\2\314\1\173\2\163"+
    "\3\0\3\314\34\0\1\163\37\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\17\34\1\u0106\6\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\3\34\1\u0107\22\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\13\34"+
    "\1\u0108\12\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\25\34\1\u0109\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\2\34\1\u010a\23\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\2\34\1\u010b\23\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\11\34\1\u010c"+
    "\14\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\12\34\1\u010d\13\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\2\34\1\u010e\23\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\5\34\1\u010f\20\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\6\34\1\u0110"+
    "\1\u0111\16\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\6\34\1\u0112\17\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\7\34\1\u0113\16\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\2\34\1\u0114\23\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\7\34"+
    "\1\u0115\16\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\2\34\1\u0116\23\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\11\34\1\u0117\14\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\6\34\1\u0118\17\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\2\34"+
    "\1\u0119\23\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\7\34\1\u011a\16\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\2\34\1\u011b\23\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\11\34\1\u011c\5\34"+
    "\1\u011d\6\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\13\34\1\u011e\12\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\3\34\1\u011f\22\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\2\34\1\u0120\23\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\6\34"+
    "\1\u0121\17\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\3\34\1\u0122\22\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\5\34\1\u0123\20\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\17\34\1\u0124\6\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\17\34"+
    "\1\u0125\6\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\10\34\1\u0126\15\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\7\34\1\u0127\16\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\23\34\1\u0128\2\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\4\34"+
    "\1\u0129\21\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\17\34\1\u012a\6\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\14\34\1\u012b\11\34\111\0\1\u012c"+
    "\20\0\4\376\1\0\32\376\1\0\33\376\1\0\4\376"+
    "\1\277\10\376\4\302\1\u0101\1\377\103\302\5\u0100\1\u012d"+
    "\103\u0100\12\0\2\306\1\u0102\3\0\1\306\1\0\5\306"+
    "\1\0\1\306\11\0\1\306\1\0\2\306\1\0\1\306"+
    "\6\0\1\306\1\0\1\306\42\0\1\u012e\1\162\1\0"+
    "\1\163\4\0\3\u012e\1\0\1\163\1\171\1\172\13\0"+
    "\1\172\11\0\1\163\1\0\2\163\37\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\4\34\1\u012f\21\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\1\34\1\u0130"+
    "\24\34\31\0\6\34\1\u0131\10\34\1\0\1\34\2\0"+
    "\1\34\6\0\26\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\1\34\1\u0132\24\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\7\34\1\u0133\16\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\10\34\1\u0134"+
    "\15\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\7\34\1\u0135\16\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\12\34\1\u0136\13\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\6\34\1\u0137\17\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\12\34\1\u0138"+
    "\13\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\1\34\1\u0139\24\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\5\34\1\u013a\20\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\21\34\1\u013b\4\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\11\34\1\u013c"+
    "\14\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\3\34\1\u013d\22\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\1\34\1\u013e\24\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\1\34\1\u013f\24\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\2\34\1\u0140"+
    "\23\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\15\34\1\u0141\10\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\13\34\1\u0142\12\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\7\34\1\u0143\16\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\2\34\1\u0144"+
    "\23\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\17\34\1\u0145\6\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\7\34\1\u0146\16\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\14\34\1\u0147\11\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\2\34\1\u0148"+
    "\23\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\u0149\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\3\34\1\u014a\22\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\3\34\1\u014b\22\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\12\34\1\u014c"+
    "\13\34\21\0\4\u0100\1\u014d\1\u012d\103\u0100\12\0\1\u014e"+
    "\1\162\1\0\1\163\4\0\3\u014e\1\0\1\163\1\171"+
    "\1\172\13\0\1\172\11\0\1\163\1\0\2\163\37\0"+
    "\6\34\1\u014f\10\34\1\0\1\34\2\0\1\34\6\0"+
    "\26\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\14\34\1\u0150\11\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\7\34\1\u0151\16\34\31\0\6\34\1\u0152"+
    "\10\34\1\0\1\34\2\0\1\34\6\0\26\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\5\34\1\u0153"+
    "\20\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\10\34\1\u0154\15\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\16\34\1\u0155\7\34\31\0\6\34\1\u0156"+
    "\10\34\1\0\1\34\2\0\1\34\6\0\26\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\16\34\1\u0157"+
    "\7\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\7\34\1\u0158\16\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\25\34\1\u0159\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\15\34\1\u015a\10\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\17\34\1\u015b\6\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\2\34"+
    "\1\u015c\23\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\17\34\1\u015d\6\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\12\34\1\u015e\13\34\31\0\17\34"+
    "\1\0\1\34\2\0\1\34\6\0\5\34\1\u015f\20\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\7\34"+
    "\1\u0160\16\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\15\34\1\u0161\10\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\5\34\1\u0162\20\34\33\0\1\u0163"+
    "\1\162\1\0\1\163\4\0\3\u0163\1\0\1\163\1\171"+
    "\1\172\13\0\1\172\11\0\1\163\1\0\2\163\37\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\6\34\1\u0164"+
    "\17\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\13\34\1\u0165\12\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\5\34\1\u0166\20\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\3\34\1\u0167\22\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\2\34\1\u0168"+
    "\23\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\u0169\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\7\34\1\u016a\16\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\20\34\1\u016b\5\34\31\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\11\34\1\u016c"+
    "\14\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\7\34\1\u016d\16\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\2\34\1\u016e\23\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\2\34\1\u016f\23\34\33\0"+
    "\1\u0170\1\162\1\0\1\163\4\0\3\u0170\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\37\0\17\34\1\0\1\34\2\0\1\34\6\0\2\34"+
    "\1\u0171\23\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\2\34\1\u0172\23\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\5\34\1\u0173\20\34\31\0\6\34"+
    "\1\u0174\10\34\1\0\1\34\2\0\1\34\6\0\26\34"+
    "\31\0\17\34\1\0\1\34\2\0\1\34\6\0\1\34"+
    "\1\u0175\24\34\31\0\6\34\1\u0176\10\34\1\0\1\34"+
    "\2\0\1\34\6\0\26\34\31\0\17\34\1\0\1\34"+
    "\2\0\1\34\6\0\2\34\1\u0177\23\34\33\0\1\u0178"+
    "\1\162\1\0\1\163\4\0\3\u0178\1\0\1\163\1\171"+
    "\1\172\13\0\1\172\11\0\1\163\1\0\2\163\37\0"+
    "\17\34\1\0\1\34\2\0\1\34\6\0\11\34\1\u0179"+
    "\14\34\31\0\17\34\1\0\1\34\2\0\1\34\6\0"+
    "\2\34\1\u017a\23\34\31\0\17\34\1\0\1\34\2\0"+
    "\1\34\6\0\7\34\1\u017b\16\34\31\0\17\34\1\0"+
    "\1\34\2\0\1\34\6\0\14\34\1\u017c\11\34\33\0"+
    "\1\u017d\1\162\1\0\1\163\4\0\3\u017d\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\37\0\17\34\1\0\1\34\2\0\1\34\6\0\16\34"+
    "\1\u017e\7\34\31\0\17\34\1\0\1\34\2\0\1\34"+
    "\6\0\6\34\1\u017f\17\34\33\0\1\u0180\1\162\1\0"+
    "\1\163\4\0\3\u0180\1\0\1\163\1\171\1\172\13\0"+
    "\1\172\11\0\1\163\1\0\2\163\41\0\1\u0181\1\162"+
    "\1\0\1\163\4\0\3\u0181\1\0\1\163\1\171\1\172"+
    "\13\0\1\172\11\0\1\163\1\0\2\163\41\0\1\u0182"+
    "\1\162\1\0\1\163\4\0\3\u0182\1\0\1\163\1\171"+
    "\1\172\13\0\1\172\11\0\1\163\1\0\2\163\41\0"+
    "\1\u0183\1\162\1\0\1\163\4\0\3\u0183\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\41\0\1\u0184\1\162\1\0\1\163\4\0\3\u0184\1\0"+
    "\1\163\1\171\1\172\13\0\1\172\11\0\1\163\1\0"+
    "\2\163\41\0\1\u0185\1\162\1\0\1\163\4\0\3\u0185"+
    "\1\0\1\163\1\171\1\172\13\0\1\172\11\0\1\163"+
    "\1\0\2\163\41\0\1\u0186\1\162\1\0\1\163\4\0"+
    "\3\u0186\1\0\1\163\1\171\1\172\13\0\1\172\11\0"+
    "\1\163\1\0\2\163\41\0\1\u0187\1\162\1\0\1\163"+
    "\4\0\3\u0187\1\0\1\163\1\171\1\172\13\0\1\172"+
    "\11\0\1\163\1\0\2\163\41\0\1\u0188\1\162\1\0"+
    "\1\163\4\0\3\u0188\1\0\1\163\1\171\1\172\13\0"+
    "\1\172\11\0\1\163\1\0\2\163\41\0\1\u0189\1\162"+
    "\1\0\1\163\4\0\3\u0189\1\0\1\163\1\171\1\172"+
    "\13\0\1\172\11\0\1\163\1\0\2\163\41\0\1\u018a"+
    "\1\162\1\0\1\163\4\0\3\u018a\1\0\1\163\1\171"+
    "\1\172\13\0\1\172\11\0\1\163\1\0\2\163\41\0"+
    "\1\u018b\1\162\1\0\1\163\4\0\3\u018b\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\41\0\2\162\1\0\1\163\4\0\3\162\1\0\1\163"+
    "\1\171\1\172\13\0\1\172\11\0\1\163\1\0\2\163"+
    "\27\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[20513];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\14\0\1\1\4\0\1\11\1\1\1\11\1\1\1\11"+
    "\13\1\3\11\1\1\2\11\20\1\6\11\2\1\2\11"+
    "\5\1\1\11\2\1\2\11\1\1\1\11\2\1\1\11"+
    "\1\1\1\11\1\1\1\11\2\1\1\11\1\1\1\11"+
    "\1\1\1\11\4\1\2\11\3\1\3\11\4\1\1\11"+
    "\1\1\1\11\4\1\1\11\2\0\2\1\1\0\1\1"+
    "\2\0\2\1\1\0\2\11\1\1\1\11\42\1\2\11"+
    "\1\1\1\11\1\1\1\11\1\1\1\11\1\1\4\11"+
    "\1\0\3\1\1\0\1\1\2\11\1\0\1\11\3\0"+
    "\1\11\4\0\2\11\5\1\1\0\3\1\2\11\47\1"+
    "\3\11\1\1\2\11\3\0\1\11\2\0\1\1\1\0"+
    "\46\1\1\11\1\0\37\1\1\11\76\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[395];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private LexerInput input;

    private boolean embedded;

    private boolean canFollowLiteral = true;

    private boolean canFollowKeyword = true;

    private JsTokenId lastNonWhiteToken = null;

    private LinkedList<Brace> braceBalances = new LinkedList<>();

    private enum Brace {
            EXP,
            JSX,
            TEMPLATE
    }

    private LinkedList<Integer> jsxBalances = new LinkedList<Integer>();

    public JsColoringLexer(LexerRestartInfo info) {
        this.input = info.input();

        this.embedded = !JsTokenId.JAVASCRIPT_MIME_TYPE.equals(info.languagePath().mimePath());
        if(info.state() != null) {
            //reset state
            setState((LexerState)info.state());
        } else {
            //initial state
            zzState = zzLexicalState = YYINITIAL;
        }
    }

    public LexerState getState() {
        if (zzState == YYINITIAL && zzLexicalState == YYINITIAL
                && canFollowLiteral && canFollowKeyword) {
            return null;
        }
        return new LexerState(zzState, zzLexicalState, canFollowLiteral, canFollowKeyword, braceBalances, jsxBalances, lastNonWhiteToken);
    }

    public void setState(LexerState state) {
        this.zzState = state.zzState;
        this.zzLexicalState = state.zzLexicalState;
        this.canFollowLiteral = state.canFollowLiteral;
        this.canFollowKeyword = state.canFollowKeyword;
        this.braceBalances = new LinkedList<>(state.braceBalances);
        this.jsxBalances = new LinkedList<Integer>(state.jsxBalances);
        this.lastNonWhiteToken = state.lastNonWhiteToken;
    }

    public JsTokenId nextToken() throws java.io.IOException {
        JsTokenId token = yylex();
        if (token != null && !JsTokenId.ERROR.equals(token)
                && !JsTokenId.UNKNOWN.equals(token)
                && !JsTokenId.WHITESPACE.equals(token)
                && !JsTokenId.LINE_COMMENT.equals(token)
                && !JsTokenId.BLOCK_COMMENT.equals(token)
                && !JsTokenId.DOC_COMMENT.equals(token)) {
            canFollowLiteral = canFollowLiteral(token);
            if (!JsTokenId.EOL.equals(token)) {
                canFollowKeyword = canFollowKeyword(token);
                lastNonWhiteToken = token;
            }
        }
        return token;
    }

    private JsTokenId getErrorToken() {
        if (embedded) {
            return JsTokenId.UNKNOWN;
        }
        if (yystate() == JSX) {
            return JsTokenId.JSX_TEXT;
        }
        return JsTokenId.ERROR;
    }

    private static boolean canFollowLiteral(JsTokenId token) {
        switch (token) {
            case OPERATOR_INCREMENT:
            case OPERATOR_DECREMENT:
                return false;
            case BRACKET_LEFT_CURLY:
            case BRACKET_LEFT_PAREN:
            case BRACKET_LEFT_BRACKET:
            case KEYWORD_RETURN:
            case KEYWORD_THROW:
            case KEYWORD_YIELD:
            // unary operators (keyword)
            case KEYWORD_TYPEOF:
            // end of line
            case EOL:
            case OPERATOR_SEMICOLON:
            case OPERATOR_COMMA:
            case OPERATOR_DOT:
            case OPERATOR_COLON:
                return true;
        }

        if ("operator".equals(token.primaryCategory())) {
            return true;
        }
        return false;
    }

    private static boolean canFollowKeyword(JsTokenId token) {
        if (JsTokenId.OPERATOR_DOT.equals(token)) {
            return false;
        }
        return true;
    }

    public static final class LexerState  {
        /** the current state of the DFA */
        final int zzState;
        /** the current lexical state */
        final int zzLexicalState;
        /** can be the literal used here */
        final boolean canFollowLiteral;
        /** can be the literal used here */
        final boolean canFollowKeyword;
        /** where we are in Brace Type */
        final LinkedList<Brace> braceBalances;
        /** are we in jsx primary expression */
        final LinkedList<Integer> jsxBalances;
        /** remember last non white token */
        final JsTokenId lastNonWhiteToken;

        LexerState (int zzState, int zzLexicalState, boolean canFollowLiteral, boolean canFollowKeyword, LinkedList<Brace> braceBalances, LinkedList<Integer> jsxBalances, JsTokenId lastNonWhiteToken) {
            this.zzState = zzState;
            this.zzLexicalState = zzLexicalState;
            this.canFollowLiteral = canFollowLiteral;
            this.canFollowKeyword = canFollowKeyword;
            this.braceBalances = new LinkedList<>(braceBalances);
            this.jsxBalances = new LinkedList<Integer>(jsxBalances);
            this.lastNonWhiteToken = lastNonWhiteToken;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (getClass() != obj.getClass()) {
                return false;
            }
            final LexerState other = (LexerState) obj;
            if (this.zzState != other.zzState) {
                return false;
            }
            if (this.zzLexicalState != other.zzLexicalState) {
                return false;
            }
            if (this.canFollowLiteral != other.canFollowLiteral) {
                return false;
            }
            if (this.canFollowKeyword != other.canFollowKeyword) {
                return false;
            }
            if (this.braceBalances.size() != other.braceBalances.size()) {
                return false;
            }
            for (int i = 0; i < this.braceBalances.size(); i++) {
                if (this.braceBalances.get(i).equals(other.braceBalances.get(i))) {
                    return false;
                }
            }
            if (this.jsxBalances.size() != other.jsxBalances.size()) {
                return false;
            }
            for (int i = 0; i < this.jsxBalances.size(); i++) {
                if (this.jsxBalances.get(i).equals(other.jsxBalances.get(i))) {
                    return false;
                }
            }
            if (this.lastNonWhiteToken != other.lastNonWhiteToken) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.zzState;
            hash = 29 * hash + this.zzLexicalState;
            hash = 29 * hash + (this.canFollowLiteral ? 1 : 0);
            hash = 29 * hash + (this.canFollowKeyword ? 1 : 0);
            for (int i = 0; i < this.braceBalances.size(); i++) {
                hash = 29 * hash + this.braceBalances.get(i).ordinal();
            }
            for (int i = 0; i < this.jsxBalances.size(); i++) {
                hash = 29 * hash + this.jsxBalances.get(i);
            }
            hash = 29 * hash + this.lastNonWhiteToken.ordinal();
            return hash;
        }

        @Override
        public String toString() {
            return "LexerState{canFollowLiteral=" + canFollowLiteral + ", canFollowKeyword=" + canFollowKeyword
                + ", braceBalances=" + braceBalances + ", jsxBalances=" + jsxBalances + '}';
        }
    }

 // End user code



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JsColoringLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JsColoringLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2324) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

	// numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return input.readText().toString();
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return input.readText().charAt(pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return input.readLength();
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    input.backup(number);
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public JsTokenId yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      int tokenLength = 0;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          zzInput = input.read();

          if(zzInput == LexerInput.EOF) {
              //end of input reached
            zzInput = YYEOF;
            break zzForAction;
              //notice: currently LexerInput.EOF == YYEOF
          }

          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            tokenLength = input.readLength();
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      if(zzInput != YYEOF) {
         input.backup(input.readLength() - tokenLength);
      }

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 21: 
          { return JsTokenId.BRACKET_LEFT_PAREN;
          }
        case 138: break;
        case 62: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IF;
          }
        case 139: break;
        case 29: 
          { return JsTokenId.OPERATOR_BITWISE_NOT;
          }
        case 140: break;
        case 70: 
          { return JsTokenId.OPERATOR_BITWISE_AND_ASSIGNMENT;
          }
        case 141: break;
        case 134: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_INTERFACE;
          }
        case 142: break;
        case 111: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CLASS;
          }
        case 143: break;
        case 85: 
          { return JsTokenId.OPERATOR_REST;
          }
        case 144: break;
        case 39: 
          { yypushback(1);
                                     yybegin(STRINGEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.STRING;
                                     }
          }
        case 145: break;
        case 117: 
          { return JsTokenId.DOC_COMMENT;
          }
        case 146: break;
        case 14: 
          { yybegin(TEMPLATE);
                                    return JsTokenId.TEMPLATE_BEGIN;
          }
        case 147: break;
        case 50: 
          { braceBalances.push(Brace.JSX);
                                     yybegin(INITIAL);
                                     return JsTokenId.JSX_EXP_BEGIN;
          }
        case 148: break;
        case 8: 
          { return JsTokenId.PRIVATE_IDENTIFIER;
          }
        case 149: break;
        case 55: 
          { return JsTokenId.OPERATOR_MULTIPLICATION_ASSIGNMENT;
          }
        case 150: break;
        case 9: 
          { return JsTokenId.OPERATOR_NOT;
          }
        case 151: break;
        case 16: 
          { yybegin(SSTRING);
                                    return JsTokenId.STRING_BEGIN;
          }
        case 152: break;
        case 123: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IMPORT;
          }
        case 153: break;
        case 78: 
          { yypushback(2);
                                     yybegin(TEMPLATEEXP);
                                     if (tokenLength - 2 > 0) {
                                         return JsTokenId.TEMPLATE;
                                     }
          }
        case 154: break;
        case 86: 
          { return JsTokenId.OPERATOR_LEFT_SHIFT_ARITHMETIC_ASSIGNMENT;
          }
        case 155: break;
        case 64: 
          { return JsTokenId.OPERATOR_EQUALS;
          }
        case 156: break;
        case 30: 
          { return JsTokenId.OPERATOR_COLON;
          }
        case 157: break;
        case 137: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_IMPLEMENTS;
          }
        case 158: break;
        case 58: 
          { return JsTokenId.OPERATOR_MINUS_ASSIGNMENT;
          }
        case 159: break;
        case 32: 
          { return JsTokenId.OPERATOR_BITWISE_OR;
          }
        case 160: break;
        case 131: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CONTINUE;
          }
        case 161: break;
        case 25: 
          { return JsTokenId.OPERATOR_SEMICOLON;
          }
        case 162: break;
        case 106: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ASSIGNMENT;
          }
        case 163: break;
        case 17: 
          { if (!canFollowLiteral || (lastNonWhiteToken != null 
                  && (lastNonWhiteToken == JsTokenId.IDENTIFIER
                  || lastNonWhiteToken == JsTokenId.NUMBER))) {
                                        return JsTokenId.OPERATOR_LOWER; 
                                   } else {
                                        jsxBalances.push(0);
                                        yypushback(1);
                                        yybegin(JSX);
                                   }
          }
        case 164: break;
        case 59: 
          { return JsTokenId.OPERATOR_LEFT_SHIFT_ARITHMETIC;
          }
        case 165: break;
        case 128: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FINALLY;
          }
        case 166: break;
        case 38: 
          { yypushback(1);
                                     yybegin(INITIAL);
                                     if (tokenLength - 1 > 0) {
                                         return getErrorToken();
                                     }
          }
        case 167: break;
        case 27: 
          { return JsTokenId.OPERATOR_TERNARY;
          }
        case 168: break;
        case 20: 
          { return JsTokenId.OPERATOR_ASSIGNMENT;
          }
        case 169: break;
        case 122: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_TYPEOF;
          }
        case 170: break;
        case 40: 
          { yybegin(INITIAL);
                                     return JsTokenId.STRING_END;
          }
        case 171: break;
        case 66: 
          { return JsTokenId.OPERATOR_OPTIONAL_ACCESS;
          }
        case 172: break;
        case 31: 
          { return JsTokenId.OPERATOR_BITWISE_AND;
          }
        case 173: break;
        case 28: 
          { return JsTokenId.OPERATOR_GREATER;
          }
        case 174: break;
        case 24: 
          { // we are checking if we are in template expression
                                     if (!braceBalances.isEmpty()) {
                                        Brace braceType = braceBalances.pop();
                                        if (braceType == Brace.TEMPLATE) {
                                            yypushback(1);
                                            yybegin(TEMPLATEEXPEND);
                                        } else if (braceType == Brace.JSX) {
                                            yypushback(1);
                                            yybegin(JSXEXPEND);
                                        } else {
                                            return JsTokenId.BRACKET_RIGHT_CURLY;
                                        }
                                     } else {
                                        return JsTokenId.BRACKET_RIGHT_CURLY;
                                     }
          }
        case 175: break;
        case 133: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FUNCTION;
          }
        case 176: break;
        case 22: 
          { return JsTokenId.BRACKET_RIGHT_PAREN;
          }
        case 177: break;
        case 80: 
          { yypushback(1);
                                     yybegin(REGEXPEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.REGEXP;
                                     }
          }
        case 178: break;
        case 113: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_THROW;
          }
        case 179: break;
        case 84: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_NEW;
          }
        case 180: break;
        case 76: 
          { return JsTokenId.OPERATOR_BITWISE_XOR_ASSIGNMENT;
          }
        case 181: break;
        case 26: 
          { return JsTokenId.OPERATOR_COMMA;
          }
        case 182: break;
        case 91: 
          { return JsTokenId.OPERATOR_EQUALS_EXACTLY;
          }
        case 183: break;
        case 68: 
          { return JsTokenId.OPERATOR_GREATER_EQUALS;
          }
        case 184: break;
        case 56: 
          { return JsTokenId.OPERATOR_NOT_EQUALS;
          }
        case 185: break;
        case 102: 
          { return JsTokenId.KEYWORD_TRUE;
          }
        case 186: break;
        case 71: 
          { return JsTokenId.OPERATOR_AND;
          }
        case 187: break;
        case 75: 
          { return JsTokenId.OPERATOR_INCREMENT;
          }
        case 188: break;
        case 5: 
          { return JsTokenId.WHITESPACE;
          }
        case 189: break;
        case 83: 
          { return JsTokenId.OPERATOR_NOT_EQUALS_EXACTLY;
          }
        case 190: break;
        case 89: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_LET;
          }
        case 191: break;
        case 73: 
          { return JsTokenId.OPERATOR_OR;
          }
        case 192: break;
        case 92: 
          { return JsTokenId.OPERATOR_ASSIGN_NULLISH;
          }
        case 193: break;
        case 130: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PACKAGE;
          }
        case 194: break;
        case 126: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_EXTENDS;
          }
        case 195: break;
        case 100: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_ELSE;
          }
        case 196: break;
        case 90: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_VAR;
          }
        case 197: break;
        case 2: 
          { yypushback(1);
                                   yybegin(INITIAL);
          }
        case 198: break;
        case 104: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_WITH;
          }
        case 199: break;
        case 46: 
          { yypushback(1);
                                     yybegin(ERROR);
          }
        case 200: break;
        case 77: 
          { return JsTokenId.OPERATOR_MODULUS_ASSIGNMENT;
          }
        case 201: break;
        case 94: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT;
          }
        case 202: break;
        case 36: 
          { return JsTokenId.OPERATOR_AT;
          }
        case 203: break;
        case 57: 
          { return JsTokenId.OPERATOR_DECREMENT;
          }
        case 204: break;
        case 120: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_STATIC;
          }
        case 205: break;
        case 47: 
          { yybegin(INITIAL);
                                     return JsTokenId.REGEXP_END;
          }
        case 206: break;
        case 82: 
          { return JsTokenId.OPERATOR_EXPONENTIATION_ASSIGNMENT;
          }
        case 207: break;
        case 34: 
          { return JsTokenId.OPERATOR_BITWISE_XOR;
          }
        case 208: break;
        case 44: 
          { yybegin(INITIAL);
                                     return JsTokenId.TEMPLATE_END;
          }
        case 209: break;
        case 101: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CASE;
          }
        case 210: break;
        case 1: 
          { yybegin(INITIAL);
                                     if (tokenLength > 0) {
                                         return JsTokenId.EOL;
                                     }
          }
        case 211: break;
        case 41: 
          { yypushback(1);
                                     yybegin(INITIAL);
                                     if (tokenLength -1 > 0) {
                                         return getErrorToken();
                                     }
          }
        case 212: break;
        case 116: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_WHILE;
          }
        case 213: break;
        case 69: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ARITHMETIC;
          }
        case 214: break;
        case 103: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_THIS;
          }
        case 215: break;
        case 136: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_INSTANCEOF;
          }
        case 216: break;
        case 110: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CONST;
          }
        case 217: break;
        case 15: 
          { yybegin(STRING);
                                    return JsTokenId.STRING_BEGIN;
          }
        case 218: break;
        case 88: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_FOR;
          }
        case 219: break;
        case 119: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_EXPORT;
          }
        case 220: break;
        case 93: 
          { return JsTokenId.OPERATOR_RIGHT_SHIFT_ARITHMETIC_ASSIGNMENT;
          }
        case 221: break;
        case 124: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DELETE;
          }
        case 222: break;
        case 79: 
          { braceBalances.push(Brace.TEMPLATE);
                                     yybegin(INITIAL);
                                     return JsTokenId.TEMPLATE_EXP_BEGIN;
          }
        case 223: break;
        case 3: 
          { return getErrorToken();
          }
        case 224: break;
        case 6: 
          { if (canFollowLiteral) {
                                       yybegin(REGEXP);
                                       return JsTokenId.REGEXP_BEGIN;
                                     } else {
                                       return JsTokenId.OPERATOR_DIVISION;
                                     }
          }
        case 225: break;
        case 107: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_BREAK;
          }
        case 226: break;
        case 33: 
          { return JsTokenId.OPERATOR_PLUS;
          }
        case 227: break;
        case 63: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DO;
          }
        case 228: break;
        case 61: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_IN;
          }
        case 229: break;
        case 53: 
          { if (canFollowLiteral) {
                                       yypushback(1);
                                       yybegin(REGEXP);
                                       return JsTokenId.REGEXP_BEGIN;
                                     } else {
                                       return JsTokenId.OPERATOR_DIVISION_ASSIGNMENT;
                                     }
          }
        case 230: break;
        case 135: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PROTECTED;
          }
        case 231: break;
        case 49: 
          { yypushback(1);
                                     yybegin(JSXEXP);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.JSX_TEXT;
                                     }
          }
        case 232: break;
        case 97: 
          { return JsTokenId.BLOCK_COMMENT;
          }
        case 233: break;
        case 96: 
          { return JsTokenId.OPERATOR_ASSIGN_LOG_OR;
          }
        case 234: break;
        case 7: 
          { return JsTokenId.OPERATOR_MULTIPLICATION;
          }
        case 235: break;
        case 118: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_RETURN;
          }
        case 236: break;
        case 10: 
          { return JsTokenId.IDENTIFIER;
          }
        case 237: break;
        case 98: 
          { return JsTokenId.KEYWORD_NULL;
          }
        case 238: break;
        case 11: 
          { return JsTokenId.NUMBER;
          }
        case 239: break;
        case 87: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_TRY;
          }
        case 240: break;
        case 127: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DEFAULT;
          }
        case 241: break;
        case 81: 
          { Integer balance = jsxBalances.isEmpty() ? 0 : jsxBalances.pop() - 1;
                                     if (balance <= 0) {
                                        yybegin(INITIAL);
                                        return JsTokenId.JSX_TEXT;
                                     } else {
                                        jsxBalances.push(balance);
                                     }
          }
        case 242: break;
        case 115: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_YIELD;
          }
        case 243: break;
        case 23: 
          { // we are checking if we are in template expression
                                     if (!braceBalances.isEmpty()) {
                                        braceBalances.push(Brace.EXP);
                                     }

                                     return JsTokenId.BRACKET_LEFT_CURLY;
          }
        case 244: break;
        case 54: 
          { return JsTokenId.OPERATOR_EXPONENTIATION;
          }
        case 245: break;
        case 60: 
          { return JsTokenId.OPERATOR_LOWER_EQUALS;
          }
        case 246: break;
        case 72: 
          { return JsTokenId.OPERATOR_BITWISE_OR_ASSIGNMENT;
          }
        case 247: break;
        case 112: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_SUPER;
          }
        case 248: break;
        case 51: 
          { yybegin(JSX);
                                    return JsTokenId.JSX_EXP_END;
          }
        case 249: break;
        case 121: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_SWITCH;
          }
        case 250: break;
        case 95: 
          { return JsTokenId.OPERATOR_ASSIGN_LOG_AND;
          }
        case 251: break;
        case 125: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PUBLIC;
          }
        case 252: break;
        case 105: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_VOID;
          }
        case 253: break;
        case 4: 
          { return JsTokenId.EOL;
          }
        case 254: break;
        case 109: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_CATCH;
          }
        case 255: break;
        case 52: 
          { yybegin(LCOMMENTEND);
                                   return JsTokenId.LINE_COMMENT;
          }
        case 256: break;
        case 12: 
          { return JsTokenId.OPERATOR_DOT;
          }
        case 257: break;
        case 114: 
          { return JsTokenId.KEYWORD_FALSE;
          }
        case 258: break;
        case 42: 
          { yypushback(1);
                                     yybegin(SSTRINGEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.STRING;
                                     }
          }
        case 259: break;
        case 35: 
          { return JsTokenId.OPERATOR_MODULUS;
          }
        case 260: break;
        case 18: 
          { return JsTokenId.BRACKET_LEFT_BRACKET;
          }
        case 261: break;
        case 132: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.KEYWORD_DEBUGGER;
          }
        case 262: break;
        case 108: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_AWAIT;
          }
        case 263: break;
        case 19: 
          { return JsTokenId.BRACKET_RIGHT_BRACKET;
          }
        case 264: break;
        case 129: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_PRIVATE;
          }
        case 265: break;
        case 13: 
          { return JsTokenId.OPERATOR_MINUS;
          }
        case 266: break;
        case 74: 
          { return JsTokenId.OPERATOR_PLUS_ASSIGNMENT;
          }
        case 267: break;
        case 67: 
          { return JsTokenId.OPERATOR_NULLISH;
          }
        case 268: break;
        case 99: 
          { if (!canFollowKeyword) { return JsTokenId.IDENTIFIER; } return JsTokenId.RESERVED_ENUM;
          }
        case 269: break;
        case 43: 
          { yypushback(1);
                                     yybegin(TEMPLATEEND);
                                     if (tokenLength - 1 > 0) {
                                         return JsTokenId.TEMPLATE;
                                     }
          }
        case 270: break;
        case 45: 
          { yybegin(TEMPLATE);
                                     return JsTokenId.TEMPLATE_EXP_END;
          }
        case 271: break;
        case 48: 
          { Integer balance = jsxBalances.isEmpty() ? 0 : jsxBalances.pop();
                                    jsxBalances.push(balance+1);
          }
        case 272: break;
        case 37: 
          { 
          }
        case 273: break;
        case 65: 
          { return JsTokenId.OPERATOR_ARROW;
          }
        case 274: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                if (input.readLength() > 0) {
        // backup eof
        input.backup(1);
        //and return the text as error token
        return getErrorToken();
    } else {
        return null;
    }
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
