/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.pkg.TermOfSupport;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;

public class QuickPanel extends javax.swing.JPanel {

    public QuickPanel() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        javax.swing.JLabel jLabel1 = new javax.swing.JLabel();
        versions = new javax.swing.JSlider();
        autoInstallJDK = new javax.swing.JRadioButton();
        manualJDK = new javax.swing.JRadioButton();

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(QuickPanel.class, "QuickPanel.jLabel1.text")); // NOI18N

        versions.setMaximum(20);
        versions.setMinimum(8);
        versions.setPaintLabels(true);
        versions.setPaintTicks(true);
        versions.setSnapToTicks(true);
        versions.setValue(15);
        versions.setInverted(true);

        buttonGroup1.add(autoInstallJDK);
        autoInstallJDK.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(autoInstallJDK, org.openide.util.NbBundle.getMessage(QuickPanel.class, "QuickPanel.autoInstallJDK.text")); // NOI18N
        autoInstallJDK.setToolTipText(org.openide.util.NbBundle.getMessage(QuickPanel.class, "QuickPanel.autoInstallJDK.toolTipText")); // NOI18N

        buttonGroup1.add(manualJDK);
        org.openide.awt.Mnemonics.setLocalizedText(manualJDK, org.openide.util.NbBundle.getMessage(QuickPanel.class, "QuickPanel.manualJDK.text")); // NOI18N
        manualJDK.setToolTipText(org.openide.util.NbBundle.getMessage(QuickPanel.class, "QuickPanel.manualJDK.toolTipText")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(versions, javax.swing.GroupLayout.DEFAULT_SIZE, 481, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(autoInstallJDK)
                            .addComponent(manualJDK))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(versions, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(autoInstallJDK)
                .addGap(12, 12, 12)
                .addComponent(manualJDK)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton autoInstallJDK;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton manualJDK;
    private javax.swing.JSlider versions;
    // End of variables declaration//GEN-END:variables

    //The `versions` slider holds *the index* in versionsJDKs and
    //this model holds the actual JDKs and the mapping between
    static class VersionsModel {

        private final List<Integer> versionJDKs;
        private final Map<Integer, TermOfSupport> lts;

        private VersionsModel(List<Integer> jdks, Map<Integer, TermOfSupport> lts) {
            this.versionJDKs = new ArrayList<>(jdks);
            //quick panel shows only maintained JDKs
            versionJDKs.removeIf(v -> !lts.containsKey(v));
            versionJDKs.removeIf(v -> v <= 6); //TODO: Normally the minimum is 6 but we wouldn't do that, would we?
            this.lts = lts;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return versionJDKs.size() - 1;
        }

        public int getDefaultValue() {
            return versionJDKs.indexOf(LTSes.latest(lts));
        }

        @UIEffect
        @NonNull
        public Hashtable<Integer, JLabel> createLabels() {
            Hashtable<Integer, JLabel> labels = new Hashtable<>();
            for (Integer v : versionJDKs) {
                boolean isLTS = lts.containsKey(v);
                String name = isLTS ? LTSes.text(v, lts.get(v)) : String.valueOf(v);
                JLabel label = new JLabel(name);
                if (isLTS) {
                    //these decorations do nothing on macOS...
                    Font font = label.getFont();
                    label.setFont(font.deriveFont(font.getStyle() | Font.BOLD));
                    label.setToolTipText("Long Term Support");
                }
                labels.put(versionJDKs.indexOf(v), label);
            }
            return labels;
        }

        private int getJDK(int index) {
            return versionJDKs.get(index);
        }

    }

    @MonotonicNonNull
    private VersionsModel versionsModel;

    void setVersions(List<Integer> jdks, Map<Integer, TermOfSupport> lts) {
        versionsModel = new VersionsModel(jdks, lts);
        versions.setMaximum(versionsModel.getMaximum());
        versions.setMinimum(versionsModel.getMinimum());
        versions.setLabelTable(versionsModel.createLabels());
        versions.setValue(versionsModel.getDefaultValue());
    }

    @UIEffect
    @NonNull
    QuickSelection getSelectedPackage() {
        return new QuickSelection(versionsModel.getJDK(versions.getValue()), autoInstallJDK.isSelected());
    }

    static class QuickSelection {

        final int version;
        final boolean zip;

        public QuickSelection(int version, boolean zip) {
            this.version = version;
            this.zip = zip;
        }
    }
}
