/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.actions.GarbageCollectAction;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

class HeapView
extends JComponent {
    private static final boolean AUTOMATIC_REFRESH = System.getProperty("org.netbeans.log.startup") == null;
    private static final int TICK = 1500;
    private static final Color CHART_COLOR;
    private static final Color TEXT_COLOR;
    private static final Color BACKGROUND_COLOR;
    private static final int GRAPH_COUNT = 100;
    private static final String SHOW_TEXT = "showText";
    private final MessageFormat format;
    private final long[] graph = new long[100];
    private int graphIndex;
    private long lastTotal;
    private Timer updateTimer;
    private int maxTextWidth;
    private String heapSizeText = "";

    public HeapView() {
        this.format = new MessageFormat("{0,choice,0#{0,number,0.0}|999<{0,number,0}}/{1,choice,0#{1,number,0.0}|999<{1,number,0}}MB");
        this.enableEvents(16L);
        this.setToolTipText(NbBundle.getMessage(GarbageCollectAction.class, (String)"CTL_GC"));
        this.updateUI();
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    @Override
    public void updateUI() {
        Font f = UIManager.getFont("Label.font");
        this.setFont(f);
    }

    public void setShowText(boolean showText) {
        this.prefs().putBoolean(SHOW_TEXT, showText);
        this.repaint();
    }

    public boolean getShowText() {
        return this.prefs().getBoolean(SHOW_TEXT, true);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateTextWidth();
    }

    Dimension heapViewPreferredSize() {
        Dimension size = new Dimension(this.maxTextWidth + 8, this.getFontMetrics(this.getFont()).getHeight() + 8);
        return size;
    }

    private Preferences prefs() {
        return NbPreferences.forModule(HeapView.class);
    }

    private void updateTextWidth() {
        String maxString = this.format.format(new Object[]{Float.valueOf(888.8f), Float.valueOf(888.8f)});
        this.maxTextWidth = this.getFontMetrics(this.getFont()).stringWidth(maxString) + 4;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (!e.isConsumed() && e.isPopupTrigger()) {
            this.showPopup(e.getX(), e.getY());
        }
        if (e.getID() == 500 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
            ((GarbageCollectAction)GarbageCollectAction.get(GarbageCollectAction.class)).performAction();
        }
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(NbBundle.getMessage(HeapView.class, (String)"LBL_ShowText"));
        cbmi.setSelected(this.getShowText());
        cbmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeapView.this.setShowText(((JCheckBoxMenuItem)e.getSource()).isSelected());
            }
        });
        popup.add(cbmi);
        popup.show(this, x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            this.startTimerIfNecessary();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setPaint(BACKGROUND_COLOR);
            g2.fillRect(0, 0, width + 1, height + 1);
            g2.setPaint(CHART_COLOR);
            this.paintSamples(g2, width, height);
            if (this.getShowText()) {
                this.paintText(g2, width, height);
            }
        } else {
            this.stopTimerIfNecessary();
        }
    }

    private void paintText(Graphics2D g, int w, int h) {
        g.setFont(this.getFont());
        String text = this.getHeapSizeText();
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        int x = (w - this.maxTextWidth) / 2 + (this.maxTextWidth - textWidth);
        int y = h / 2 + fm.getAscent() / 2 - 2;
        g.setColor(TEXT_COLOR);
        g.drawString(text, x, y);
    }

    private String getHeapSizeText() {
        return this.heapSizeText;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopTimerIfNecessary();
    }

    private void startTimerIfNecessary() {
        if (!AUTOMATIC_REFRESH) {
            return;
        }
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HeapView.this.update();
                }
            });
            this.updateTimer.setRepeats(true);
            this.updateTimer.start();
        }
    }

    private void stopTimerIfNecessary() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
            this.lastTotal = 0L;
            Arrays.fill(this.graph, 0L);
            this.heapSizeText = "";
        }
    }

    private void update() {
        if (this.isShowing()) {
            long used;
            Runtime r = Runtime.getRuntime();
            long total = r.totalMemory();
            this.graph[this.graphIndex] = used = total - r.freeMemory();
            this.lastTotal = total;
            ++this.graphIndex;
            if (this.graphIndex >= 100) {
                this.graphIndex = 0;
            }
            this.heapSizeText = this.format.format(new Object[]{(double)used / 1048576.0, (double)total / 1048576.0});
            this.repaint();
        } else {
            this.stopTimerIfNecessary();
        }
    }

    private void paintSamples(Graphics2D g, int width, int height) {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(0.0, height);
        for (int i = 0; i < 100; ++i) {
            int index = (i + this.graphIndex) % 100;
            double x = (double)i / 99.0 * (double)width;
            double y = (double)height * (1.0 - (double)this.graph[index] / (double)this.lastTotal);
            ((Path2D)path).lineTo(x, y);
        }
        ((Path2D)path).lineTo(width, height);
        path.closePath();
        g.fill(path);
    }

    static {
        Color c = UIManager.getColor("nb.heapview.chart");
        if (null == c) {
            c = new Color(3051752);
        }
        CHART_COLOR = c;
        c = UIManager.getColor("nb.heapview.foreground");
        if (null == c) {
            c = Color.DARK_GRAY;
        }
        TEXT_COLOR = c;
        c = UIManager.getColor("nb.heapview.background");
        if (null == c) {
            c = new Color(13556710);
        }
        BACKGROUND_COLOR = c;
    }
}

