/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.TimedSoftReference;

public class NbBundle {
    private static final Logger LOG = Logger.getLogger(NbBundle.class.getName());
    private static final boolean USE_DEBUG_LOADER = Boolean.getBoolean("org.openide.util.NbBundle.DEBUG");
    private static String brandingToken = null;
    static final Map<ClassLoader, Map<String, URL>> localizedFileCache = new WeakHashMap<ClassLoader, Map<String, URL>>();
    static final Map<ClassLoader, Map<String, Reference<ResourceBundle>>> bundleCache = new WeakHashMap<ClassLoader, Map<String, Reference<ResourceBundle>>>();

    @Deprecated
    public NbBundle() {
    }

    public static String getBranding() {
        return brandingToken;
    }

    public static void setBranding(String bt) throws IllegalArgumentException {
        if (bt != null && !bt.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
            throw new IllegalArgumentException("Malformed branding token: " + bt);
        }
        brandingToken = bt;
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String baseName, String ext) throws MissingResourceException {
        return NbBundle.getLocalizedFile(baseName, ext, Locale.getDefault(), NbBundle.getLoader());
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String baseName, String ext, Locale locale) throws MissingResourceException {
        return NbBundle.getLocalizedFile(baseName, ext, locale, NbBundle.getLoader());
    }

    @Deprecated
    public static synchronized URL getLocalizedFile(String baseName, String ext, Locale locale, ClassLoader loader) throws MissingResourceException {
        URL lookup = null;
        Iterator<String> it = new LocaleIterator(locale);
        ArrayList<String> cacheCandidates = new ArrayList<String>(10);
        String baseNameSlashes = baseName.replace('.', '/');
        Map<String, URL> perLoaderCache = localizedFileCache.get(loader);
        if (perLoaderCache == null) {
            perLoaderCache = new HashMap<String, URL>();
            localizedFileCache.put(loader, perLoaderCache);
        }
        String path = ext != null ? baseNameSlashes + '.' + ext : baseNameSlashes;
        lookup = perLoaderCache.get(path);
        URL baseVariant = lookup == null ? loader.getResource(path) : null;
        while (it.hasNext()) {
            String suffix = (String)it.next();
            path = ext != null ? baseNameSlashes + suffix + '.' + ext : baseNameSlashes + suffix;
            lookup = perLoaderCache.get(path);
            if (lookup != null) break;
            cacheCandidates.add(path);
            lookup = suffix.length() == 0 ? baseVariant : loader.getResource(path);
            if (lookup == null) continue;
            break;
        }
        if (lookup == null) {
            path = baseName.replace('.', '/');
            if (ext != null) {
                path = path + '.' + ext;
            }
            throw new MissingResourceException("Cannot find localized resource " + path + " in " + loader, loader.toString(), path);
        }
        it = cacheCandidates.iterator();
        while (it.hasNext()) {
            perLoaderCache.put(it.next(), lookup);
        }
        return lookup;
    }

    public static <T> T getLocalizedValue(Map<String, T> table, String key, Locale locale) {
        for (String suffix : NbCollections.iterable(new LocaleIterator(locale))) {
            String physicalKey = key + suffix;
            T v = table.get(physicalKey);
            if (v == null) continue;
            if (USE_DEBUG_LOADER && v instanceof String) {
                String _v = (String)v + " (?:" + physicalKey + ")";
                return (T)_v;
            }
            return v;
        }
        return null;
    }

    public static <T> T getLocalizedValue(Map<String, T> table, String key) {
        return NbBundle.getLocalizedValue(table, key, Locale.getDefault());
    }

    public static String getLocalizedValue(Attributes attr, Attributes.Name key, Locale locale) {
        return NbBundle.getLocalizedValue(NbBundle.attr2Map(attr), key.toString().toLowerCase(Locale.US), locale);
    }

    public static String getLocalizedValue(Attributes attr, Attributes.Name key) {
        return NbBundle.getLocalizedValue(NbBundle.attr2Map(attr), key.toString().toLowerCase(Locale.US));
    }

    private static Map<String, String> attr2Map(Attributes attr) {
        return new AttributesMap(attr);
    }

    public static ResourceBundle getBundle(String baseName) throws MissingResourceException {
        return NbBundle.getBundle(baseName, Locale.getDefault(), NbBundle.getLoader());
    }

    public static ResourceBundle getBundle(Class<?> clazz) throws MissingResourceException {
        String name = NbBundle.findName(clazz);
        return NbBundle.getBundle(name, Locale.getDefault(), clazz.getClassLoader());
    }

    private static String findName(Class<?> clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        if (last >= 0) {
            pref = pref.substring(0, last + 1);
            return pref + "Bundle";
        }
        return "Bundle";
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) throws MissingResourceException {
        return NbBundle.getBundle(baseName, locale, NbBundle.getLoader());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        ResourceBundle b;
        if (USE_DEBUG_LOADER) {
            loader = DebugLoader.get(loader);
        }
        if ((b = NbBundle.getBundleFast(baseName, locale, loader)) != null) {
            return b;
        }
        MissingResourceException e = new MissingResourceException("No such bundle " + baseName, baseName, null);
        if (Lookup.getDefault().lookup(ClassLoader.class) == null) {
            Exceptions.attachMessage(e, "Class loader not yet initialized in lookup");
        } else {
            Exceptions.attachMessage(e, "Offending classloader: " + loader);
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle getBundleFast(String name, Locale locale, ClassLoader loader) {
        Map<String, Reference<ResourceBundle>> m;
        Map<ClassLoader, Map<String, Reference<ResourceBundle>>> map = bundleCache;
        synchronized (map) {
            m = bundleCache.get(loader);
            if (m == null) {
                m = new HashMap<String, Reference<ResourceBundle>>();
                bundleCache.put(loader, m);
            }
        }
        String localeStr = locale.toString();
        char[] k = new char[name.length() + (brandingToken != null ? brandingToken.length() : 1) + 2 + localeStr.length()];
        name.getChars(0, name.length(), k, 0);
        k[name.length()] = 47;
        int pos = name.length() + 1;
        if (brandingToken == null) {
            k[pos] = 45;
            ++pos;
        } else {
            brandingToken.getChars(0, brandingToken.length(), k, pos);
            pos += brandingToken.length();
        }
        k[pos] = 47;
        localeStr.getChars(0, localeStr.length(), k, ++pos);
        String key = new String(k);
        Map<String, Reference<ResourceBundle>> map2 = m;
        synchronized (map2) {
            ResourceBundle b;
            Reference<ResourceBundle> o = m.get(key);
            ResourceBundle resourceBundle = b = o != null ? o.get() : null;
            if (b != null) {
                return b;
            }
            b = NbBundle.loadBundle(name, locale, loader);
            if (b != null) {
                m.put(key, new TimedSoftReference<ResourceBundle>(b, m, key));
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle loadBundle(String name, Locale locale, ClassLoader loader) {
        String sname = name.replace('.', '/');
        LocaleIterator it = new LocaleIterator(locale);
        LinkedList<String> l = new LinkedList<String>();
        while (it.hasNext()) {
            l.addFirst((String)it.next());
        }
        Properties p = new Properties();
        for (String suffix : l) {
            URL u;
            String res = sname + suffix + ".properties";
            URL uRL = u = loader != null ? loader.getResource(res) : ClassLoader.getSystemResource(res);
            if (u != null) {
                try {
                    InputStream is = USE_DEBUG_LOADER ? (loader != null ? loader.getResourceAsStream(res) : ClassLoader.getSystemResourceAsStream(res)) : u.openStream();
                    try {
                        p.load(is);
                        continue;
                    }
                    finally {
                        is.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    Exceptions.attachMessage(e, "While loading: " + res);
                    LOG.log(Level.WARNING, null, e);
                    return null;
                }
            }
            if (suffix.length() != 0) continue;
            return NbBundle.loadBundleClass(name, sname, locale, l, loader);
        }
        return new PBundle(NbCollections.checkedMapByFilter(p, String.class, String.class, true), locale);
    }

    private static ResourceBundle loadBundleClass(String name, String sname, Locale locale, List<String> suffixes, ClassLoader l) {
        if (l != null && l.getResource(sname + ".class") == null) {
            return null;
        }
        ResourceBundle master = null;
        for (String suffix : suffixes) {
            try {
                Class<ResourceBundle> c = Class.forName(name + suffix, true, l).asSubclass(ResourceBundle.class);
                ResourceBundle b = c.newInstance();
                if (master == null) {
                    master = b;
                    continue;
                }
                master = new MergedBundle(locale, b, master);
            }
            catch (ClassNotFoundException c) {
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, null, e);
            }
            catch (LinkageError e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
        return master;
    }

    public static String getMessage(Class<?> clazz, String resName) throws MissingResourceException {
        return NbBundle.getBundle(clazz).getString(resName);
    }

    public static String getMessage(Class<?> clazz, String resName, Object param1) throws MissingResourceException {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1});
    }

    public static String getMessage(Class<?> clazz, String resName, Object param1, Object param2) throws MissingResourceException {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1, param2});
    }

    public static String getMessage(Class<?> clazz, String resName, Object param1, Object param2, Object param3) throws MissingResourceException {
        return NbBundle.getMessage(clazz, resName, new Object[]{param1, param2, param3});
    }

    public static String getMessage(Class<?> clazz, String resName, Object param1, Object param2, Object param3, Object param4, Object ... params) throws MissingResourceException {
        Object[] allParams = new Object[params.length + 4];
        allParams[0] = param1;
        allParams[1] = param2;
        allParams[2] = param3;
        allParams[3] = param4;
        System.arraycopy(params, 0, allParams, 4, params.length);
        return NbBundle.getMessage(clazz, resName, allParams);
    }

    public static String getMessage(Class<?> clazz, String resName, Object[] arr) throws MissingResourceException {
        return MessageFormat.format(NbBundle.getMessage(clazz, resName), arr);
    }

    private static ClassLoader getLoader() {
        ClassLoader c = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        return c != null ? c : ClassLoader.getSystemClassLoader();
    }

    public static Iterator<String> getLocalizingSuffixes() {
        return new LocaleIterator(Locale.getDefault());
    }

    @Deprecated
    public static void setClassLoaderFinder(ClassLoaderFinder loaderFinder) {
        throw new Error();
    }

    static final class DebugLoader
    extends ClassLoader {
        private static int count = 0;
        private static final Map<String, Integer> knownIDs = new HashMap<String, Integer>();
        private static final Map<ClassLoader, Reference<ClassLoader>> existing = new WeakHashMap<ClassLoader, Reference<ClassLoader>>();

        private DebugLoader(ClassLoader cl) {
            super(cl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int getID(String name) {
            Map<String, Integer> map = knownIDs;
            synchronized (map) {
                Integer i = knownIDs.get(name);
                if (i == null) {
                    i = ++count;
                    knownIDs.put(name, i);
                    System.err.println("NbBundle trace: #" + i + " = " + name);
                }
                return i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ClassLoader get(ClassLoader normal) {
            Map<ClassLoader, Reference<ClassLoader>> map = existing;
            synchronized (map) {
                ClassLoader dl;
                Reference<ClassLoader> r = existing.get(normal);
                if (r != null && (dl = r.get()) != null) {
                    return dl;
                }
                dl = new DebugLoader(normal);
                existing.put(normal, new WeakReference<ClassLoader>(dl));
                return dl;
            }
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream base = super.getResourceAsStream(name);
            if (base == null) {
                return null;
            }
            if (name.endsWith(".properties")) {
                int id = DebugLoader.getID(name);
                boolean loc = name.indexOf("Bundle") != -1;
                return new DebugInputStream(base, id, loc);
            }
            return base;
        }

        static final class DebugInputStream
        extends InputStream {
            private static final int WAITING_FOR_KEY = 0;
            private static final int IN_COMMENT = 1;
            private static final int IN_KEY = 2;
            private static final int IN_KEY_BACKSLASH = 3;
            private static final int AFTER_KEY = 4;
            private static final int WAITING_FOR_VALUE = 5;
            private static final int IN_VALUE = 6;
            private static final int IN_VALUE_BACKSLASH = 7;
            private final InputStream base;
            private final int id;
            private final boolean localizable;
            private int line = 0;
            private int keyLine = 0;
            private int state = 0;
            private boolean twixtCrAndNl = false;
            private String toInsert = null;
            private boolean reverseLocalizable = false;
            private StringBuffer lastComment = null;
            private final StringBuilder currentValue = new StringBuilder();

            public DebugInputStream(InputStream base, int id, boolean localizable) {
                this.base = base;
                this.id = id;
                this.localizable = localizable;
            }

            @Override
            public int read() throws IOException {
                if (this.toInsert != null) {
                    char result = this.toInsert.charAt(0);
                    this.toInsert = this.toInsert.length() > 1 ? this.toInsert.substring(1) : null;
                    return result;
                }
                int next = this.base.read();
                if (next == 10) {
                    this.twixtCrAndNl = false;
                    ++this.line;
                } else if (next == 13) {
                    if (this.twixtCrAndNl) {
                        ++this.line;
                    } else {
                        this.twixtCrAndNl = true;
                    }
                } else {
                    this.twixtCrAndNl = false;
                }
                switch (this.state) {
                    case 0: {
                        switch (next) {
                            case 33: 
                            case 35: {
                                this.state = 1;
                                this.lastComment = new StringBuffer();
                                this.lastComment.append((char)next);
                                return next;
                            }
                            case -1: 
                            case 9: 
                            case 10: 
                            case 13: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                        }
                        this.state = 2;
                        this.keyLine = this.line + 1;
                        return next;
                    }
                    case 1: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                String comment = this.lastComment.toString();
                                this.lastComment = null;
                                if (this.localizable && comment.equals("#NOI18N")) {
                                    this.reverseLocalizable = true;
                                } else if (this.localizable && comment.equals("#PARTNOI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTNOI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#I18N")) {
                                    this.reverseLocalizable = true;
                                } else if (!this.localizable && comment.equals("#PARTI18N")) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): #PARTI18N encountered, will not annotate I18N parts");
                                    this.reverseLocalizable = false;
                                } else if (this.localizable && (comment.equals("#I18N") || comment.equals("#PARTI18N")) || !this.localizable && (comment.equals("#NOI18N") || comment.equals("#PARTNOI18N"))) {
                                    System.err.println("NbBundle WARNING (" + this.id + ":" + this.line + "): incongruous comment " + comment + " found for bundle");
                                    this.reverseLocalizable = false;
                                }
                                this.state = 0;
                                return next;
                            }
                        }
                        this.lastComment.append((char)next);
                        return next;
                    }
                    case 2: {
                        switch (next) {
                            case 92: {
                                this.state = 3;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                this.state = 4;
                                return next;
                            }
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        return next;
                    }
                    case 3: {
                        this.state = 2;
                        return next;
                    }
                    case 4: {
                        switch (next) {
                            case 58: 
                            case 61: {
                                this.state = 5;
                                return next;
                            }
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                        }
                        return next;
                    }
                    case 5: {
                        switch (next) {
                            case 10: 
                            case 13: {
                                this.state = 0;
                                return next;
                            }
                            case 9: 
                            case 32: {
                                return next;
                            }
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                        }
                        this.state = 6;
                        this.currentValue.setLength(0);
                        return next;
                    }
                    case 6: {
                        switch (next) {
                            case 92: {
                                this.state = 7;
                                return next;
                            }
                            case -1: 
                            case 10: 
                            case 13: {
                                boolean revLoc = this.reverseLocalizable;
                                this.reverseLocalizable = false;
                                this.state = 0;
                                if (this.localizable ^ revLoc) {
                                    assert (this.keyLine > 0);
                                    this.toInsert = "(" + this.id + ":" + this.keyLine + ")";
                                    if (next != -1) {
                                        this.toInsert = this.toInsert + Character.valueOf((char)next);
                                    }
                                    this.keyLine = 0;
                                    return 32;
                                }
                                return next;
                            }
                        }
                        this.currentValue.append((char)next);
                        return next;
                    }
                    case 7: {
                        this.state = 6;
                        return next;
                    }
                }
                throw new IOException("should never happen");
            }
        }
    }

    private static class LocaleIterator
    implements Iterator<String> {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String ret = this.branding == null ? this.current : this.branding + this.current;
            int lastUnderbar = this.current.lastIndexOf(95);
            if (lastUnderbar == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (lastUnderbar == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, lastUnderbar);
            }
            return ret;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int idx = this.branding.lastIndexOf(95);
                this.branding = idx == 0 ? null : this.branding.substring(0, idx);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static class MergedBundle
    extends ResourceBundle {
        private Locale loc;
        private ResourceBundle sub1;
        private ResourceBundle sub2;

        public MergedBundle(Locale loc, ResourceBundle sub1, ResourceBundle sub2) {
            this.loc = loc;
            this.sub1 = sub1;
            this.sub2 = sub2;
        }

        @Override
        public Locale getLocale() {
            return this.loc;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Enumerations.removeDuplicates(Enumerations.concat(this.sub1.getKeys(), this.sub2.getKeys()));
        }

        @Override
        protected Object handleGetObject(String key) throws MissingResourceException {
            try {
                return this.sub1.getObject(key);
            }
            catch (MissingResourceException mre) {
                return this.sub2.getObject(key);
            }
        }
    }

    private static final class PBundle
    extends ResourceBundle {
        private final Map<String, String> m;
        private final Locale locale;

        public PBundle(Map<String, String> m, Locale locale) {
            this.m = m;
            this.locale = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.m.keySet());
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.m.get(key);
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class AttributesMap
    extends HashMap<String, String> {
        private Attributes attrs;

        public AttributesMap(Attributes attrs) {
            super(7);
            this.attrs = attrs;
        }

        @Override
        public String get(Object _k) {
            Attributes.Name an;
            if (!(_k instanceof String)) {
                return null;
            }
            String k = (String)_k;
            try {
                an = new Attributes.Name(k);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.FINE, null, iae);
                return null;
            }
            return this.attrs.getValue(an);
        }
    }

    @Deprecated
    public static interface ClassLoaderFinder {
        @Deprecated
        public ClassLoader find();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.PACKAGE, ElementType.TYPE, ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.FIELD})
    public static @interface Messages {
        public String[] value();
    }
}

