/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant.utils;

import java.io.File;
import java.io.IOException;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class FileEntry {
    private long size;
    private String md5;
    private boolean directory;
    private boolean empty;
    private boolean jarFile;
    private boolean packedJarFile;
    private boolean signedJarFile;
    private long lastModified;
    private int permissions;
    private String name;

    public FileEntry(File file, String name) throws IOException {
        this.directory = file.isDirectory();
        if (!this.directory) {
            this.size = file.length();
            this.md5 = Utils.getMd5(file);
            this.jarFile = Utils.isJarFile(file);
            if (this.jarFile) {
                this.packedJarFile = false;
                this.signedJarFile = Utils.isSigned(file);
            }
        } else {
            this.empty = Utils.isEmpty(file);
        }
        this.permissions = Utils.getPermissions(file);
        this.lastModified = file.lastModified();
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public boolean isJarFile() {
        return this.jarFile;
    }

    public void setJarFile(boolean jarFile) {
        this.jarFile = jarFile;
    }

    public boolean isPackedJarFile() {
        return this.packedJarFile;
    }

    public void setPackedJarFile(boolean packedJarFile) {
        this.packedJarFile = packedJarFile;
    }

    public boolean isSignedJarFile() {
        return this.signedJarFile;
    }

    public void setSignedJarFile(boolean signedJarFile) {
        this.signedJarFile = signedJarFile;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

