/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.system.UnixNativeUtils;

public class SolarisNativeUtils
extends UnixNativeUtils {
    public static final String LIBRARY_PATH_SOLARIS_SPARC = "native/jnilib/solaris-sparc/solaris-sparc.so";
    public static final String LIBRARY_PATH_SOLARIS_SPARCV9 = "native/jnilib/solaris-sparc/solaris-sparcv9.so";
    public static final String LIBRARY_PATH_SOLARIS_X86 = "native/jnilib/solaris-x86/solaris-x86.so";
    public static final String LIBRARY_PATH_SOLARIS_X64 = "native/jnilib/solaris-x86/solaris-amd64.so";
    public static final String[] POSSIBLE_BROWSER_LOCATIONS_SOLARIS = new String[]{"/usr/sfw/lib/firefox/firefox", "/opt/csw/bin/firefox", "/usr/sfw/lib/mozilla/mozilla", "/opt/csw/bin/mozilla", "/usr/dt/bin/sun_netscape", "/usr/bin/firefox", "/usr/bin/mozilla-firefox", "/usr/local/firefox/firefox", "/opt/bin/firefox", "/usr/bin/mozilla", "/usr/local/mozilla/mozilla", "/opt/bin/mozilla"};
    private static final String[] FORBIDDEN_DELETING_FILES_SOLARIS = new String[0];

    SolarisNativeUtils() {
        String library = null;
        library = System.getProperty("os.arch").contains("sparc") ? (SystemUtils.isCurrentJava64Bit() ? LIBRARY_PATH_SOLARIS_SPARCV9 : LIBRARY_PATH_SOLARIS_SPARC) : (SystemUtils.isCurrentJava64Bit() ? LIBRARY_PATH_SOLARIS_X64 : LIBRARY_PATH_SOLARIS_X86);
        this.loadLibrary(library);
        this.initializeForbiddenFiles(FORBIDDEN_DELETING_FILES_SOLARIS);
    }

    @Override
    protected Platform getPlatform() {
        String osArch = System.getProperty("os.arch");
        return osArch.contains("sparc") ? Platform.SOLARIS_SPARC : Platform.SOLARIS_X86;
    }

    @Override
    protected String[] getPossibleBrowserLocations() {
        return POSSIBLE_BROWSER_LOCATIONS_SOLARIS;
    }
}

