/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import org.openide.awt.ContextAction;
import org.openide.awt.ContextSelection;
import org.openide.util.Lookup;

final class StatefulAction<T>
extends ContextAction<T> {
    private final ContextAction.StatefulMonitor checkValueMonitor;
    private boolean selValue;
    private boolean first = true;

    public StatefulAction(ContextAction.Performer performer, ContextSelection selectMode, Lookup actionContext, Class type, boolean surviveFocusChange, ContextAction.StatefulMonitor enableMonitor, ContextAction.StatefulMonitor valueMonitor) {
        super(performer, selectMode, actionContext, type, surviveFocusChange, enableMonitor);
        this.checkValueMonitor = valueMonitor;
    }

    @Override
    void updateStateProperties() {
        super.updateStateProperties();
        if (!this.wasEnabled()) {
            LOG.log(Level.FINE, "Action {0} disabled, unchecked", this);
            this.putValue("SwingSelectedKey", false);
            return;
        }
        boolean nowState = this.fetchStateValue();
        boolean oldState = this.selValue;
        this.selValue = nowState;
        LOG.log(Level.FINE, "Action {0}: old check state {1}, new check state {2}", new Object[]{this, oldState, nowState});
        this.firePropertyChange("SwingSelectedKey", oldState, nowState);
    }

    private boolean fetchStateValue() {
        this.first = false;
        if (this.checkValueMonitor.getType() == Action.class) {
            return this.global.runEnabled(this.type, this.selectMode, (all, everything) -> this.checkValueMonitor.enabled(Collections.singletonList(this.performer.delegate((Lookup.Provider)everything, (List<?>)all)), () -> (Action)this.performer.delegate((Lookup.Provider)everything, (List<?>)all)));
        }
        return this.global.runEnabled(this.checkValueMonitor.getType(), this.selectMode, (all, everything) -> this.checkValueMonitor.enabled(all, () -> (Action)this.performer.delegate((Lookup.Provider)everything, (List<?>)all)));
    }

    @Override
    public Object getValue(String key) {
        if ("SwingSelectedKey".equals(key)) {
            LOG.log(Level.FINER, "Action {0} state: {1}", new Object[]{this, this.selValue});
            return this.selValue;
        }
        return super.getValue(key);
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        ContextAction.StatefulMonitor checkMon = this.checkValueMonitor.createContextMonitor(actionContext);
        ContextAction.StatefulMonitor enableMon = this.enableMonitor == null ? null : this.enableMonitor.createContextMonitor(actionContext);
        StatefulAction<T> a = new StatefulAction<T>(this.performer, this.selectMode, actionContext, this.type, this.global.isSurvive(), enableMon, checkMon);
        LOG.log(Level.FINE, "Created context Stateful instance: {0} from {1}, check monitor {2}, enable monitor {3}", new Object[]{a, this, checkMon, enableMon});
        return a;
    }

    @Override
    void clearState() {
        super.clearState();
        this.checkValueMonitor.clear();
    }

    @Override
    protected void stopListeners() {
        Class<?> c = this.checkValueMonitor.getType();
        if (c != Action.class) {
            this.global.unregisterListener(this.checkValueMonitor.getType(), this);
        }
        this.checkValueMonitor.removeChangeListener(this);
        super.stopListeners();
    }

    @Override
    protected void startListeners() {
        super.startListeners();
        Class<?> c = this.checkValueMonitor.getType();
        if (c != Action.class) {
            this.global.registerListener(this.checkValueMonitor.getType(), this);
        }
        if (this.first) {
            this.selValue = this.fetchStateValue();
        }
        this.checkValueMonitor.addChangeListener(this);
    }
}

