/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.netbeans.modules.project.spi.intern.ProjectIDEServicesImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class GlobFileBuiltQuery
implements FileBuiltQueryImplementation {
    private static final Logger LOG = Logger.getLogger("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery");
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final String[] fromPrefixes;
    private final String[] fromSuffixes;
    private final String[] toPrefixes;
    private final String[] toSuffixes;
    private static final Reference<StatusImpl> NONE = new WeakReference<Object>(null);
    private final Map<FileObject, Reference<StatusImpl>> statuses = new WeakHashMap<FileObject, Reference<StatusImpl>>();
    private static final RequestProcessor RP = new RequestProcessor(StatusImpl.class.getName());

    public GlobFileBuiltQuery(AntProjectHelper helper, PropertyEvaluator eval, String[] from, String[] to) throws IllegalArgumentException {
        this.helper = helper;
        this.eval = eval;
        int l = from.length;
        if (to.length != l) {
            throw new IllegalArgumentException("Non-matching lengths");
        }
        this.fromPrefixes = new String[l];
        this.fromSuffixes = new String[l];
        this.toPrefixes = new String[l];
        this.toSuffixes = new String[l];
        for (int i = 0; i < l; ++i) {
            int idx = from[i].indexOf(42);
            if (idx == -1 || idx != from[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + from[i]);
            }
            this.fromPrefixes[i] = from[i].substring(0, idx);
            this.fromSuffixes[i] = from[i].substring(idx + 1);
            idx = to[i].indexOf(42);
            if (idx == -1 || idx != to[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + to[i]);
            }
            this.toPrefixes[i] = to[i].substring(0, idx);
            this.toSuffixes[i] = to[i].substring(idx + 1);
        }
    }

    @Override
    public synchronized FileBuiltQuery.Status getStatus(FileObject file) {
        StatusImpl status;
        Reference<StatusImpl> r = this.statuses.get(file);
        if (r == NONE) {
            return null;
        }
        StatusImpl statusImpl = status = r != null ? r.get() : null;
        if (status == null) {
            status = this.createStatus(file);
            if (status != null) {
                this.statuses.put(file, new WeakReference<StatusImpl>(status));
            } else {
                this.statuses.put(file, NONE);
            }
        }
        return status;
    }

    private File findTarget(FileObject file) {
        File sourceF = FileUtil.toFile(file);
        if (sourceF == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Not a disk file: {0}", file);
            }
            return null;
        }
        String source = sourceF.getAbsolutePath();
        for (int i = 0; i < this.fromPrefixes.length; ++i) {
            String remainder;
            String prefixEval = this.eval.evaluate(this.fromPrefixes[i]);
            if (prefixEval == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "{0} evaluates to null", this.fromPrefixes[i]);
                continue;
            }
            String suffixEval = this.eval.evaluate(this.fromSuffixes[i]);
            if (suffixEval == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "{0} evaluates to null", this.fromSuffixes[i]);
                continue;
            }
            boolean endsWithSlash = prefixEval.endsWith("/");
            Object prefixF = this.helper.resolveFile(prefixEval).getAbsolutePath();
            if (endsWithSlash && !((String)prefixF).endsWith(File.separator)) {
                prefixF = (String)prefixF + File.separatorChar;
            }
            if (!source.startsWith((String)prefixF) || !(remainder = source.substring(((String)prefixF).length())).endsWith(suffixEval.replace('/', File.separatorChar))) continue;
            String particular = remainder.substring(0, remainder.length() - suffixEval.length());
            String toPrefixEval = this.eval.evaluate(this.toPrefixes[i]);
            if (toPrefixEval == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "{0} evaluates to null", this.toPrefixes[i]);
                continue;
            }
            String toSuffixEval = this.eval.evaluate(this.toSuffixes[i]);
            if (toSuffixEval == null) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "{0} evaluates to null", this.toSuffixes[i]);
                continue;
            }
            File target = this.helper.resolveFile(toPrefixEval + particular + toSuffixEval);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Found target for {0}: {1}", new Object[]{source, target});
            }
            return target;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "No match for path {0} among {1} {2}", new Object[]{source, Arrays.asList(this.fromPrefixes), Arrays.asList(this.fromSuffixes)});
        }
        return null;
    }

    private StatusImpl createStatus(FileObject file) {
        File target = this.findTarget(file);
        if (target != null) {
            ProjectIDEServicesImplementation.FileBuiltQuerySource source = ProjectIDEServices.createFileBuiltQuerySource(file);
            return source != null ? new StatusImpl(source, file, target) : null;
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    Runnable {
        private final ChangeSupport cs = new ChangeSupport(this);
        private Boolean built = null;
        private final ProjectIDEServicesImplementation.FileBuiltQuerySource source;
        private File target;
        private final FileChangeListener targetListener;

        StatusImpl(ProjectIDEServicesImplementation.FileBuiltQuerySource source, FileObject sourceFO, File target) {
            this.source = source;
            this.source.addPropertyChangeListener(WeakListeners.propertyChange(this, this.source));
            sourceFO.addFileChangeListener(FileUtil.weakFileChangeListener(this, sourceFO));
            this.target = target;
            this.targetListener = new FileChangeListener(){

                @Override
                public void fileFolderCreated(FileEvent fe) {
                }

                @Override
                public void fileDataCreated(FileEvent fe) {
                    StatusImpl.this.update();
                }

                @Override
                public void fileChanged(FileEvent fe) {
                    StatusImpl.this.update();
                }

                @Override
                public void fileDeleted(FileEvent fe) {
                    StatusImpl.this.recalcTarget();
                    StatusImpl.this.update();
                }

                @Override
                public void fileRenamed(FileRenameEvent fe) {
                    StatusImpl.this.update();
                }

                @Override
                public void fileAttributeChanged(FileAttributeEvent fe) {
                    StatusImpl.this.update();
                }
            };
            FileUtil.addFileChangeListener(this.targetListener, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isBuilt() {
            boolean b;
            boolean doFire = false;
            GlobFileBuiltQuery globFileBuiltQuery = GlobFileBuiltQuery.this;
            synchronized (globFileBuiltQuery) {
                b = this.isReallyBuilt();
                if (this.built != null && this.built != b) {
                    doFire = true;
                }
                this.built = b;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "isBuilt: {0} from {1}", new Object[]{b, this});
                }
            }
            if (doFire) {
                this.cs.fireChange();
            }
            return b;
        }

        private boolean isReallyBuilt() {
            long sourceTime;
            if (!this.source.isValid()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "invalid: {0}", this);
                }
                return false;
            }
            if (this.source.isModified()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "modified: {0}", this);
                }
                return false;
            }
            if (this.target == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "no target matching {0}", this);
                }
                return false;
            }
            long targetTime = this.target.lastModified();
            if (targetTime >= (sourceTime = this.source.getFileObject().lastModified().getTime())) {
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "out of date (target: {0} vs. source: {1}): {2}", new Object[]{targetTime, sourceTime, this});
            }
            return false;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        private void update() {
            RP.post(this);
        }

        @Override
        public void run() {
            this.isBuilt();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() instanceof ProjectIDEServicesImplementation.FileBuiltQuerySource);
            if ("modified".equals(evt.getPropertyName())) {
                this.update();
            }
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.update();
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.update();
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.recalcTarget();
            this.update();
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recalcTarget() {
            File target2 = GlobFileBuiltQuery.this.findTarget(this.source.getFileObject());
            if (!BaseUtilities.compareObjects(this.target, target2)) {
                FileChangeListener fileChangeListener = this.targetListener;
                synchronized (fileChangeListener) {
                    if (this.target != null) {
                        FileUtil.removeFileChangeListener(this.targetListener, this.target);
                    }
                    if (target2 != null) {
                        FileUtil.addFileChangeListener(this.targetListener, target2);
                    }
                }
                this.target = target2;
            }
        }

        public String toString() {
            return "GFBQ.StatusImpl[" + this.source.getFileObject() + " -> " + this.target + "]";
        }
    }
}

