/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt30.tools.FileObject;
import jpt30.tools.JavaFileManager;
import jpt30.tools.JavaFileObject;
import jpt30.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.ModuleLocation;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

final class TreeLoaderOutputFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(TreeLoaderOutputFileManager.class.getName());
    static final String OUTPUT_ROOT = "output-root";
    private String outputRoot;
    private final CachingArchiveProvider provider;
    private final FileManagerTransaction tx;

    TreeLoaderOutputFileManager(@NonNull CachingArchiveProvider provider, @NonNull FileManagerTransaction tx) {
        assert (provider != null);
        assert (tx != null);
        this.provider = provider;
        this.tx = tx;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        Pair<JavaFileManager.Location, URL> p = TreeLoaderOutputFileManager.baseLocation(location);
        if (!this.hasLocation(p.first())) {
            throw new IllegalArgumentException(String.valueOf(p.first()));
        }
        File root = new File(this.outputRoot);
        assert (p.second() == null || p.second().equals(BaseUtilities.toURI(root).toURL())) : String.format("Expected: %s, Current %s", p.second(), root);
        String nameStr = FileObjects.convertPackage2Folder(className, File.separatorChar) + ".sig";
        File file = new File(root, nameStr);
        if (FileObjects.isValidFileName(className)) {
            return this.tx.createFileObject(location, file, root, null, null);
        }
        LOG.log(Level.WARNING, "Invalid class name: {0} sibling: {1}", new Object[]{className, sibling});
        return FileObjects.nullWriteFileObject(FileObjects.fileFileObject(file, root, null, null));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject fo;
        Pair<JavaFileManager.Location, URL> p = TreeLoaderOutputFileManager.baseLocation(location);
        if (!this.hasLocation(p.first())) {
            throw new IllegalArgumentException(String.valueOf(p.first()));
        }
        String[] names = FileObjects.getParentRelativePathAndName(className);
        if (kind == JavaFileObject.Kind.CLASS && (fo = this.tx.readFileObject(location, names[0], names[1])) != null) {
            return fo;
        }
        names[1] = names[1] + kind.extension;
        try {
            File root = new File(this.outputRoot);
            assert (p.second() == null || p.second().equals(BaseUtilities.toURI(root).toURL())) : String.format("Expected: %s, Current %s", p.second(), root);
            Archive archive = this.provider.getArchive(BaseUtilities.toURI(root).toURL(), false);
            if (archive != null) {
                Iterable<JavaFileObject> files = archive.getFiles(names[0], null, null, null, false);
                for (JavaFileObject e : files) {
                    if (!names[1].equals(e.getName())) continue;
                    return e;
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace(e);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        Pair<JavaFileManager.Location, URL> p = TreeLoaderOutputFileManager.baseLocation(location);
        if (!this.hasLocation(p.first())) {
            throw new IllegalArgumentException(String.valueOf(p.first()));
        }
        File root = new File(this.outputRoot);
        assert (p.second() == null || p.second().equals(BaseUtilities.toURI(root).toURL())) : String.format("Expected: %s, Current %s", p.second(), root);
        File file = FileUtil.normalizeFile(new File(root, FileObjects.resolveRelativePath(packageName, relativeName).replace('/', File.separatorChar)));
        return this.tx.createFileObject(location, file, root, null, null);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        Pair<JavaFileManager.Location, URL> p = TreeLoaderOutputFileManager.baseLocation(location);
        if (!this.hasLocation(p.first())) {
            throw new IllegalArgumentException(String.valueOf(p.first()));
        }
        File root = new File(this.outputRoot);
        assert (p.second() == null || p.second().equals(BaseUtilities.toURI(root).toURL())) : String.format("Expected: %s, Current %s", p.second(), root);
        String path = FileObjects.resolveRelativePath(packageName, relativeName);
        String[] names = FileObjects.getFolderAndBaseName(path, '/');
        JavaFileObject jfo = this.tx.readFileObject(location, names[0], names[1]);
        if (jfo != null) {
            return jfo;
        }
        Archive archive = this.provider.getArchive(BaseUtilities.toURI(root).toURL(), false);
        return archive != null ? archive.getFile(path) : null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)file).inferBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        return OUTPUT_ROOT.equals(option) ? 1 : -1;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        if (OUTPUT_ROOT.equals(current)) {
            if (remaining.hasNext()) {
                this.outputRoot = remaining.next();
                if (this.outputRoot.isEmpty()) {
                    this.outputRoot = null;
                }
            } else {
                throw new IllegalStateException("No OUTPUT_ROOT value.");
            }
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_OUTPUT && this.outputRoot != null;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        if (!this.hasLocation(location)) {
            throw new IllegalArgumentException(String.valueOf(location));
        }
        URL cacheRoot = BaseUtilities.toURI(new File(this.outputRoot)).toURL();
        URL origRoot = JavaIndex.getSourceRootForClassFolder(cacheRoot);
        if (origRoot == null) {
            return null;
        }
        String expectedModuleName = SourceUtils.getModuleName(origRoot);
        return moduleName.equals(expectedModuleName) ? ModuleLocation.create(StandardLocation.CLASS_OUTPUT, Collections.singleton(cacheRoot), moduleName) : null;
    }

    @NonNull
    private static Pair<JavaFileManager.Location, URL> baseLocation(@NonNull JavaFileManager.Location loc) {
        if (ModuleLocation.isInstance(loc)) {
            ModuleLocation ml = ModuleLocation.cast(loc);
            return Pair.of(ml.getBaseLocation(), ml.getModuleRoots().iterator().next());
        }
        return Pair.of(loc, null);
    }
}

