/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ScanUtils;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class MainClassUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor("main-class-updater", 1);
    private static final Logger LOG = Logger.getLogger(MainClassUpdater.class.getName());
    private static final int NEW = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private final Project project;
    private final PropertyEvaluator eval;
    private final UpdateHelper helper;
    private final ClassPath sourcePath;
    private final String mainClassPropName;
    private final AtomicInteger state;
    private FileObject currentFo;
    private DataObject currentDo;
    private FileChangeListener foListener;
    private PropertyChangeListener doListener;
    private long lc = 0L;

    public MainClassUpdater(Project project, PropertyEvaluator eval, UpdateHelper helper, ClassPath sourcePath, String mainClassPropName) {
        assert (project != null);
        assert (eval != null);
        assert (helper != null);
        assert (sourcePath != null);
        assert (mainClassPropName != null);
        this.project = project;
        this.eval = eval;
        this.helper = helper;
        this.sourcePath = sourcePath;
        this.mainClassPropName = mainClassPropName;
        this.state = new AtomicInteger(0);
    }

    public void start() {
        RP.submit(new Runnable(){

            @Override
            public void run() {
                if (!MainClassUpdater.this.state.compareAndSet(0, 1)) {
                    throw new IllegalStateException("Current State: " + MainClassUpdater.this.state.get());
                }
                MainClassUpdater.this.eval.addPropertyChangeListener(MainClassUpdater.this);
                MainClassUpdater.this.addFileChangeListener();
            }
        });
    }

    public void stop() {
        RP.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MainClassUpdater.this.state.compareAndSet(1, 2)) {
                    MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                    synchronized (mainClassUpdater) {
                        if (MainClassUpdater.this.currentFo != null && MainClassUpdater.this.foListener != null) {
                            MainClassUpdater.this.currentFo.removeFileChangeListener(MainClassUpdater.this.foListener);
                        }
                        if (MainClassUpdater.this.currentDo != null && MainClassUpdater.this.doListener != null) {
                            MainClassUpdater.this.currentDo.removePropertyChangeListener(MainClassUpdater.this.doListener);
                        }
                    }
                } else {
                    throw new IllegalStateException("Current State: " + MainClassUpdater.this.state.get());
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("primaryFile".equals(evt.getPropertyName())) {
            FileObject newFile = (FileObject)evt.getNewValue();
            FileObject oldFile = (FileObject)evt.getOldValue();
            this.handleMainClassMoved(oldFile, newFile);
        } else if (this.mainClassPropName.equals(evt.getPropertyName())) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MainClassUpdater.this.addFileChangeListener();
                }
            });
        }
    }

    @Override
    public void fileRenamed(FileRenameEvent evt) {
        this.handleMainClassMoved(evt.getFile(), evt.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMainClassMoved(FileObject oldFile, final FileObject newFile) {
        FileObject _current;
        if (!this.project.getProjectDirectory().isValid()) {
            return;
        }
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            _current = this.currentFo;
        }
        if (oldFile == _current) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        String oldMainClass = ProjectManager.mutex().readAccess(new Mutex.ExceptionAction<String>(){

                            @Override
                            public String run() throws Exception {
                                return MainClassUpdater.this.eval.getProperty(MainClassUpdater.this.mainClassPropName);
                            }
                        });
                        Collection<ElementHandle<TypeElement>> main = SourceUtils.getMainClasses(newFile);
                        String newMainClass = null;
                        if (!main.isEmpty()) {
                            ElementHandle<TypeElement> mainHandle = main.iterator().next();
                            newMainClass = mainHandle.getQualifiedName();
                        }
                        if (newMainClass != null && !newMainClass.equals(oldMainClass) && MainClassUpdater.this.helper.requestUpdate() && MainClassUpdater.this.eval.getProperty("config") == null) {
                            final String newMainClassFinal = newMainClass;
                            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    EditableProperties props = MainClassUpdater.this.helper.getProperties("nbproject/project.properties");
                                    props.put(MainClassUpdater.this.mainClassPropName, newMainClassFinal);
                                    MainClassUpdater.this.helper.putProperties("nbproject/project.properties", props);
                                    ProjectManager.getDefault().saveProject(MainClassUpdater.this.project);
                                    return null;
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        Exceptions.printStackTrace(e);
                    }
                    catch (MutexException e) {
                        Exceptions.printStackTrace(e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileChangeListener() {
        FileObject[] roots;
        long clc;
        MainClassUpdater mainClassUpdater = this;
        synchronized (mainClassUpdater) {
            if (this.currentFo != null && this.foListener != null) {
                this.currentFo.removeFileChangeListener(this.foListener);
                this.foListener = null;
                this.currentFo = null;
            }
            if (this.currentDo != null && this.doListener != null) {
                this.currentDo.removePropertyChangeListener(this.doListener);
                this.doListener = null;
                this.currentDo = null;
            }
            clc = ++this.lc;
        }
        final String mainClassName = this.eval.getProperty(this.mainClassPropName);
        if (mainClassName != null && (roots = this.sourcePath.getRoots()).length > 0) {
            ClassPath compileCp;
            ClassPath bootCp = ClassPath.getClassPath(roots[0], "classpath/boot");
            if (bootCp == null) {
                LOG.log(Level.WARNING, "No bootpath for: {0}", FileUtil.getFileDisplayName(roots[0]));
                bootCp = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
            }
            if ((compileCp = ClassPath.getClassPath(roots[0], "classpath/compile")) == null) {
                LOG.log(Level.WARNING, "No classpath for: {0}", FileUtil.getFileDisplayName(roots[0]));
                compileCp = ClassPathSupport.createClassPath(new URL[0]);
            }
            ClassPath systemModules = ClassPath.getClassPath(roots[0], "modules/boot");
            ClassPath modulePath = ClassPath.getClassPath(roots[0], "modules/compile");
            ClassPath allUnnamed = ClassPath.getClassPath(roots[0], "modules/classpath");
            final ClasspathInfo cpInfo = new ClasspathInfo.Builder(bootCp).setClassPath(compileCp).setSourcePath(this.sourcePath).setModuleBootPath(systemModules).setModuleCompilePath(modulePath).setModuleClassPath(allUnnamed).build();
            JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
            ScanUtils.postUserActionTask(js, new Task<CompilationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(CompilationController c) throws Exception {
                    c.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement te = ScanUtils.checkElement(c, c.getElements().getTypeElement(mainClassName));
                    if (te != null) {
                        FileObject fo = SourceUtils.getFile(te, cpInfo);
                        MainClassUpdater mainClassUpdater = MainClassUpdater.this;
                        synchronized (mainClassUpdater) {
                            if (MainClassUpdater.this.lc == clc && fo != null && MainClassUpdater.this.sourcePath.contains(fo)) {
                                MainClassUpdater.this.currentFo = fo;
                                MainClassUpdater.this.foListener = WeakListeners.create(FileChangeListener.class, MainClassUpdater.this, MainClassUpdater.this.currentFo);
                                MainClassUpdater.this.currentFo.addFileChangeListener(MainClassUpdater.this.foListener);
                                MainClassUpdater.this.currentDo = DataObject.find(MainClassUpdater.this.currentFo);
                                MainClassUpdater.this.doListener = WeakListeners.propertyChange(MainClassUpdater.this, MainClassUpdater.this.currentDo);
                                MainClassUpdater.this.currentDo.addPropertyChangeListener(MainClassUpdater.this.doListener);
                            }
                        }
                    }
                }
            });
        }
    }
}

