/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LoggerGenerator
implements CodeGenerator {
    private final JTextComponent component;
    private final ElementNode.Description description;
    private final boolean isSystemLogger;

    private LoggerGenerator(JTextComponent component, ElementNode.Description description, boolean isSystemLogger) {
        this.component = component;
        this.description = description;
        this.isSystemLogger = isSystemLogger;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(LoggerGenerator.class, "LBL_logger");
    }

    @Override
    public void invoke() {
        final int caretOffset = this.component.getCaretPosition();
        JavaSource js = JavaSource.forDocument(this.component.getDocument());
        if (js != null) {
            try {
                ModificationResult mr = js.runModificationTask(new Task<WorkingCopy>(){

                    @Override
                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element e = LoggerGenerator.this.description.getElementHandle().resolve(copy);
                        TreePath path = e != null ? copy.getTrees().getPath(e) : copy.getTreeUtilities().pathFor(caretOffset);
                        path = copy.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
                        if (path == null) {
                            String message = NbBundle.getMessage(LoggerGenerator.class, "ERR_CannotFindOriginalClass");
                            Utilities.setStatusBoldText(LoggerGenerator.this.component, message);
                        } else {
                            ClassTree cls = (ClassTree)path.getLeaf();
                            CodeStyle cs = CodeStyle.getDefault(LoggerGenerator.this.component.getDocument());
                            EnumSet<Modifier> mods = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
                            List<String> names = org.netbeans.modules.java.completion.Utilities.varNamesSuggestions(null, ElementKind.FIELD, mods, LoggerGenerator.getBaseLoggerName(), null, copy.getTypes(), copy.getElements(), e.getEnclosedElements(), cs);
                            VariableTree var = LoggerGenerator.createLoggerField(copy.getTreeMaker(), cls, names.size() > 0 ? (CharSequence)names.get(0) : LoggerGenerator.getBaseLoggerName(), mods, LoggerGenerator.this.isSystemLogger);
                            copy.rewrite(cls, GeneratorUtils.insertClassMembers(copy, cls, Collections.singletonList(var), caretOffset));
                        }
                    }
                });
                GeneratorUtils.guardedCommit(this.component, mr);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    public static String getBaseLoggerName() {
        return "LOG";
    }

    public static boolean isUseSystemLogger(CompilationInfo info) {
        if (info != null && info.getSourceVersion().compareTo(SourceVersion.RELEASE_9) < 0) {
            return false;
        }
        FileObject fo = info != null ? info.getFileObject() : null;
        String keyHack = "surround-try-catch-java-lang-System-Logger";
        boolean v = true;
        try {
            Preferences root = null;
            Object nodeHack = "org.netbeans.modules.java.hints.errors.ErrorFixesFakeHintSURROUND_WITH_TRY_CATCH";
            if (fo == null) {
                nodeHack = "org/netbeans/modules/java/hints/default/" + (String)nodeHack;
                root = NbPreferences.root();
            } else {
                root = FileHintPreferences.getFilePreferences(fo, "text/x-java");
            }
            Preferences tryCatch = null;
            if (root.nodeExists((String)nodeHack)) {
                tryCatch = root.node((String)nodeHack);
            }
            if (tryCatch != null) {
                v = tryCatch.getBoolean(keyHack, v);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return v;
    }

    public static VariableTree createLoggerField(TreeMaker make, ClassTree cls, CharSequence name, Set<Modifier> mods) {
        return LoggerGenerator.createLoggerField(make, cls, name, mods, LoggerGenerator.isUseSystemLogger(null));
    }

    public static VariableTree createLoggerField(TreeMaker make, ClassTree cls, CharSequence name, Set<Modifier> mods, CompilationInfo info) {
        return LoggerGenerator.createLoggerField(make, cls, name, mods, LoggerGenerator.isUseSystemLogger(info));
    }

    private static VariableTree createLoggerField(TreeMaker make, ClassTree cls, CharSequence name, Set<Modifier> mods, boolean useSystemLogger) {
        ModifiersTree modifiers = make.Modifiers(mods, Collections.emptyList());
        List none = Collections.emptyList();
        IdentifierTree className = make.Identifier(cls.getSimpleName());
        MemberSelectTree classType = make.MemberSelect((ExpressionTree)className, "class");
        MemberSelectTree getName = make.MemberSelect((ExpressionTree)classType, "getName");
        MethodInvocationTree initClass = make.MethodInvocation(none, getName, none);
        ExpressionTree logger = make.QualIdent(useSystemLogger ? "java.lang.System.Logger" : Logger.class.getName());
        ExpressionTree loggerProvider = useSystemLogger ? make.QualIdent("java.lang.System") : logger;
        MemberSelectTree getLogger = make.MemberSelect(loggerProvider, "getLogger");
        MethodInvocationTree initField = make.MethodInvocation(none, getLogger, Collections.nCopies(1, initClass));
        return make.Variable(modifiers, name, logger, initField);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        private static final String ERROR = "<error>";

        @Override
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<LoggerGenerator> ret = new ArrayList<LoggerGenerator>();
            JTextComponent component = context.lookup(JTextComponent.class);
            CompilationController controller = context.lookup(CompilationController.class);
            if (component == null || controller == null) {
                return ret;
            }
            TreePath path = context.lookup(TreePath.class);
            path = controller.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, path);
            if (path == null) {
                return ret;
            }
            try {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ioe) {
                return ret;
            }
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement == null || !typeElement.getKind().isClass()) {
                return ret;
            }
            boolean isSystemLogger = LoggerGenerator.isUseSystemLogger(controller);
            String loggerFQN = isSystemLogger ? "java.lang.System.Logger" : Logger.class.getName();
            for (VariableElement ve : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                TypeMirror type = ve.asType();
                if (type.getKind() != TypeKind.DECLARED || !((TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals(loggerFQN)) continue;
                return ret;
            }
            ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
            ret.add(new LoggerGenerator(component, ElementNode.Description.create(controller, typeElement, descriptions, false, false), isSystemLogger));
            return ret;
        }
    }
}

