/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

abstract class ProjectInfoImpl
implements ProjectInformation,
AntProjectListener {
    public static final String DEFAULT_ELEMENT_NAME = "name";
    private static final String UNKNOWN = "???";
    private final Object guard = new Object();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Project project;
    private final String elementName;
    private final Icon icon;
    private String name;
    private String displayName;

    public ProjectInfoImpl(Project project, Icon icon, String elementName) {
        this.project = project;
        this.icon = icon;
        this.elementName = elementName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.guard;
        synchronized (object) {
            if (this.name == null) {
                this.name = PropertyUtils.getUsablePropertyName(this.getDisplayName());
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        Object object = this.guard;
        synchronized (object) {
            if (this.displayName == null) {
                this.displayName = this.getElementTextFromConfiguration(this.elementName);
            }
            return this.displayName;
        }
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    protected String getElementTextFromConfiguration(final String elementName) {
        return ProjectManager.mutex().readAccess(new Mutex.Action<String>(){

            @Override
            public String run() {
                String name;
                Element data = ProjectInfoImpl.this.getPrimaryConfigurationData();
                Element element = XMLUtil.findElement(data, elementName, null);
                String string = name = element == null ? null : XMLUtil.findText(element);
                if (name == null) {
                    name = ProjectInfoImpl.UNKNOWN;
                }
                return name;
            }
        });
    }

    protected abstract Element getPrimaryConfigurationData();

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(prop, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configurationXmlChanged(AntProjectEvent ev) {
        if ("nbproject/project.xml".equals(ev.getPath())) {
            String newDisplayName;
            String newName;
            String oldDisplayName;
            String oldName;
            Object object = this.guard;
            synchronized (object) {
                oldName = this.name;
                oldDisplayName = this.displayName;
                this.name = null;
                this.displayName = null;
                newName = this.getName();
                newDisplayName = this.getDisplayName();
            }
            this.firePropertyChange(DEFAULT_ELEMENT_NAME, oldName, newName);
            this.firePropertyChange("displayName", oldDisplayName, newDisplayName);
        }
    }

    @Override
    public void propertiesChanged(AntProjectEvent ev) {
    }
}

