/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.FeatureUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.InstallSupportImpl;
import org.netbeans.modules.autoupdate.services.ModuleEnableDisableDeleteHelper;
import org.netbeans.modules.autoupdate.services.ModuleUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.NativeComponentUpdateElementImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateElementImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitFactory;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.spi.autoupdate.CustomInstaller;
import org.netbeans.spi.autoupdate.CustomUninstaller;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInfo;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public abstract class OperationSupportImpl {
    private static final OperationSupportImpl FOR_INSTALL = new ForInstall();
    private static final OperationSupportImpl FOR_ENABLE = new ForEnable();
    private static final OperationSupportImpl FOR_DISABLE = new ForDisable();
    private static final OperationSupportImpl FOR_DIRECT_DISABLE = new ForDirectDisable();
    private static final OperationSupportImpl FOR_UNINSTALL = new ForUninstall();
    private static final OperationSupportImpl FOR_DIRECT_UNINSTALL = new ForDirectUninstall();
    private static final OperationSupportImpl FOR_CUSTOM_INSTALL = new ForCustomInstall();
    private static final OperationSupportImpl FOR_CUSTOM_UNINSTALL = new ForCustomUninstall();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.autoupdate.services.OperationSupportImpl");

    public static OperationSupportImpl forInstall() {
        return FOR_INSTALL;
    }

    public static OperationSupportImpl forUninstall() {
        return FOR_UNINSTALL;
    }

    public static OperationSupportImpl forDirectUninstall() {
        return FOR_DIRECT_UNINSTALL;
    }

    public static OperationSupportImpl forEnable() {
        return FOR_ENABLE;
    }

    public static OperationSupportImpl forDisable() {
        return FOR_DISABLE;
    }

    public static OperationSupportImpl forDirectDisable() {
        return FOR_DIRECT_DISABLE;
    }

    public static OperationSupportImpl forCustomInstall() {
        return FOR_CUSTOM_INSTALL;
    }

    public static OperationSupportImpl forCustomUninstall() {
        return FOR_CUSTOM_UNINSTALL;
    }

    public abstract Boolean doOperation(ProgressHandle var1, OperationContainer<?> var2) throws OperationException;

    public abstract void doCancel() throws OperationException;

    public abstract void doRestart(OperationSupport.Restarter var1, ProgressHandle var2) throws OperationException;

    public abstract void doRestartLater(OperationSupport.Restarter var1);

    private OperationSupportImpl() {
    }

    private static void markForRestart() {
        try {
            LifecycleManager.getDefault().markForRestart();
        }
        catch (UnsupportedOperationException x) {
            LOGGER.log(Level.INFO, null, x);
        }
    }

    private static class ForInstall
    extends OperationSupportImpl {
        private ForInstall() {
        }

        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer container) throws OperationException {
            OperationContainer<InstallSupport> containerForUpdate = OperationContainer.createForUpdate();
            List infos = container.listAll();
            for (OperationContainer.OperationInfo info : infos) {
                containerForUpdate.add(info.getUpdateUnit(), info.getUpdateElement());
            }
            assert (containerForUpdate.listInvalid().isEmpty());
            InstallSupport.Validator v = containerForUpdate.getSupport().doDownload(ProgressHandle.createHandle(OperationSupportImpl.class.getName()), null, false);
            InstallSupport.Installer i = containerForUpdate.getSupport().doValidate(v, ProgressHandle.createHandle(OperationSupportImpl.class.getName()));
            InstallSupportImpl installSupportImpl = Trampoline.API.impl(containerForUpdate.getSupport());
            Boolean needRestart = installSupportImpl.doInstall(i, ProgressHandle.createHandle(OperationSupportImpl.class.getName()), true);
            return needRestart;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForEnable
    extends OperationSupportImpl {
        private Collection<File> controlFileForEnable = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForEnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            boolean needsRestart;
            block14: {
                needsRestart = false;
                try {
                    if (progress != null) {
                        progress.start();
                    }
                    ModuleManager mm = null;
                    List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                    HashSet<ModuleInfo> moduleInfos = new HashSet<ModuleInfo>();
                    for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                        UpdateElementImpl impl = Trampoline.API.impl(operationInfo.getUpdateElement());
                        moduleInfos.addAll(impl.getModuleInfos(true));
                    }
                    final HashSet<Module> modules = new HashSet<Module>();
                    for (ModuleInfo info : moduleInfos) {
                        Module m = Utilities.toModule(info);
                        if (Utilities.canEnable(m)) {
                            modules.add(m);
                            LOGGER.log(Level.FINE, "Module will be enabled " + m.getCodeNameBase());
                        }
                        if (mm != null) continue;
                        mm = m.getManager();
                    }
                    assert (mm != null);
                    needsRestart = mm.hasToEnableCompatModules(modules);
                    if (!needsRestart) {
                        final ModuleManager moduleManager = mm;
                        try {
                            moduleManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws Exception {
                                    return ForEnable.enable(moduleManager, modules);
                                }
                            });
                            break block14;
                        }
                        catch (MutexException ex) {
                            Exception x = ex.getException();
                            assert (x instanceof OperationException) : x + " is instanceof OperationException";
                            if (x instanceof OperationException) {
                                throw (OperationException)x;
                            }
                            break block14;
                        }
                    }
                    ModuleEnableDisableDeleteHelper moduleEnableDisableDeleteHelper = new ModuleEnableDisableDeleteHelper();
                    this.controlFileForEnable = moduleEnableDisableDeleteHelper.findControlFiles(moduleInfos, progress);
                }
                finally {
                    if (progress != null) {
                        progress.finish();
                    }
                }
            }
            return needsRestart;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.controlFileForEnable != null) {
                this.controlFileForEnable = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        private static boolean enable(ModuleManager mm, Set<Module> toRun) throws OperationException {
            boolean retval = false;
            try {
                mm.enable(toRun);
                retval = true;
            }
            catch (IllegalArgumentException ilae) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, ilae);
            }
            catch (InvalidException ie) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, ie);
            }
            return retval;
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            if (this.controlFileForEnable != null) {
                Utilities.writeFileMarkedForEnable(this.controlFileForEnable);
                Utilities.deleteAllDoLater();
                LifecycleManager.getDefault().exit();
                this.doRestartLater(restarter);
            } else {
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            if (this.controlFileForEnable != null) {
                Utilities.writeFileMarkedForEnable(this.controlFileForEnable);
                for (UpdateElement el : this.affectedModules) {
                    UpdateUnitFactory.getDefault().scheduleForRestart(el);
                }
            } else {
                LifecycleManager.getDefault().markForRestart();
            }
        }
    }

    private static class ForDisable
    extends OperationSupportImpl {
        private Collection<File> controlFileForDisable = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                if (progress != null) {
                    progress.start();
                }
                ModuleManager mm = null;
                List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                this.affectedModules = new HashSet<UpdateElement>();
                HashSet<ModuleInfo> moduleInfos = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    UpdateElementImpl impl = Trampoline.API.impl(operationInfo.getUpdateElement());
                    this.affectedModules.add(operationInfo.getUpdateElement());
                    moduleInfos.addAll(impl.getModuleInfos());
                }
                HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
                for (ModuleInfo info : moduleInfos) {
                    Module m = Utilities.toModule(info);
                    if (Utilities.canDisable(m)) {
                        modules.add(m);
                        LOGGER.log(Level.FINE, "Mark module " + m.getCodeNameBase() + " for disable.");
                    }
                    if (mm != null) continue;
                    mm = m.getManager();
                }
                assert (mm != null);
                ModuleEnableDisableDeleteHelper moduleEnableDisableDeleteHelper = new ModuleEnableDisableDeleteHelper();
                this.controlFileForDisable = moduleEnableDisableDeleteHelper.findControlFiles(modules, progress);
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.controlFileForDisable != null) {
                this.controlFileForDisable = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDisable(this.controlFileForDisable);
            for (UpdateElement el : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(el);
            }
            Utilities.writeDeactivateLater(this.controlFileForDisable);
        }
    }

    private static class ForDirectDisable
    extends OperationSupportImpl {
        private ForDirectDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                if (progress != null) {
                    progress.start();
                }
                ModuleManager mm = null;
                List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                HashSet<ModuleInfo> moduleInfos = new HashSet<ModuleInfo>();
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    UpdateElementImpl impl = Trampoline.API.impl(operationInfo.getUpdateElement());
                    moduleInfos.addAll(impl.getModuleInfos());
                }
                final HashSet<Module> modules = new HashSet<Module>();
                for (ModuleInfo info : moduleInfos) {
                    Module m = Utilities.toModule(info);
                    if (Utilities.canDisable(m)) {
                        modules.add(m);
                        LOGGER.log(Level.FINE, "Module will be disabled " + m.getCodeNameBase());
                    }
                    if (mm != null) continue;
                    mm = m.getManager();
                }
                assert (mm != null);
                final ModuleManager moduleManager = mm;
                try {
                    moduleManager.mutex().writeAccess(new Mutex.ExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return ForDirectDisable.disable(moduleManager, modules);
                        }
                    });
                }
                catch (MutexException ex) {
                    Exception x = ex.getException();
                    assert (x instanceof OperationException) : x + " is instanceof OperationException";
                    if (x instanceof OperationException) {
                        throw (OperationException)x;
                    }
                }
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
            return false;
        }

        private static boolean disable(ModuleManager mm, Set<Module> toRun) throws OperationException {
            boolean retval = false;
            try {
                mm.disable(toRun);
                retval = true;
            }
            catch (IllegalArgumentException ilae) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, ilae);
            }
            return retval;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForUninstall
    extends OperationSupportImpl {
        private Collection<File> files4remove = null;
        private Collection<UpdateElement> affectedModules = null;

        private ForUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                if (progress != null) {
                    progress.start();
                }
                ModuleEnableDisableDeleteHelper deleter = new ModuleEnableDisableDeleteHelper();
                List<OperationContainer.OperationInfo<?>> infos = container.listAll();
                HashSet<ModuleInfo> moduleInfos = new HashSet<ModuleInfo>();
                this.affectedModules = new HashSet<UpdateElement>();
                block10: for (OperationContainer.OperationInfo<?> operationInfo : infos) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            moduleInfos.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            this.affectedModules.add(updateElementImpl.getUpdateElement());
                            break;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                moduleInfos.add(moduleImpl.getModuleInfo());
                                if (moduleImpl.getUpdateUnit().getInstalled() == null) continue;
                                this.affectedModules.add(moduleImpl.getUpdateElement());
                            }
                            continue block10;
                        }
                        case CUSTOM_HANDLED_COMPONENT: {
                            break;
                        }
                        default: {
                            assert (false) : "Not supported for impl " + updateElementImpl;
                            continue block10;
                        }
                    }
                }
                try {
                    this.files4remove = deleter.markForDelete(moduleInfos, progress);
                }
                catch (IOException iex) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iex);
                }
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
            return true;
        }

        @Override
        public void doCancel() throws OperationException {
            if (this.files4remove != null) {
                this.files4remove = null;
            }
            if (this.affectedModules != null) {
                this.affectedModules = null;
            }
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            Utilities.deleteAllDoLater();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            Utilities.writeFileMarkedForDelete(this.files4remove);
            for (UpdateElement el : this.affectedModules) {
                UpdateUnitFactory.getDefault().scheduleForRestart(el);
            }
            Utilities.writeDeactivateLater(this.files4remove);
        }
    }

    private static class ForDirectUninstall
    extends OperationSupportImpl {
        private ForDirectUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                UpdateUnitImpl impl;
                if (progress != null) {
                    progress.start();
                }
                ModuleEnableDisableDeleteHelper deleter = new ModuleEnableDisableDeleteHelper();
                List<OperationContainer.OperationInfo<?>> infos = container.listAll();
                HashSet<ModuleInfo> moduleInfos = new HashSet<ModuleInfo>();
                HashSet<UpdateUnit> affectedModules = new HashSet<UpdateUnit>();
                HashSet<UpdateUnit> affectedFeatures = new HashSet<UpdateUnit>();
                block9: for (OperationContainer.OperationInfo<?> operationInfo : infos) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(updateElement);
                    switch (updateElementImpl.getType()) {
                        case KIT_MODULE: 
                        case MODULE: {
                            moduleInfos.add(((ModuleUpdateElementImpl)updateElementImpl).getModuleInfo());
                            affectedModules.add(updateElementImpl.getUpdateUnit());
                            continue block9;
                        }
                        case STANDALONE_MODULE: 
                        case FEATURE: {
                            for (ModuleUpdateElementImpl moduleImpl : ((FeatureUpdateElementImpl)updateElementImpl).getContainedModuleElements()) {
                                moduleInfos.add(moduleImpl.getModuleInfo());
                                if (moduleImpl.getUpdateUnit().getInstalled() == null) continue;
                                affectedModules.add(moduleImpl.getUpdateUnit());
                            }
                            affectedFeatures.add(updateElement.getUpdateUnit());
                            continue block9;
                        }
                    }
                    assert (false) : "Not supported for impl " + updateElementImpl;
                }
                try {
                    deleter.delete(moduleInfos.toArray(new ModuleInfo[0]), progress);
                }
                catch (IOException iex) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, iex);
                }
                for (UpdateUnit unit : affectedModules) {
                    assert (unit.getInstalled() != null) : "Module " + unit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Module was uninstalled " + unit.getCodeName());
                    impl = Trampoline.API.impl(unit);
                    impl.setAsUninstalled();
                }
                for (UpdateUnit unit : affectedFeatures) {
                    assert (unit.getInstalled() != null) : "Feature " + unit + " is installed while doing uninstall.";
                    LOGGER.log(Level.FINE, "Feature was uninstalled " + unit.getCodeName());
                    impl = Trampoline.API.impl(unit);
                    impl.setAsUninstalled();
                }
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
            return false;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private static class ForCustomInstall
    extends OperationSupportImpl {
        private Collection<UpdateElement> affectedModules = null;

        private ForCustomInstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            boolean success = false;
            boolean started = false;
            try {
                List<OperationContainer.OperationInfo<?>> infos = container.listAll();
                ArrayList<NativeComponentUpdateElementImpl> customElements = new ArrayList<NativeComponentUpdateElementImpl>();
                for (OperationContainer.OperationInfo<?> operationInfo : infos) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                    assert (updateElementImpl instanceof NativeComponentUpdateElementImpl) : "Impl of " + operationInfo.getUpdateElement() + " instanceof NativeComponentUpdateElementImpl.";
                    customElements.add((NativeComponentUpdateElementImpl)updateElementImpl);
                }
                assert (customElements != null) : "Some elements with custom installer found.";
                if (progress != null) {
                    progress.start(customElements.size());
                }
                started = true;
                int index = 0;
                this.affectedModules = new HashSet<UpdateElement>();
                for (NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl : customElements) {
                    if (progress != null) {
                        progress.progress(NbBundle.getMessage(OperationSupportImpl.class, "OperationSupportImpl_Custom_Install", nativeComponentUpdateElementImpl.getDisplayName()), ++index);
                    }
                    CustomInstaller installer = nativeComponentUpdateElementImpl.getInstallInfo().getCustomInstaller();
                    assert (installer != null) : "CustomInstaller must found for " + nativeComponentUpdateElementImpl.getUpdateElement();
                    ProgressHandle handle = ProgressHandle.createHandle("Installing " + nativeComponentUpdateElementImpl.getDisplayName());
                    success = installer.install(nativeComponentUpdateElementImpl.getCodeName(), nativeComponentUpdateElementImpl.getSpecificationVersion() == null ? null : nativeComponentUpdateElementImpl.getSpecificationVersion().toString(), handle);
                    try {
                        handle.finish();
                    }
                    catch (IllegalStateException e) {
                        LOGGER.log(Level.FINE, "Can`t stop progress handle, likely was not started ", e);
                    }
                    if (success) {
                        UpdateUnitImpl unitImpl = Trampoline.API.impl(nativeComponentUpdateElementImpl.getUpdateUnit());
                        unitImpl.setInstalled(nativeComponentUpdateElementImpl.getUpdateElement());
                        this.affectedModules.add(nativeComponentUpdateElementImpl.getUpdateElement());
                        continue;
                    }
                    throw new OperationException(OperationException.ERROR_TYPE.INSTALL, nativeComponentUpdateElementImpl.getDisplayName());
                }
            }
            finally {
                if (progress != null && started) {
                    progress.finish();
                }
            }
            return success;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            OperationSupportImpl.markForRestart();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            OperationSupportImpl.markForRestart();
            if (this.affectedModules != null) {
                for (UpdateElement el : this.affectedModules) {
                    UpdateUnitFactory.getDefault().scheduleForRestart(el);
                }
            }
        }
    }

    private static class ForCustomUninstall
    extends OperationSupportImpl {
        private Collection<UpdateElement> affectedModules = null;

        private ForCustomUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Boolean doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            boolean success = false;
            boolean started = false;
            try {
                List<OperationContainer.OperationInfo<?>> infos = container.listAll();
                ArrayList<NativeComponentUpdateElementImpl> customElements = new ArrayList<NativeComponentUpdateElementImpl>();
                for (OperationContainer.OperationInfo<?> operationInfo : infos) {
                    UpdateElementImpl updateElementImpl = Trampoline.API.impl(operationInfo.getUpdateElement());
                    assert (updateElementImpl instanceof NativeComponentUpdateElementImpl) : "Impl of " + operationInfo.getUpdateElement() + " instanceof NativeComponentUpdateElementImpl.";
                    customElements.add((NativeComponentUpdateElementImpl)updateElementImpl);
                }
                assert (customElements != null) : "Some elements with custom installer found.";
                progress.start(customElements.size());
                started = true;
                int index = 0;
                this.affectedModules = new HashSet<UpdateElement>();
                for (NativeComponentUpdateElementImpl nativeComponentUpdateElementImpl : customElements) {
                    progress.progress(NbBundle.getMessage(OperationSupportImpl.class, "OperationSupportImpl_Custom_Uninstall", nativeComponentUpdateElementImpl.getDisplayName()), ++index);
                    CustomUninstaller uninstaller = nativeComponentUpdateElementImpl.getNativeItem().getUpdateItemDeploymentImpl().getCustomUninstaller();
                    assert (uninstaller != null) : "CustomInstaller must found for " + nativeComponentUpdateElementImpl.getUpdateElement();
                    ProgressHandle handle = ProgressHandle.createHandle("Installing " + nativeComponentUpdateElementImpl.getDisplayName());
                    success = uninstaller.uninstall(nativeComponentUpdateElementImpl.getCodeName(), nativeComponentUpdateElementImpl.getSpecificationVersion() == null ? null : nativeComponentUpdateElementImpl.getSpecificationVersion().toString(), handle);
                    handle.finish();
                    if (success) {
                        UpdateUnitImpl unitImpl = Trampoline.API.impl(nativeComponentUpdateElementImpl.getUpdateUnit());
                        unitImpl.setAsUninstalled();
                        this.affectedModules.add(nativeComponentUpdateElementImpl.getUpdateElement());
                        continue;
                    }
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL, nativeComponentUpdateElementImpl.getDisplayName());
                }
            }
            finally {
                if (progress != null && started) {
                    progress.finish();
                }
            }
            return success;
        }

        @Override
        public void doCancel() throws OperationException {
            assert (false) : "Not supported yet";
        }

        @Override
        public void doRestart(OperationSupport.Restarter restarter, ProgressHandle progress) throws OperationException {
            OperationSupportImpl.markForRestart();
            LifecycleManager.getDefault().exit();
            this.doRestartLater(restarter);
        }

        @Override
        public void doRestartLater(OperationSupport.Restarter restarter) {
            OperationSupportImpl.markForRestart();
            if (this.affectedModules != null) {
                for (UpdateElement el : this.affectedModules) {
                    UpdateUnitFactory.getDefault().scheduleForRestart(el);
                }
            }
        }
    }
}

