/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.renderkit.html;

public final class HtmlAttributes {

  public static final String ACCEPT_CHARSET = "accept-charset";
  public static final String ACCEPT = "accept";
  public static final String ACCESSKEY = "accesskey";
  public static final String ACTION = "action";
  public static final String ALIGN = "align";
  public static final String ALT = "alt";
  public static final String AUTOCOMPLETE = "autocomplete";
  public static final String AUTOFOCUS = "autofocus";
  public static final String BORDER = "border";
  public static final String CELLPADDING = "cellpadding";
  public static final String CELLSPACING = "cellspacing";
  public static final String CHECKED = "checked";
  public static final String CLASS = "class";
  public static final String COLSPAN = "colspan";
  public static final String CONTENT = "content";
  public static final String DEFER = "defer";
  public static final String DISABLED = "disabled";
  public static final String ENCTYPE = "enctype";
  public static final String FOR = "for";
  public static final String FRAMEBORDER = "frameborder";
  public static final String HEIGHT = "height";
  public static final String HREF = "href";
  public static final String HTTP_EQUIV = "http-equiv";
  public static final String ID = "id";
  public static final String LABEL = "label";
  public static final String MAXLENGTH = "maxlength";
  public static final String MEDIA = "media";
  public static final String METHOD = "method";
  public static final String MULTIPLE = "multiple";
  public static final String NAME = "name";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONBLUR = "onblur";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONCHANGE = "onchange";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONCLICK = "onclick";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONDBLCLICK = "ondblclick";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONFOCUS = "onfocus";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONFOCUSIN = "onfocusin";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONKEYDOWN = "onkeydown";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONKEYPRESS = "onkeypress";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONKEYUP = "onkeyup";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONLOAD = "onload";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONMOUSEOVER = "onmouseover";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String ONMOUSEOUT = "onmouseout";
  public static final String PATTERN = "pattern";
  public static final String PLACEHOLDER = "placeholder";
  public static final String READONLY = "readonly";
  public static final String REL = "rel";
  public static final String REQUIRED = "required";
  public static final String ROLE = "role";
  public static final String ROWS = "rows";
  public static final String ROWSPAN = "rowspan";
  public static final String SCROLL = "scroll";
  public static final String SELECTED = "selected";
  public static final String SIZE = "size";
  public static final String SRC = "src";
  /** @deprecated Since 2.0.0. This attribute work not with SCP */
  @Deprecated
  public static final String STYLE = "style";
  public static final String SUMMARY = "summary";
  public static final String TABINDEX = "tabindex";
  public static final String TARGET = "target";
  public static final String TITLE = "title";
  public static final String TYPE = "type";
  public static final String VALIGN = "valign";
  public static final String VALUE = "value";
  public static final String WIDTH = "width";

  // Non standard attributes ///////////////////////////////////////////////////////////

  /**
   * The index of the tab inside the tab group.
   */
  public static final String TABGROUPINDEX = "tabgroupindex";
  /**
   * The mode of the tab switch: client, reloadTab, reloadPage.
   */
  public static final String SWITCHTYPE = "switchtype";
}

