<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
<!--
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
-->
  <parent>
      <groupId>org.apache.myfaces.core</groupId>
      <artifactId>myfaces-core-project</artifactId>
      <version> 2.3.7</version>
      <relativePath>../parent/pom.xml</relativePath>
  </parent>

  <modelVersion>4.0.0</modelVersion>

  <groupId>org.apache.myfaces.core.internal</groupId>
  <artifactId>myfaces-impl-shared-public</artifactId>
  <version>2.3.7</version>
  <packaging>jar</packaging>
  <name>Apache MyFaces JSF-2.3 Core Shared Public</name>
  <description>The MyFaces Impl Shared module contains utility classes shared by other
  projects like Tomahawk, Orchestra and Portlet-Bridge through shared project.</description>

  <dependencies>
        <!-- myfaces-api -->
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
        </dependency>

        <!-- Servlet 4.0 -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>

        <!-- JSP 2.1 -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jsp_2.2_spec</artifactId>
        </dependency>

        <!-- el 2.2 (javax.el.*) -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-el_2.2_spec</artifactId>
        </dependency>

        <!-- builder-annotations like @JSFWebConfigParam -->
        <dependency>
            <groupId>org.apache.myfaces.buildtools</groupId>
            <artifactId>myfaces-builder-annotations</artifactId>
        </dependency>

        <dependency>
            <groupId>org.apache.myfaces.test</groupId>
            <artifactId>myfaces-test23</artifactId>
        </dependency>

        <dependency>
            <groupId>commons-logging</groupId>
            <artifactId>commons-logging</artifactId>
            <version>1.1.1</version>
            <scope>test</scope>
        </dependency>

        <!-- easymock -->
        <dependency>
            <groupId>org.easymock</groupId>
            <artifactId>easymock</artifactId>
        </dependency>
        <dependency>
            <groupId>org.easymock</groupId>
            <artifactId>easymockclassextension</artifactId>
        </dependency>

  </dependencies>

  <build>
    <plugins>
     <plugin>
         <groupId>org.apache.myfaces.buildtools</groupId>
         <artifactId>myfaces-builder-plugin</artifactId>
         <executions>
           <execution>
               <id>makemyfacesmetadata</id>
               <goals>
                 <goal>build-metadata</goal>
               </goals>
           </execution>
         </executions>
      </plugin>
    </plugins>
  </build>
  <profiles>
    <profile>
        <id>generate-assembly</id>
        <build>
            <plugins>
                <plugin>
                    <groupId>org.apache.maven.plugins</groupId>
                    <artifactId>maven-javadoc-plugin</artifactId>
                    <executions>
                        <execution>
                            <id>attach-javadoc</id>
                            <goals>
                                <goal>jar</goal>
                            </goals>
                        </execution>
                    </executions>
                </plugin>
            </plugins>
        </build>
    </profile>
  </profiles>
  <reporting>
    <plugins>
      <plugin>
        <artifactId>maven-javadoc-plugin</artifactId>
      </plugin>
      <plugin>
          <artifactId>maven-jxr-plugin</artifactId>
      </plugin>
      <plugin>
          <artifactId>maven-changelog-plugin</artifactId>
          <reportSets>
              <reportSet>
                  <id>dual-report</id>
                  <configuration>
                      <type>range</type>
                      <range>30</range>
                  </configuration>
                  <reports>
                      <report>changelog</report>
                      <report>file-activity</report>
                      <report>dev-activity</report>
                  </reports>
              </reportSet>
          </reportSets>
      </plugin>
      <!--
      <plugin>
        <groupId>org.codehaus.mojo</groupId>
        <artifactId>surefire-report-maven-plugin</artifactId>
      </plugin>
       -->
      <plugin>
        <groupId>org.codehaus.mojo</groupId>
        <artifactId>taglist-maven-plugin</artifactId>
      </plugin>
      <plugin>
        <artifactId>maven-pmd-plugin</artifactId>
        <configuration>
          <rulesets>
            <ruleset>/rulesets/basic.xml</ruleset>
            <ruleset>/rulesets/unusedcode.xml</ruleset>
          </rulesets>
          <linkXref>true</linkXref>
          <minimumTokens>100</minimumTokens>
          <targetJdk>1.5</targetJdk>
          <excludes>
            <!-- these class make the PMD plugin crash (NullPointerException). -->
            <exclude>org/apache/myfaces/el/convert/PropertyResolverToELResolver.java</exclude>
            <exclude>org/apache/myfaces/el/PropertyResolverImpl.java</exclude>
          </excludes>
        </configuration>
        <reportSets>
          <reportSet>
            <reports>
              <report>pmd</report>
              <report>cpd</report>
            </reports>
          </reportSet>
        </reportSets>
      </plugin>
    </plugins>
  </reporting>
</project>
