<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
  <modelVersion>4.0.0</modelVersion>
  <artifactId>myfaces-core-assembly</artifactId>
  <version>2.3.7</version>
  <packaging>pom</packaging>
  <name>Core Assembly</name>
  <description>
  	This is the MyFaces Assembly [INSERT MORE STUFF HERE]
  </description>

  <parent>
    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-core-project</artifactId>
    <version> 2.3.7</version>
    <relativePath>../parent/pom.xml</relativePath>
  </parent>

  <build>

    <plugins>
       <plugin>
        <groupId>org.codehaus.mojo</groupId>
        <artifactId>dependency-maven-plugin</artifactId>
        <executions>

          <execution>
            <id>copy-javadoc</id>
            <phase>package</phase>
            <goals>
              <goal>copy</goal>
            </goals>
            <configuration>
              <artifactItems>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-api</artifactId>
                  <version>${project.version}</version>
                  <classifier>javadoc</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core.internal</groupId>
                  <artifactId>myfaces-impl-shared</artifactId>
                  <version>${project.version}</version>
                  <classifier>javadoc</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-impl</artifactId>
                  <version>${project.version}</version>
                  <classifier>javadoc</classifier>
                </artifactItem>
              </artifactItems>
              <outputDirectory>${project.build.directory}/javadoc</outputDirectory>
            </configuration>
          </execution>
          <execution>
            <id>copy-tlddoc</id>
            <phase>package</phase>
            <goals>
              <goal>copy</goal>
            </goals>
            <configuration>
              <artifactItems>

                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-impl</artifactId>
                  <version>${project.version}</version>
                  <classifier>tlddoc</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-impl</artifactId>
                  <version>${project.version}</version>
                  <classifier>facelets-tlddoc</classifier>
                </artifactItem>

               </artifactItems>
               <outputDirectory>${project.build.directory}/tlddoc</outputDirectory>
             </configuration>
           </execution>
          <execution>
            <id>copy-jsdoc</id>
            <phase>package</phase>
            <goals>
              <goal>copy</goal>
            </goals>
            <configuration>
              <artifactItems>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-api</artifactId>
                  <version>${project.version}</version>
                  <classifier>jsdoc</classifier>
                </artifactItem>
               </artifactItems>
               <outputDirectory>${project.build.directory}/jsdoc</outputDirectory>
             </configuration>
           </execution>
          <execution>
            <id>copy-source</id>
            <phase>package</phase>
            <goals>
              <goal>copy</goal>
            </goals>
            <configuration>
              <artifactItems>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-api</artifactId>
                  <version>${project.version}</version>
                  <classifier>sources</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-impl</artifactId>
                  <version>${project.version}</version>
                  <classifier>sources</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core.internal</groupId>
                  <artifactId>myfaces-impl-shared</artifactId>
                  <version>${project.version}</version>
                  <classifier>sources</classifier>
                </artifactItem>
                <artifactItem>
                  <groupId>org.apache.myfaces.core</groupId>
                  <artifactId>myfaces-core-module</artifactId>
                  <version>${project.version}</version>
                  <type>zip</type>
                  <classifier>source-release</classifier>
                </artifactItem>                
               </artifactItems>
               <outputDirectory>${project.build.directory}/src</outputDirectory>
             </configuration>
           </execution>
        </executions>
      </plugin>

      <plugin>
        <!-- EXECUTE mvn package to generate assembly files -->
        <artifactId>maven-assembly-plugin</artifactId>
        <executions>
        	<execution>
        	    <id>make_assembly_src</id>
        	    <configuration>
        	      <descriptors>
			    	 <descriptor>src/main/assembly/coresrc.xml</descriptor>
	    		  </descriptors>
        	      <finalName>myfaces-core-${project.version}-src</finalName>	    		  
        	      <appendAssemblyId>false</appendAssemblyId>
		          <outputDirectory>target/assembly/out</outputDirectory>
        		  <workDirectory>target/assembly/work</workDirectory>
        	    </configuration>
        	    <phase>package</phase>
        	    <goals>
        	       <goal>attached</goal>
        	    </goals>        	    
        	</execution>
        	<execution>
        	    <id>make_assembly_bin</id>
        	    <configuration>
		          <descriptors>
	    			<descriptor>${basedir}/src/main/assembly/corebin.xml</descriptor>
        	      </descriptors>
        	      <finalName>myfaces-core-${project.version}-bin</finalName>
        	      <appendAssemblyId>false</appendAssemblyId>
		          <outputDirectory>target/assembly/out</outputDirectory>
        		  <workDirectory>target/assembly/work</workDirectory>        	      
                </configuration>
                <phase>package</phase>
        	    <goals>
        	       <goal>attached</goal>
        	    </goals>
            </execution>
        </executions>
      </plugin>

      <plugin>
        <groupId>org.codehaus.mojo</groupId>
        <artifactId>build-helper-maven-plugin</artifactId>
        <version>1.5</version>
        <executions>
          <execution>
            <id>attach-artifacts</id>
            <phase>package</phase>
            <goals>
              <goal>attach-artifact</goal>
            </goals>
            <configuration>
              <artifacts>
                <artifact>
                  <file>target/assembly/out/myfaces-core-${project.version}-bin.zip</file>
                  <type>zip</type>
                  <classifier>bin</classifier>
                </artifact>
                <artifact>
                  <file>target/assembly/out/myfaces-core-${project.version}-bin.tar.gz</file>
                  <type>tar.gz</type>
                  <classifier>bin</classifier>
                </artifact>
                <artifact>
                  <file>target/assembly/out/myfaces-core-${project.version}-src.zip</file>
                  <type>zip</type>
                  <classifier>src</classifier>
                </artifact>
                <artifact>
                  <file>target/assembly/out/myfaces-core-${project.version}-src.tar.gz</file>
                  <type>tar.gz</type>
                  <classifier>src</classifier>
                </artifact>
              </artifacts>
            </configuration>
          </execution>
        </executions>
      </plugin>

      <plugin>
        <groupId>org.apache.myfaces.maven</groupId>
        <artifactId>wagon-maven-plugin</artifactId>
        <version>1.0.6</version>
        <configuration>
          <id>myfaces-nightly-builds</id>
          <url>scpexe://minotaur.apache.org/www/cvs.apache.org/builds/myfaces/nightly</url>
          <inputDirectory>target/assembly/out</inputDirectory>
        </configuration>
      </plugin>

    </plugins>

  </build>

  <dependencies>

    <dependency>
      <groupId>org.apache.myfaces.core</groupId>
      <artifactId>myfaces-impl</artifactId>
      <version>${project.version}</version>
    </dependency>

    <dependency>
      <groupId>org.apache.myfaces.core</groupId>
      <artifactId>myfaces-api</artifactId>
      <version>${project.version}</version>
    </dependency>
    
    <dependency>
      <groupId>org.apache.myfaces.core</groupId>
      <artifactId>myfaces-bundle</artifactId>
      <version>${project.version}</version>
    </dependency>

  </dependencies>

</project>
