<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or imcommons-digesterplied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">

    <parent>
        <groupId>org.apache.myfaces</groupId>
        <artifactId>myfaces</artifactId>
        <version>19</version>
        <relativePath />
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-core-project</artifactId>
    <packaging>pom</packaging>
    <name>Apache MyFaces Core 2.3-next - Parent</name>
    <description>
        This project is the home of the MyFaces implementation of the JavaServer Faces 2.3 specification, and
        consists of an API module (javax.faces.* classes) and an implementation module (org.apache.myfaces.* classes).
    </description>
    <version>2.3-next-M4</version>
    <url>http://myfaces.apache.org/core23next</url>

    <issueManagement>
        <system>jira</system>
        <url>https://issues.apache.org/jira/browse/MYFACES</url>
    </issueManagement>

    <build>

        <!-- Since Maven 3.0, this is required to add scpexe as protocol for deploy. -->
        <extensions>
            <extension>
                <groupId>org.apache.maven.wagon</groupId>
                <artifactId>wagon-ssh-external</artifactId>
                <version>1.0-beta-7</version>
            </extension>
        </extensions>

        <plugins>
            <plugin>
                <artifactId>maven-compiler-plugin</artifactId>
                <version>3.6.1</version>
                <configuration>
                    <source>1.8</source>
                    <target>1.8</target>
                </configuration>
            </plugin>

            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-checkstyle-plugin</artifactId>
                <version>2.17</version>
                <executions>
                    <execution>
                        <id>validate</id>
                        <phase>validate</phase>
                        <goals>
                            <goal>check</goal>
                        </goals>
                    </execution>
                </executions>
                <configuration>
                    <configLocation>default/myfaces-checks-standard.xml</configLocation>
                    <headerLocation>default/myfaces-header.txt</headerLocation>
                </configuration>
            </plugin>

            <!-- attach -sources.jar to all our modules -->
            <plugin>
                <artifactId>maven-source-plugin</artifactId>
                <version>2.2.1</version>
                <executions>
                    <execution>
                        <id>attach-source</id>
                        <goals>
                            <goal>jar</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>

            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-scm-publish-plugin</artifactId>
                <version>1.0-beta-2</version>
                <configuration>
                    <pubScmUrl>${siteScmPublish.url}</pubScmUrl>
                    <tryUpdate>true</tryUpdate>
                    <checkoutDirectory>${scmCheckout.path}</checkoutDirectory>
                    <content>\${siteContent.path}</content>
                </configuration>
            </plugin>
            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-site-plugin</artifactId>
                <configuration>
                    <stagingRepositoryId>myfaces-local-staging</stagingRepositoryId>
                    <stagingSiteURL>${siteDeploy.url}</stagingSiteURL>
                </configuration>
            </plugin>

            <plugin>
                <artifactId>maven-release-plugin</artifactId>
                <version>2.5.3</version>
            </plugin>
            <plugin>
                <artifactId>maven-assembly-plugin</artifactId>
                <version>2.5.4</version>
            </plugin>

        </plugins>

        <pluginManagement>
            <plugins>

                <plugin>
                    <groupId>org.apache.myfaces.buildtools</groupId>
                    <artifactId>myfaces-faces-plugin</artifactId>
                    <version>1.0.0</version>
                </plugin>

                <plugin>
                    <groupId>org.apache.myfaces.buildtools</groupId>
                    <artifactId>myfaces-builder-plugin</artifactId>
                    <version>1.0.10</version>
                </plugin>

                <plugin>
                    <artifactId>myfaces-javascript-plugin</artifactId>
                    <groupId>org.apache.myfaces.buildtools</groupId>
                    <version>1.0.1</version>
                </plugin>

                <plugin>
                    <groupId>org.codehaus.mojo</groupId>
                    <artifactId>build-helper-maven-plugin</artifactId>
                    <version>1.9.1</version>
                </plugin>

                <plugin>
                    <groupId>org.apache.felix</groupId>
                    <artifactId>maven-bundle-plugin</artifactId>
                    <version>3.0.1</version>
                </plugin>

                <plugin>
                    <artifactId>maven-surefire-plugin</artifactId>
                    <version>2.22.2</version>
                </plugin>

                <plugin>
                    <artifactId>maven-surefire-report-plugin</artifactId>
                    <version>2.16</version>
                </plugin>

                <!-- SITE GENERATION -->
                <plugin>
                    <artifactId>maven-javadoc-plugin</artifactId>
                    <version>3.1.1</version>
                    <configuration>
                        <source>8</source>
                        <additionalJOption>-Xdoclint:none</additionalJOption>
                        <tags>
                            <tag>
                                <name>JSFJspTag</name>
                                <placement>X</placement>
                            </tag>
                            <tag>
                                <name>JSFJspAttribute</name>
                                <placement>X</placement>
                            </tag>
                        </tags>
                    </configuration>
                </plugin>
                <plugin>
                    <artifactId>maven-site-plugin</artifactId>
                    <version>3.3</version>
                </plugin>
                <plugin>
                    <artifactId>maven-jxr-plugin</artifactId>
                    <version>2.3</version>
                </plugin>
                <plugin>
                    <groupId>org.codehaus.mojo</groupId>
                    <artifactId>taglist-maven-plugin</artifactId>
                    <version>2.4</version>
                </plugin>
                <plugin>
                    <artifactId>maven-changelog-plugin</artifactId>
                    <version>2.2</version>
                </plugin>
                <plugin>
                    <artifactId>maven-pmd-plugin</artifactId>
                    <version>3.12.0</version>
                </plugin>
                <plugin>
                    <groupId>org.codehaus.mojo</groupId>
                    <artifactId>findbugs-maven-plugin</artifactId>
                    <version>3.0.5</version>
                </plugin>
                <plugin>
                    <artifactId>maven-project-info-reports-plugin</artifactId>
                    <version>3.0.0</version>
                </plugin>
            </plugins>
        </pluginManagement>

    </build>


    <profiles>

        <!-- TODO jakobk: we could change this to -Papache-release -->
        <!--
            This profile is invoked by -DprepareRelease=true.
            This allows mvn release:prepare to run successfully on the assembly projects.
        -->
        <profile>
            <id>prepare-release</id>
            <activation>
                <property>
                    <name>prepareRelease</name>
                </property>
            </activation>
            <build>
                <plugins>
                    <plugin>
                        <artifactId>maven-release-plugin</artifactId>
                        <configuration>
                            <arguments>-DprepareRelease</arguments>
                        </configuration>
                    </plugin>
                    <plugin>
                        <groupId>org.apache.rat</groupId>
                        <artifactId>apache-rat-plugin</artifactId>
                        <configuration>
                            <excludes>
                                <exclude>**/*/MANIFEST.MF</exclude>
                                <exclude>.git</exclude>
                                <exclude>.gitignore</exclude>
                                <exclude>**/target/**/*</exclude>
                                <exclude>src/main/resources/META-INF/licenses/*-LICENSE.txt</exclude>
                                <exclude>src/main/resources/META-INF/licenses/*-LICENSE.TXT</exclude>
                                <exclude>src/main/resources/META-INF/services/**</exclude>
                                <exclude>DEPENDENCIES</exclude>
                            </excludes>
                        </configuration>
                        <executions>
                            <execution>
                                <phase>verify</phase>
                                <goals>
                                    <goal>check</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>
        <profile>
            <id>perform-release</id>
            <activation>
                <property>
                    <name>performRelease</name>
                    <value>true</value>
                </property>
            </activation>
            <build>
                <plugins>
                    <plugin>
                        <artifactId>maven-release-plugin</artifactId>
                        <configuration>
                            <arguments>-Papache-release -DperformRelease</arguments>
                        </configuration>
                    </plugin>
                </plugins>
            </build>
        </profile>
    </profiles>


    <reporting>
        <plugins>
            <plugin>
                <artifactId>maven-javadoc-plugin</artifactId>
                <version>3.2.0</version>
                <configuration>
                    <source>8</source>
                </configuration>
            </plugin>
            <plugin>
                <artifactId>maven-pmd-plugin</artifactId>
                <version>3.12.0</version>
                <configuration>
                    <rulesets>
                        <ruleset>/rulesets/java/basic.xml</ruleset>
                        <ruleset>/rulesets/java/unusedcode.xml</ruleset>
                    </rulesets>
                    <linkXref>true</linkXref>
                    <minimumTokens>100</minimumTokens>
                    <targetJdk>1.8</targetJdk>
                </configuration>
                <reportSets>
                    <reportSet>
                        <reports>
                            <report>pmd</report>
                            <report>cpd</report>
                        </reports>
                    </reportSet>
                </reportSets>
            </plugin>
            <plugin>
                <artifactId>maven-project-info-reports-plugin</artifactId>
                <version>2.9</version>
            </plugin>
            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>findbugs-maven-plugin</artifactId>
                <version>3.0.5</version>
            </plugin>
        </plugins>
    </reporting>


    <dependencyManagement>
        <dependencies>
            <!-- Java EE APIs -->
            <dependency>
                <groupId>org.apache.tomcat</groupId>
                <artifactId>tomcat-servlet-api</artifactId>
                <version>9.0.14</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.tomcat</groupId>
                <artifactId>tomcat-websocket-api</artifactId>
                <version>9.0.14</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.tomcat</groupId>
                <artifactId>tomcat-el-api</artifactId>
                <version>9.0.14</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-jsp_2.2_spec</artifactId>
                <version>1.2</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>javax.servlet</groupId>
                <artifactId>jstl</artifactId>
                <version>1.2</version>
                <scope>provided</scope>
                <exclusions>
                    <!-- we already have a jsp-api -->
                    <exclusion>
                        <groupId>javax.servlet</groupId>
                        <artifactId>jsp-api</artifactId>
                    </exclusion>
                </exclusions>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-annotation_1.2_spec</artifactId>
                <version>1.0</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-validation_1.0_spec</artifactId>
                <version>1.1</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-jpa_3.0_spec</artifactId>
                <version>1.1.1</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-ejb_3.0_spec</artifactId>
                <version>1.0.1</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-jcdi_1.1_spec</artifactId>
                <version>1.0</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-atinject_1.0_spec</artifactId>
                <version>1.1</version>
                <scope>provided</scope>
            </dependency>
            <dependency>
                <groupId>org.apache.geronimo.specs</groupId>
                <artifactId>geronimo-interceptor_1.2_spec</artifactId>
                <version>1.1</version>
                <scope>provided</scope>
            </dependency>


            <!-- UTILITY DEPENDENCIES -->

            <!-- builder-annotations like @JSFWebConfigParam -->
            <dependency>
                <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-builder-annotations</artifactId>
                <version>1.0.9</version>
                <scope>provided</scope>
            </dependency>

            <!-- tomcat 7 support (InjectionProvider) -->
            <dependency>
                <groupId>org.apache.tomcat</groupId>
                <artifactId>tomcat-catalina</artifactId>
                <version>9.0.14</version>
                <scope>provided</scope>
            </dependency>


            <dependency>
                <groupId>junit</groupId>
                <artifactId>junit</artifactId>
                <version>4.12</version>
                <scope>test</scope>
            </dependency>

            <!-- easymock -->
            <dependency>
                <groupId>org.easymock</groupId>
                <artifactId>easymock</artifactId>
                <version>2.3</version>
                <scope>test</scope>
            </dependency>
            <dependency>
                <groupId>org.easymock</groupId>
                <artifactId>easymockclassextension</artifactId>
                <version>2.3</version>
                <scope>test</scope>
            </dependency>

            <dependency>
                <groupId>org.mockito</groupId>
                <artifactId>mockito-core</artifactId>
                <version>2.23.0</version>
                <scope>test</scope>
            </dependency>

            <dependency>
                <groupId>de.berlios.jsunit</groupId>
                <artifactId>jsunit-maven2-plugin</artifactId>
                <version>1.3</version>
                <scope>test</scope>
            </dependency>

        </dependencies>
    </dependencyManagement>


    <pluginRepositories>
        <pluginRepository>
            <id>apache.snapshots.plugin</id>
            <name>Apache Snapshot Repository</name>
            <url>https://repository.apache.org/snapshots</url>
            <releases>
                <enabled>false</enabled>
            </releases>
        </pluginRepository>
    </pluginRepositories>

    <!--
    <distributionManagement>
        <site>
            <id>apache.website</id>
            <name>Apache Website</name>
            <url>scpexe://people.apache.org/www/myfaces.apache.org/core21/</url>
        </site>
    </distributionManagement>-->
    <distributionManagement>
        <site>
            <id>myfaces-local-staging</id>
            <name>Apache Website</name>
            <url>scp://localhost/${user.home}/myfaces-site/${siteModule.path}</url>
        </site>
    </distributionManagement>

    <properties>
        <siteModule.path>core23next</siteModule.path>
        <site.mainDirectory>${user.home}/myfaces-site/checkout</site.mainDirectory>
        <siteContent.path>${user.home}/myfaces-site/site/${siteModule.path}</siteContent.path>
        <!-- it's a default location for performance reason (not checkout the content all the time)
        you can override this value in your settings. -->
        <scmCheckout.path>\${site.mainDirectory}/${siteModule.path}</scmCheckout.path>
        <siteDeploy.url>file://${user.home}/myfaces-site/site/${siteModule.path}</siteDeploy.url>
        <siteScmPublish.url>scm:svn:https://svn.apache.org/repos/asf/myfaces/site/publish/</siteScmPublish.url>
    </properties>

  <scm>
    <tag>2.3-next-M4</tag>
  </scm>
</project>
