<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>2.3-next-M3</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-api</artifactId>
    <name>Apache MyFaces Core 2.3-next - API</name>
    <description>
        The public API classes of the Apache MyFaces Core JSF-2.3-next project
    </description>
    <url>http://myfaces.apache.org/core23next/myfaces-api</url>

    <build>


        <resources>
            <!-- standard resources -->
            <resource>
                <directory>src/main/resources</directory>
            </resource>

        </resources>

        <plugins>

            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>build-helper-maven-plugin</artifactId>
                <executions>
                  <execution>
                    <id>parse-version</id>
                    <goals>
                      <goal>parse-version</goal>
                    </goals>
                  </execution>
                </executions>
            </plugin>

            <plugin>
                <groupId>org.apache.maven.plugins</groupId>
                <artifactId>maven-checkstyle-plugin</artifactId>
                <configuration>
                    <excludes>javax/faces/component/**/*.java</excludes>
                </configuration>
            </plugin>

            <plugin>
                <groupId>org.apache.rat</groupId>
                <artifactId>apache-rat-plugin</artifactId>
                <configuration>
                    <excludes>
                        <exclude>**/*/README.md</exclude>
                        <exclude>**/*/MANIFEST.MF</exclude>
                        <exclude>.git</exclude>
                        <exclude>.gitignore</exclude>
                        <exclude>**/target/**/*</exclude>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.txt</exclude>
                        <exclude>src/main/resources/META-INF/licenses/*-LICENSE.TXT</exclude>
                        <exclude>src/main/resources/META-INF/services/**</exclude>
                        <exclude>DEPENDENCIES</exclude>
                    </excludes>
                </configuration>
                <executions>
                    <execution>
                        <phase>verify</phase>
                        <goals>
                            <goal>check</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>

            <!-- compilation and compression of our javascripts -->
            <plugin>
                <artifactId>myfaces-javascript-plugin</artifactId>
                <groupId>org.apache.myfaces.buildtools</groupId>
                <version>1.0.1</version>
                <extensions>true</extensions>
                <executions>

                     <execution>
                        <id>compile</id>
                        <goals>
                            <goal>compile</goal>
                        </goals>
                        <phase>process-resources</phase>
                        <configuration>
                            <sourceDirectory>${basedir}/src/main/javascript/META-INF/resources</sourceDirectory>
                            <descriptor>${basedir}/src/assembler/jsfscripts-compiler.xml</descriptor>
                            <excludes>
                                <exclude>**/myfaces/_impl/core/jsf-uncompressed.js</exclude>
                            </excludes>
                        </configuration>
                    </execution>

                    <execution>
                        <id>compile-uncompressed-full</id>
                        <goals>
                            <goal>compile</goal>
                        </goals>
                        <phase>process-resources</phase>
                        <configuration>
                            <sourceDirectory>${basedir}/src/main/javascript/META-INF/resources</sourceDirectory>
                            <descriptor>${basedir}/src/assembler/jsfscripts-uncompressed-full-compiler.xml</descriptor>
                            <outputDirectory>${basedir}/target/classes/META-INF/internal-resources/javax.faces/</outputDirectory>
                            <excludes>
                                <exclude>**/myfaces/_impl/core/jsf-uncompressed.js</exclude>
                            </excludes>
                        </configuration>
                    </execution>
                    <execution>
                        <id>compile-minimal</id>
                        <goals>
                            <goal>compile</goal>
                        </goals>
                        <phase>process-resources</phase>
                        <configuration>
                            <sourceDirectory>${basedir}/src/main/javascript/META-INF/resources</sourceDirectory>
                            <descriptor>${basedir}/src/assembler/jsfscripts-minimal-compiler.xml</descriptor>
                            <outputDirectory>${basedir}/target/classes/META-INF/internal-resources/javax.faces/</outputDirectory>
                            <excludes>
                                <exclude>**/myfaces/_impl/core/jsf-uncompressed.js</exclude>
                            </excludes>
                        </configuration>
                    </execution>

                    <execution>
                        <id>compile-i18n</id>
                        <goals>
                            <goal>compile</goal>
                        </goals>
                        <phase>process-resources</phase>
                        <configuration>
                            <sourceDirectory>${basedir}/src/main/javascript/META-INF/resources</sourceDirectory>
                            <descriptor>${basedir}/src/assembler/jsfscripts-i18n-compiler.xml</descriptor>
                            <outputDirectory>${basedir}/target/classes/META-INF/resources/myfaces/</outputDirectory>
                            <excludes>
                                <exclude>**/myfaces/_impl/core/jsf-uncompressed.js</exclude>

                            </excludes>
                        </configuration>
                    </execution>

                    <execution>
                        <id>compress</id>
                        <goals>
                            <goal>compress</goal>
                        </goals>
                        <phase>process-resources</phase>

                        <configuration>
                            <scripts>target/classes/META-INF/resources/javax.faces/</scripts>
                            <excludes>
                                <exclude>jsf-uncompressed.js</exclude>
                                <exclude>jsf-uncompressed-full.js</exclude>

                            </excludes>
                            <compressor>yahooUI</compressor>

                        </configuration>
                    </execution>
                    <execution>
                        <id>compress-extended</id>
                        <goals>
                            <goal>compress</goal>
                        </goals>
                        <phase>process-resources</phase>

                        <configuration>
                            <scripts>target/classes/META-INF/resources/myfaces/</scripts>
                            <excludes>
                                <exclude>jsf-uncompressed.js</exclude>
                                <exclude>jsf-uncompressed-full.js</exclude>

                            </excludes>
                            <compressor>yahooUI</compressor>

                        </configuration>
                    </execution>



                <execution>
                        <id>compress-alternatives</id>
                        <goals>
                            <goal>compress</goal>
                        </goals>
                        <phase>process-resources</phase>

                        <configuration>
                            <scripts>target/classes/META-INF/internal-resources/javax.faces/</scripts>
                            <excludes>
                                <exclude>jsf-uncompressed-full.js</exclude>
                                <exclude>META-INF/**/*.js</exclude>

                            </excludes>
                            <compressor>yahooUI</compressor>

                        </configuration>
                    </execution>
                </executions>
                <configuration>
                    <optimizationLevel>0</optimizationLevel>
                    <sourceDirectory>src/main/javascript</sourceDirectory>
                    <webappDirectory>${basedir}</webappDirectory>
                    <outputDirectory>${basedir}/target/classes/META-INF/resources/javax.faces/</outputDirectory>
                </configuration>
            </plugin>


            <!-- we want to use the test cases also in myfacse-impl, thus creating a test-jar -->
            <plugin>
                <artifactId>maven-jar-plugin</artifactId>
                <version>2.2</version>
                <executions>
                    <execution>
                        <goals>
                            <goal>jar</goal>
                            <goal>test-jar</goal>
                        </goals>
                    </execution>
                </executions>
                <configuration>
                    <archive>
                        <manifestFile>${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>
                    </archive>
                    <excludes>
                        <exclude>**/META-INF/resources/myfaces/myfaces/**</exclude>
                        <exclude>**/META-INF/resources/javax.faces/myfaces/**</exclude>
                    </excludes>
                </configuration>
            </plugin>

            <!--
                berlios jsunit under apache2 license to cover javascript core routines which
                do not have to rely on a browser or can work on browser mockups!

                for furhter on dom testing we probably have to integrate html based tests
                with a browser engine but for the core apis this should be sufficient
            -->
            <plugin>
                <groupId>de.berlios.jsunit</groupId>
                <artifactId>jsunit-maven2-plugin</artifactId>
                <version>1.3</version>
                <executions>
                    <!-- TODO currently deactivated -->
                    <!--execution>
                        <id>test</id>
                        <goals>
                            <goal>jsunit-test</goal>
                        </goals>
                    </execution-->
                </executions>
                <configuration>
                    <sourceDirectory>src/main/javascript/META-INF/resources</sourceDirectory>
                    <sources>
                        <source>../../../../test/javascript/org/apache/myfaces/mockups/BrowserMockups.js</source>
                        <!--
                        <source>javax/faces/_util/OpenAjax.js</source>
                        -->
                        <source>javax/faces/_util/_JSF2Utils.js</source>
                        <source>javax/faces/ajax/Ajax.js</source>
                        <source>../../../../test/javascript/org/apache/myfaces/test/_TestScenario.js</source>
                    </sources>
                    <testSourceDirectory>src/test/javascript/org/apache/myfaces</testSourceDirectory>
                    <reportsDirectory>target/surefire-reports</reportsDirectory>
                    <testSuites>
                        <testSuite>
                            <name>javax.faces.Ajax</name>
                            <type>TESTSUITES</type>
                            <includes>
                                <include>test/MockupTest.js</include>
                                <include>utils/_JSF2UtilsTests.js</include>
                                <include>ajax/AjaxTests.js</include>
                            </includes>
                        </testSuite>
                    </testSuites>
                </configuration>
            </plugin>

            <!-- myfaces-builder-plugin for metadata and component classes -->
            <plugin>
                <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-builder-plugin</artifactId>
                <executions>
                    <execution>
                        <goals>
                            <goal>build-metadata</goal>
                        </goals>
                    </execution>
                    <execution>
                        <id>makecomp</id>
                        <configuration>
                            <jsfVersion>20</jsfVersion>
                            <templateComponentName>componentClass20.vm</templateComponentName>
                        </configuration>
                        <goals>
                            <goal>make-components</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>

            <!-- create manifest.mf for OSGi -->
            <plugin>
                <groupId>org.apache.felix</groupId>
                <artifactId>maven-bundle-plugin</artifactId>
                <executions>
                    <execution>
                        <id>bundle-manifest</id>
                        <phase>process-classes</phase>
                        <goals>
                            <goal>manifest</goal>
                        </goals>
                        <configuration>
                            <instructions>
                                <Bundle-SymbolicName>org.apache.myfaces.core.api</Bundle-SymbolicName>
                                <Bundle-Classpath>.</Bundle-Classpath>
                                <Build-Jdk>${java.version}</Build-Jdk>
                                <Implementation-Title>${project.name}</Implementation-Title>
                                <Implementation-Version>${project.version}</Implementation-Version>
                                <Implementation-Vendor>The Apache Software Foundation</Implementation-Vendor>
                                <Implementation-Vendor-Id>${project.groupId}</Implementation-Vendor-Id>
                                <Export-Package>
                                    *;version="${project.version}"
                                </Export-Package>
                                <Import-Package>
                                    javax.el;version="[1.0.0, 3.1.0)",
                                    javax.validation*;version="[1.0.0, 2.0.0)",
                                    javax.servlet;version="[3, 5)",
                                    javax.servlet.http;version="[3, 5)",
                                    javax.servlet.jsp;version="[2.1.0, 3.1)",
                                    javax.servlet.jsp.jstl.core;version="[1.1.2, 2.0.0)",
                                    javax.servlet.jsp.jstl.sql;version="[1.1.2, 2.0.0)",
                                    javax.servlet.jsp.tagext;version="[2.1.0, 3.2)",
                                    javax.faces.*;version="${project.version}"
                                </Import-Package>
                                <Require-Bundle>
                                    org.apache.myfaces.core.impl;bundle-version="${parsedVersion.osgiVersion}"
                                </Require-Bundle>
                            </instructions>
                        </configuration>
                    </execution>
                </executions>
            </plugin>

            <!-- execute tests (JUnit) -->
            <plugin>
                <artifactId>maven-surefire-plugin</artifactId>
            </plugin>

            <!-- generate jandex file for Quarkus but skip classes which depends on JSP dependency -->
            <plugin>
                <groupId>org.jboss.jandex</groupId>
                <artifactId>jandex-maven-plugin</artifactId>
                <version>1.0.6</version>
                <executions>
                  <execution>
                    <id>make-index</id>
                    <goals>
                        <goal>jandex</goal>
                    </goals>
                    <configuration>
                        <fileSets>
                            <fileSet>
                                <directory>${project.build.outputDirectory}</directory>
                                <excludes>
                                  <exclude>**/*Tag.class</exclude>
                                </excludes>
                            </fileSet>
                        </fileSets>
                    </configuration>
                  </execution>
                </executions>
            </plugin>

        </plugins>

    </build>


    <profiles>

        <!-- TODO jakobk: we could change this to -Papache-release -->
        <!--
        - Generate files that are good to have when doing a release to main
        - repositories, but which are not wanted when doing a quick
        - "mvn install" before testing some code modifications.
        -->
        <profile>
            <id>generate-assembly</id>
            <build>
                <plugins>
                    <plugin>
                        <groupId>org.apache.maven.plugins</groupId>
                        <artifactId>maven-javadoc-plugin</artifactId>
                        <configuration>
                            <tags>
                                <tag>
                                    <name>JSFJspTag</name>
                                    <placement>X</placement>
                                </tag>
                                <tag>
                                    <name>JSFJspAttribute</name>
                                    <placement>X</placement>
                                </tag>
                            </tags>
                        </configuration>
                        <executions>
                            <execution>
                                <id>attach-javadoc</id>
                                <goals>
                                    <goal>jar</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                    <plugin>
                        <groupId>org.apache.myfaces.buildtools</groupId>
                        <artifactId>myfaces-jsdoc-plugin</artifactId>
                        <version>1.0-beta-1</version>
                        <executions>
                            <execution>
                                <id>attach-jsdoc</id>
                                <goals>
                                    <goal>jar</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>

        <!-- This profile verifies the binary compablity with the jsf api of the RI -->
        <profile>
            <id>checkCompatibility</id>
            <build>
                <plugins>
                    <plugin>
                        <groupId>org.codehaus.mojo</groupId>
                        <artifactId>clirr-maven-plugin</artifactId>
                        <version>2.8</version>
                        <configuration>
                            <comparisonArtifacts>
                                <comparisonArtifact>
                                    <groupId>org.glassfish</groupId>
                                    <artifactId>javax.faces</artifactId>
                                    <version>2.3.0</version>
                                </comparisonArtifact>
                            </comparisonArtifacts>
                            <includes>
                                <include>javax/faces/**</include>
                            </includes>
                        </configuration>
                        <executions>
                            <execution>
                                <goals>
                                    <goal>check</goal>
                                </goals>
                                <phase>test</phase>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>

        <!-- check for Java 1.6 -->
        <profile>
            <id>checkJDK</id>
            <activation>
                <property>
                    <name>performRelease</name>
                    <value>true</value>
                </property>
            </activation>
            <build>
                <plugins>
                </plugins>
            </build>
        </profile>

        <!--
            this optional profile generates the jsdoc content from
            the embedded javascripts
        -->

        <profile>
            <id>generateJsDoc</id>
            <build>
              <plugins>
                    <plugin>
                        <groupId>org.apache.myfaces.buildtools</groupId>
                        <artifactId>myfaces-jsdoc-plugin</artifactId>
                        <version>1.0-beta-1</version>
                        <executions>
                            <execution>
                                <phase>generate-resources</phase>
                                <goals>
                                    <goal>jsdoc</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
               </plugins>
            </build>
        </profile>

    </profiles>


    <dependencies>
        <!-- Java EE APIs -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-websocket-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-el-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jsp_2.2_spec</artifactId>
        </dependency>
        <dependency>
            <groupId>javax.servlet</groupId>
            <artifactId>jstl</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-validation_1.0_spec</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jcdi_1.1_spec</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-atinject_1.0_spec</artifactId>
        </dependency>


        <!-- builder-annotations like @JSFWebConfigParam -->
        <dependency>
            <groupId>org.apache.myfaces.buildtools</groupId>
            <artifactId>myfaces-builder-annotations</artifactId>
        </dependency>

        <dependency>
            <groupId>de.berlios.jsunit</groupId>
            <artifactId>jsunit-maven2-plugin</artifactId>
        </dependency>
    </dependencies>


    <reporting>
        <plugins>
            <plugin>
                <artifactId>maven-javadoc-plugin</artifactId>
                <configuration>
                    <tags>
                        <tag>
                            <name>JSFJspTag</name>
                            <placement>X</placement>
                        </tag>
                        <tag>
                            <name>JSFJspAttribute</name>
                            <placement>X</placement>
                        </tag>
                    </tags>
                </configuration>
            </plugin>

            <plugin>
               <groupId>org.apache.myfaces.buildtools</groupId>
                <artifactId>myfaces-jsdoc-plugin</artifactId>
                <version>1.0-beta-1</version>
            </plugin>

            <plugin>
                <artifactId>maven-changelog-plugin</artifactId>
                <reportSets>
                    <reportSet>
                        <id>dual-report</id>
                        <configuration>
                            <type>range</type>
                            <range>30</range>
                        </configuration>
                        <reports>
                            <report>changelog</report>
                            <report>file-activity</report>
                            <report>dev-activity</report>
                        </reports>
                    </reportSet>
                </reportSets>
            </plugin>

            <plugin>
                <artifactId>maven-jxr-plugin</artifactId>
            </plugin>

            <plugin>
                <artifactId>maven-surefire-report-plugin</artifactId>
            </plugin>

            <plugin>
                <groupId>org.codehaus.mojo</groupId>
                <artifactId>taglist-maven-plugin</artifactId>
            </plugin>
        </plugins>
    </reporting>

</project>
