<!--
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: pom.xml 1326869 2012-04-17 01:30:30Z lu4242 $
 */
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>2.3-next-M1</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <groupId>org.apache.myfaces.core</groupId>
    <artifactId>myfaces-test</artifactId>
    <packaging>jar</packaging>
    <name>Apache MyFaces Core 2.3-next - Test</name>

    <dependencies>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
            <version>${project.version}</version>
            <scope>provided</scope>
        </dependency>

        <dependency>
            <groupId>javax.portlet</groupId>
            <artifactId>portlet-api</artifactId>
            <version>1.0</version>
            <scope>provided</scope>
        </dependency>

        <!-- Java EE APIs -->
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-servlet-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.tomcat</groupId>
            <artifactId>tomcat-el-api</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-jsp_2.2_spec</artifactId>
        </dependency>

        <dependency>
            <groupId>net.sourceforge.htmlunit</groupId>
            <artifactId>htmlunit</artifactId>
            <version>2.33</version>
            <optional>true</optional>
        </dependency>

        <dependency>
            <groupId>jmock</groupId>
            <artifactId>jmock</artifactId>
            <scope>compile</scope>
        </dependency>
        <dependency>
            <groupId>jmock</groupId>
            <artifactId>jmock-cglib</artifactId>
            <scope>compile</scope>
        </dependency>

        <!-- For the "org.apache.shale.test.cargo" package, we need to have  -->
        <!-- JUnit as a compile time dependency, not just scope="test".      -->
        <dependency>
            <groupId>junit</groupId>
            <artifactId>junit</artifactId>
            <scope>compile</scope>
        </dependency>

        <dependency>
            <groupId>org.codehaus.cargo</groupId>
            <artifactId>cargo-core-uberjar</artifactId>
            <version>0.8</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.codehaus.cargo</groupId>
            <artifactId>cargo-ant</artifactId>
            <version>0.8</version>
            <optional>true</optional>
        </dependency>
    </dependencies>

    <build>
        <plugins>
            <plugin>
                <artifactId>maven-source-plugin</artifactId>
                <executions>
                    <execution>
                        <id>attach-source</id>
                        <goals>
                            <goal>jar</goal>
                        </goals>
                    </execution>
                </executions>
            </plugin>
        </plugins>
    </build>
    <profiles>
        <profile>
            <id>generate-assembly</id>
            <activation>
                <property>
                    <name>performRelease</name>
                    <value>true</value>
                </property>
            </activation>
            <build>
                <plugins>
                    <plugin>
                        <artifactId>maven-javadoc-plugin</artifactId>
                        <executions>
                            <execution>
                                <id>attach-javadoc</id>
                                <goals>
                                    <goal>jar</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>
                </plugins>
            </build>
        </profile>
    </profiles>
    <reporting>
      <plugins>
        <plugin>
          <artifactId>maven-javadoc-plugin</artifactId>
          <reportSets>
            <reportSet>
              <id>non-aggregate</id>
              <configuration>
              </configuration>
              <reports>
                <report>javadoc</report>
              </reports>
            </reportSet>
          </reportSets>
        </plugin>
      </plugins>
    </reporting>
</project>
