<?xml version="1.0" encoding="UTF-8"?>
<!--
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">

    <parent>
        <groupId>org.apache.myfaces.core</groupId>
        <artifactId>myfaces-core-project</artifactId>
        <version>2.2.12</version>
        <relativePath>../parent/pom.xml</relativePath>
    </parent>

    <modelVersion>4.0.0</modelVersion>

    <artifactId>myfaces-impl-test</artifactId>
    <name>Apache MyFaces JSF-2.2 Impl Test</name>

    <scm>
        <connection>scm:svn:http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.2.12/impl-test</connection>
        <developerConnection>scm:svn:https://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.2.12/impl-test</developerConnection>
        <url>http://svn.apache.org/repos/asf/myfaces/core/tags/myfaces-core-module-2.2.12/impl-test</url>
    </scm>
    
    <properties>
        <openwebbeans.version>1.2.1</openwebbeans.version>
    </properties>
    
    <build>
      <plugins>
        <plugin>
            <artifactId>maven-source-plugin</artifactId>
            <executions>
                <execution>
                    <id>attach-source</id>
                    <goals>
                        <goal>jar</goal>
                    </goals>
                </execution>
            </executions>
        </plugin>   
        <!--
        <plugin>
            <groupId>org.codehaus.mojo</groupId>
            <artifactId>build-helper-maven-plugin</artifactId>
            <executions>
                <execution>
                    <id>add-source</id>
                    <phase>generate-sources</phase>
                    <goals>
                        <goal>add-source</goal>
                    </goals>
                    <configuration>
                        <sources>
                            <source>
                                ${project.build.directory}/generated-sources/myfaces-impl
                            </source>
                        </sources>
                    </configuration>
                </execution>
            </executions>
        </plugin>

        <plugin>
            <groupId>org.apache.myfaces.buildtools</groupId>
            <artifactId>myfaces-builder-plugin</artifactId>
            <executions>
              <execution>
                <id>unpack-impl-test</id>
                <phase>generate-sources</phase>
                <goals>
                  <goal>unpack</goal>
                </goals>
                <configuration>
                  <scanModel>false</scanModel>
                  <artifactItems>
                    <artifactItem>
                      <groupId>org.apache.myfaces.core</groupId>
                      <artifactId>myfaces-impl</artifactId>
                      <version>${project.version}</version>
                      <classifier>test-sources</classifier>                   
                      <outputDirectory>${project.build.directory}/generated-sources/myfaces-impl</outputDirectory>
                      <includes>org/apache/myfaces/mc/**/*.java</includes>
                      <excludes>**/*.class,**/META-INF/**</excludes>
                    </artifactItem>
                  </artifactItems>
                </configuration>
              </execution>
            </executions>
        </plugin>-->
      </plugins>
    </build>
    <profiles>
      <profile>
        <id>synch-myfaces-impl-test</id>
        <activation>
          <property>
            <name>synch-test</name>
            <value>true</value>
          </property>
        </activation>
        <build>
          <plugins>
            <plugin>
              <groupId>org.apache.maven.plugins</groupId>
              <artifactId>maven-dependency-plugin</artifactId>
              <executions>
                <execution>
                  <id>unpack-sources</id>
                  <phase>generate-sources</phase>
                  <goals>
                      <goal>unpack</goal>
                  </goals>
                  <configuration>
                    <artifactItems>
                        <artifactItem>
                          <groupId>org.apache.myfaces.core</groupId>
                          <artifactId>myfaces-impl</artifactId>
                          <version>${project.version}</version>
                          <classifier>test-sources</classifier>                   
                        </artifactItem>
                     </artifactItems>
                     <includes>org/apache/myfaces/mc/**/*.java</includes>
                     <excludes>**/*.class,**/META-INF/**</excludes>
                     <outputDirectory>${basedir}/src/main/java</outputDirectory>
                  </configuration>
                </execution>
              </executions>
            </plugin>        
          </plugins>
        </build>
      </profile>
    </profiles>
    <dependencies>
        <!-- include myfaces-api and myfaces-impl in the bundle -->
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-api</artifactId>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core.internal</groupId>
            <artifactId>myfaces-impl-shared-public</artifactId>
            <scope>provided</scope> 
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core.internal</groupId>
            <artifactId>myfaces-impl-shared</artifactId>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.core</groupId>
            <artifactId>myfaces-impl</artifactId>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.myfaces.test</groupId>
            <artifactId>myfaces-test22</artifactId>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>junit</groupId>
            <artifactId>junit</artifactId>
            <scope>provided</scope>
        </dependency>
        
        <!-- Servlet 3.0 by default. Use the -Pee5 compile for servlet-2.5 -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-servlet_3.0_spec</artifactId>
        </dependency>
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-el_2.2_spec</artifactId>
        </dependency>

        <!-- Openwebbeans for CDI Test -->
        <dependency>
            <groupId>org.apache.geronimo.specs</groupId>
            <artifactId>geronimo-interceptor_1.1_spec</artifactId>
            <version>1.0</version>
            <scope>provided</scope>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-impl</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-jsf</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-web</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-spi</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-resource</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
        <dependency>
            <groupId>org.apache.openwebbeans</groupId>
            <artifactId>openwebbeans-clustering</artifactId>
            <version>${openwebbeans.version}</version>
            <optional>true</optional>
        </dependency>
    </dependencies>
    
</project>
