/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.html.HtmlOutputFormat;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;

public class HtmlFormatRenderer
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlFormatRenderer.class.getName());
    private static final Object[] EMPTY_ARGS = new Object[0];

    @Override
    protected boolean isCommonPropertiesOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    protected boolean isCommonEventsOptimizationEnabled(FacesContext facesContext) {
        return true;
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
    }

    @Override
    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        String text = this.getOutputFormatText(facesContext, component);
        boolean escape = component instanceof HtmlOutputFormat ? ((HtmlOutputFormat)component).isEscape() : RendererUtils.getBooleanAttribute(component, "escape", true);
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                if ((commonPropertiesMarked & 0xFFFFFFFFFFFFFFDFL) > 0L) {
                    span = true;
                    writer.startElement("span", component);
                    HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                } else if (CommonPropertyUtils.isIdRenderingNecessary(component)) {
                    span = true;
                    writer.startElement("span", component);
                    writer.writeAttribute("id", component.getClientId(facesContext), null);
                }
                CommonPropertyUtils.renderUniversalProperties(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderStyleProperties(writer, commonPropertiesMarked, component);
            } else if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText(text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    private String getOutputFormatText(FacesContext facesContext, UIComponent htmlOutputFormat) {
        Object[] args;
        String pattern = RendererUtils.getStringValue(facesContext, htmlOutputFormat);
        if (htmlOutputFormat.getChildCount() == 0) {
            args = EMPTY_ARGS;
        } else {
            ArrayList<Object> argsList = null;
            if (htmlOutputFormat.getChildCount() > 0) {
                List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, htmlOutputFormat.getChildren(), false, false, false);
                int size = validParams.size();
                for (int i = 0; i < size; ++i) {
                    UIParameter param = validParams.get(i);
                    if (argsList == null) {
                        argsList = new ArrayList<Object>();
                    }
                    argsList.add(param.getValue());
                }
            }
            args = argsList != null ? argsList.toArray(new Object[argsList.size()]) : EMPTY_ARGS;
        }
        MessageFormat format = new MessageFormat(pattern, facesContext.getViewRoot().getLocale());
        try {
            return format.format(args);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error formatting message of component " + htmlOutputFormat.getClientId(facesContext));
            return "";
        }
    }
}

