/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.StringUtils;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

public class WebConfigParamsLogger {
    private static final Logger log = Logger.getLogger(WebConfigParamsLogger.class.getName());

    public static void logWebContextParams(FacesContext facesContext) {
        int i;
        String[] expectedValues;
        String paramValue;
        String logCommand = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS", "auto");
        if (logCommand.equals("false") || logCommand.equals("auto") && !facesContext.isProjectStage(ProjectStage.Development) && !facesContext.isProjectStage(ProjectStage.Production)) {
            return;
        }
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext());
        if (myfacesConfig.isTomahawkAvailable()) {
            if (myfacesConfig.isMyfacesImplAvailable() && log.isLoggable(Level.INFO)) {
                log.info("Starting up Tomahawk on the MyFaces-JSF-Implementation");
            }
            if (myfacesConfig.isRiImplAvailable() && log.isLoggable(Level.INFO)) {
                log.info("Starting up Tomahawk on the RI-JSF-Implementation.");
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Tomahawk jar not available. Autoscrolling, DetectJavascript, AddResourceClass and CheckExtensionsFilter are disabled now.");
        }
        if (myfacesConfig.isRiImplAvailable() && myfacesConfig.isMyfacesImplAvailable()) {
            log.severe("Both MyFaces and the RI are on your classpath. Please make sure to use only one of the two JSF-implementations.");
        }
        if (log.isLoggable(Level.INFO)) {
            block380: {
                block379: {
                    block378: {
                        block377: {
                            block376: {
                                block375: {
                                    block374: {
                                        boolean found;
                                        log.info("Scanning for context init parameters not defined. It is not necessary to define them all into your web.xml, they are just provided here for informative purposes. To disable this messages set org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS config param to 'false'");
                                        paramValue = null;
                                        paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.RESOURCE_EXCLUDES");
                                        if (paramValue == null) {
                                            log.info("No context init parameter 'javax.faces.RESOURCE_EXCLUDES' found, using default value '.class .jsp .jspx .properties .xhtml .groovy'.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.STATE_SAVING_METHOD")) == null) {
                                            log.info("No context init parameter 'javax.faces.STATE_SAVING_METHOD' found, using default value 'server'.");
                                        } else {
                                            found = false;
                                            expectedValues = StringUtils.trim(StringUtils.splitShortString("server,client", ','));
                                            for (i = 0; i < expectedValues.length; ++i) {
                                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                                found = true;
                                                break;
                                            }
                                            if (!found && log.isLoggable(Level.WARNING)) {
                                                log.warning("Wrong value in context init parameter 'javax.faces.STATE_SAVING_METHOD' (='" + paramValue + "'), using default value 'server'");
                                            }
                                        }
                                        paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FULL_STATE_SAVING_VIEW_IDS");
                                        if (paramValue == null) {
                                            log.info("No context init parameter 'javax.faces.FULL_STATE_SAVING_VIEW_IDS' found.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING")) == null) {
                                            log.info("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING' found, using default value 'true (false with 1.2 webapps)'.");
                                        } else {
                                            found = false;
                                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                                            for (i = 0; i < expectedValues.length; ++i) {
                                                if (!paramValue.equals(expectedValues[i])) continue;
                                                found = true;
                                                break;
                                            }
                                            if (!found && log.isLoggable(Level.WARNING)) {
                                                log.warning("Wrong value in context init parameter 'javax.faces.PARTIAL_STATE_SAVING' (='" + paramValue + "'), using default value 'true (false with 1.2 webapps)'");
                                            }
                                        }
                                        paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.SERIALIZE_SERVER_STATE");
                                        if (paramValue == null) {
                                            log.info("No context init parameter 'javax.faces.SERIALIZE_SERVER_STATE' found, using default value 'false'.");
                                        } else {
                                            found = false;
                                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                                            for (i = 0; i < expectedValues.length; ++i) {
                                                if (!paramValue.equals(expectedValues[i])) continue;
                                                found = true;
                                                break;
                                            }
                                            if (!found && log.isLoggable(Level.WARNING)) {
                                                log.warning("Wrong value in context init parameter 'javax.faces.SERIALIZE_SERVER_STATE' (='" + paramValue + "'), using default value 'false'");
                                            }
                                        }
                                        paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                                        if (paramValue == null) {
                                            log.info("No context init parameter 'javax.faces.DEFAULT_SUFFIX' found, using default value '.xhtml .view.xml .jsp'.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_SUFFIX")) == null) {
                                            log.info("No context init parameter 'javax.faces.FACELETS_SUFFIX' found, using default value '.xhtml'.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS")) == null) {
                                            log.info("No context init parameter 'javax.faces.FACELETS_VIEW_MAPPINGS' found.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER")) == null) {
                                            log.info("No context init parameter 'javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER' found.");
                                        }
                                        if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_BUFFER_SIZE")) == null) {
                                            log.info("No context init parameter 'javax.faces.FACELETS_BUFFER_SIZE' found, using default value '1024'.");
                                        } else {
                                            try {
                                                Integer.valueOf(paramValue);
                                            }
                                            catch (Exception e) {
                                                if (!log.isLoggable(Level.WARNING)) break block374;
                                                log.warning("Wrong value in context init parameter 'javax.faces.FACELETS_BUFFER_SIZE' (='" + paramValue + "'), using default value '1024'");
                                            }
                                        }
                                    }
                                    paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_DECORATORS");
                                    if (paramValue == null) {
                                        log.info("No context init parameter 'javax.faces.FACELETS_DECORATORS' found.");
                                    }
                                    if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_LIBRARIES")) == null) {
                                        log.info("No context init parameter 'javax.faces.FACELETS_LIBRARIES' found.");
                                    }
                                    if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_REFRESH_PERIOD")) == null) {
                                        log.info("No context init parameter 'javax.faces.FACELETS_REFRESH_PERIOD' found, using default value '-1'.");
                                    } else {
                                        try {
                                            Long.valueOf(paramValue);
                                        }
                                        catch (Exception e) {
                                            if (!log.isLoggable(Level.WARNING)) break block375;
                                            log.warning("Wrong value in context init parameter 'javax.faces.FACELETS_REFRESH_PERIOD' (='" + paramValue + "'), using default value '-1'");
                                        }
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_SKIP_COMMENTS");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.FACELETS_SKIP_COMMENTS' found.");
                                }
                                if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.HONOR_CURRENT_COMPONENT_ATTRIBUTES")) == null) {
                                    log.info("No context init parameter 'javax.faces.HONOR_CURRENT_COMPONENT_ATTRIBUTES' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.HONOR_CURRENT_COMPONENT_ATTRIBUTES' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.VALIDATE_EMPTY_FIELDS' found, using default value 'auto'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("auto, true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.VALIDATE_EMPTY_FIELDS' (='" + paramValue + "'), using default value 'auto'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CLEAR_INPUT_WHEN_SUBMITTED_VALUE_IS_NULL_OR_EMPTY");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'org.apache.myfaces.CLEAR_INPUT_WHEN_SUBMITTED_VALUE_IS_NULL_OR_EMPTY' found, using default value 'true'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.CLEAR_INPUT_WHEN_SUBMITTED_VALUE_IS_NULL_OR_EMPTY' (='" + paramValue + "'), using default value 'true'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.ALWAYS_PERFORM_VALIDATION_WHEN_REQUIRED_IS_TRUE' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.VIEWROOT_PHASE_LISTENER_QUEUES_EXCEPTIONS");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.VIEWROOT_PHASE_LISTENER_QUEUES_EXCEPTIONS' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.VIEWROOT_PHASE_LISTENER_QUEUES_EXCEPTIONS' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ENUM_CONVERTER_ALLOW_STRING_PASSTROUGH");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'org.apache.myfaces.ENUM_CONVERTER_ALLOW_STRING_PASSTROUGH' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.ENUM_CONVERTER_ALLOW_STRING_PASSTROUGH' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR' found, using default value 'true'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR' (='" + paramValue + "'), using default value 'true'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN' found, using default value 'false'.");
                                } else {
                                    boolean found = false;
                                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                    for (i = 0; i < expectedValues.length; ++i) {
                                        if (!paramValue.equals(expectedValues[i])) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found && log.isLoggable(Level.WARNING)) {
                                        log.warning("Wrong value in context init parameter 'javax.faces.validator.ENABLE_VALIDATE_WHOLE_BEAN' (='" + paramValue + "'), using default value 'false'");
                                    }
                                }
                                paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.CONFIG_FILES");
                                if (paramValue == null) {
                                    log.info("No context init parameter 'javax.faces.CONFIG_FILES' found.");
                                }
                                if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID")) == null) {
                                    log.info("No context init parameter 'javax.faces.LIFECYCLE_ID' found.");
                                }
                                if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.DISABLE_FACESSERVLET_TO_XHTML")) == null) {
                                    log.info("No context init parameter 'javax.faces.DISABLE_FACESSERVLET_TO_XHTML' found.");
                                }
                                if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE")) == null) {
                                    log.info("No context init parameter 'org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE' found, using default value '500'.");
                                } else {
                                    try {
                                        Integer.valueOf(paramValue);
                                    }
                                    catch (Exception e) {
                                        if (!log.isLoggable(Level.WARNING)) break block376;
                                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.CHECKED_VIEWID_CACHE_SIZE' (='" + paramValue + "'), using default value '500'");
                                    }
                                }
                            }
                            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED");
                            if (paramValue == null) {
                                log.info("No context init parameter 'org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED' found, using default value 'true'.");
                            } else {
                                boolean found = false;
                                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                                for (i = 0; i < expectedValues.length; ++i) {
                                    if (!paramValue.equals(expectedValues[i])) continue;
                                    found = true;
                                    break;
                                }
                                if (!found && log.isLoggable(Level.WARNING)) {
                                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.CHECKED_VIEWID_CACHE_ENABLED' (='" + paramValue + "'), using default value 'true'");
                                }
                            }
                            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CONFIG_REFRESH_PERIOD");
                            if (paramValue == null) {
                                log.info("No context init parameter 'org.apache.myfaces.CONFIG_REFRESH_PERIOD' found, using default value '2'.");
                            } else {
                                try {
                                    Long.valueOf(paramValue);
                                }
                                catch (Exception e) {
                                    if (!log.isLoggable(Level.WARNING)) break block377;
                                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.CONFIG_REFRESH_PERIOD' (='" + paramValue + "'), using default value '2'");
                                }
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RENDER_VIEWSTATE_ID");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.RENDER_VIEWSTATE_ID' found, using default value 'true'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.RENDER_VIEWSTATE_ID' (='" + paramValue + "'), using default value 'true'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_XHTML_LINKS");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.STRICT_XHTML_LINKS' found, using default value 'true'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_XHTML_LINKS' (='" + paramValue + "'), using default value 'true'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.RENDER_CLEAR_JAVASCRIPT_FOR_BUTTON' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RENDER_HIDDEN_FIELDS_FOR_LINK_PARAMS");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.RENDER_HIDDEN_FIELDS_FOR_LINK_PARAMS' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.RENDER_HIDDEN_FIELDS_FOR_LINK_PARAMS' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SAVE_FORM_SUBMIT_LINK_IE");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.SAVE_FORM_SUBMIT_LINK_IE' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.SAVE_FORM_SUBMIT_LINK_IE' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DELEGATE_FACES_SERVLET");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.DELEGATE_FACES_SERVLET' found.");
                        }
                        if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS")) == null) {
                            log.info("No context init parameter 'org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS' found, using default value 'auto'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false,auto", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS' (='" + paramValue + "'), using default value 'auto'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.REFRESH_TRANSIENT_BUILD_ON_PSS_PRESERVE_STATE' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VALIDATE_XML");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.VALIDATE_XML' found.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.VALIDATE_XML' (='" + paramValue + "'), using default value 'null'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.WRAP_SCRIPT_CONTENT_WITH_XML_COMMENT_TAG' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DEBUG_PHASE_LISTENER");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.DEBUG_PHASE_LISTENER' found.");
                        }
                        if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_JSF_2_CC_EL_RESOLVER")) == null) {
                            log.info("No context init parameter 'org.apache.myfaces.STRICT_JSF_2_CC_EL_RESOLVER' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_JSF_2_CC_EL_RESOLVER' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE' found, using default value 'text/html'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("text/html, application/xhtml+xml", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.DEFAULT_RESPONSE_WRITER_CONTENT_TYPE_MODE' (='" + paramValue + "'), using default value 'text/html'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VIEW_UNIQUE_IDS_CACHE_ENABLED");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.VIEW_UNIQUE_IDS_CACHE_ENABLED' found, using default value 'true'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.VIEW_UNIQUE_IDS_CACHE_ENABLED' (='" + paramValue + "'), using default value 'true'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.COMPONENT_UNIQUE_IDS_CACHE_SIZE");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.COMPONENT_UNIQUE_IDS_CACHE_SIZE' found, using default value '100'.");
                        }
                        if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SUPPORT_JSP_AND_FACES_EL")) == null) {
                            log.info("No context init parameter 'org.apache.myfaces.SUPPORT_JSP_AND_FACES_EL' found, using default value 'true'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.SUPPORT_JSP_AND_FACES_EL' (='" + paramValue + "'), using default value 'true'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SUPPORT_MANAGED_BEANS");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.SUPPORT_MANAGED_BEANS' found, using default value 'true'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.SUPPORT_MANAGED_BEANS' (='" + paramValue + "'), using default value 'true'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.GAE_JSF_JAR_FILES");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.GAE_JSF_JAR_FILES' found.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("none, myfavoritejsflib-*.jar", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.GAE_JSF_JAR_FILES' (='" + paramValue + "'), using default value 'null'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.GAE_JSF_ANNOTATIONS_JAR_FILES");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.GAE_JSF_ANNOTATIONS_JAR_FILES' found.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("none, myfavoritejsflib-*.jar", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.GAE_JSF_ANNOTATIONS_JAR_FILES' (='" + paramValue + "'), using default value 'null'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_JSF_2_VIEW_NOT_FOUND");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.STRICT_JSF_2_VIEW_NOT_FOUND' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_JSF_2_VIEW_NOT_FOUND' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.EARLY_FLUSH_ENABLED");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.EARLY_FLUSH_ENABLED' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.EARLY_FLUSH_ENABLED' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_JSF_2_FACELETS_COMPATIBILITY");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.STRICT_JSF_2_FACELETS_COMPATIBILITY' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_JSF_2_FACELETS_COMPATIBILITY' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RENDER_FORM_VIEW_STATE_AT_BEGIN");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.RENDER_FORM_VIEW_STATE_AT_BEGIN' found, using default value 'false'.");
                        } else {
                            boolean found = false;
                            expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                            for (i = 0; i < expectedValues.length; ++i) {
                                if (!paramValue.equals(expectedValues[i])) continue;
                                found = true;
                                break;
                            }
                            if (!found && log.isLoggable(Level.WARNING)) {
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.RENDER_FORM_VIEW_STATE_AT_BEGIN' (='" + paramValue + "'), using default value 'false'");
                            }
                        }
                        paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.FLASH_SCOPE_DISABLED");
                        if (paramValue == null) {
                            log.info("No context init parameter 'org.apache.myfaces.FLASH_SCOPE_DISABLED' found, using default value 'false'.");
                        }
                        if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION")) == null) {
                            log.info("No context init parameter 'org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION' found, using default value '20'.");
                        } else {
                            try {
                                Integer.valueOf(paramValue);
                            }
                            catch (Exception e) {
                                if (!log.isLoggable(Level.WARNING)) break block378;
                                log.warning("Wrong value in context init parameter 'org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION' (='" + paramValue + "'), using default value '20'");
                            }
                        }
                    }
                    paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION");
                    if (paramValue == null) {
                        log.info("No context init parameter 'org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION' found, using default value '4'.");
                    } else {
                        try {
                            Integer.valueOf(paramValue);
                        }
                        catch (Exception e) {
                            if (!log.isLoggable(Level.WARNING)) break block379;
                            log.warning("Wrong value in context init parameter 'org.apache.myfaces.NUMBER_OF_SEQUENTIAL_VIEWS_IN_SESSION' (='" + paramValue + "'), using default value '4'");
                        }
                    }
                }
                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.NUMBER_OF_FLASH_TOKENS_IN_SESSION");
                if (paramValue == null) {
                    log.info("No context init parameter 'org.apache.myfaces.NUMBER_OF_FLASH_TOKENS_IN_SESSION' found.");
                }
                if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.FACES_FLOW_CLIENT_WINDOW_IDS_IN_SESSION")) == null) {
                    log.info("No context init parameter 'org.apache.myfaces.FACES_FLOW_CLIENT_WINDOW_IDS_IN_SESSION' found.");
                }
                if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SUPPORT_EL_3_IMPORT_HANDLER")) == null) {
                    log.info("No context init parameter 'org.apache.myfaces.SUPPORT_EL_3_IMPORT_HANDLER' found, using default value 'false'.");
                } else {
                    boolean found = false;
                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                    for (i = 0; i < expectedValues.length; ++i) {
                        if (!paramValue.equals(expectedValues[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found && log.isLoggable(Level.WARNING)) {
                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.SUPPORT_EL_3_IMPORT_HANDLER' (='" + paramValue + "'), using default value 'false'");
                    }
                }
                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_JSF_2_ORIGIN_HEADER_APP_PATH");
                if (paramValue == null) {
                    log.info("No context init parameter 'org.apache.myfaces.STRICT_JSF_2_ORIGIN_HEADER_APP_PATH' found, using default value 'false'.");
                } else {
                    boolean found = false;
                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                    for (i = 0; i < expectedValues.length; ++i) {
                        if (!paramValue.equals(expectedValues[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found && log.isLoggable(Level.WARNING)) {
                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_JSF_2_ORIGIN_HEADER_APP_PATH' (='" + paramValue + "'), using default value 'false'");
                    }
                }
                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ALWAYS_FORCE_SESSION_CREATION");
                if (paramValue == null) {
                    log.info("No context init parameter 'org.apache.myfaces.ALWAYS_FORCE_SESSION_CREATION' found, using default value 'true'.");
                } else {
                    boolean found = false;
                    expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                    for (i = 0; i < expectedValues.length; ++i) {
                        if (!paramValue.equals(expectedValues[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found && log.isLoggable(Level.WARNING)) {
                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.ALWAYS_FORCE_SESSION_CREATION' (='" + paramValue + "'), using default value 'true'");
                    }
                }
                paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES");
                if (paramValue == null) {
                    log.info("No context init parameter 'org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES' found, using default value '604800000'.");
                }
                if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE")) == null) {
                    log.info("No context init parameter 'org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE' found, using default value '500'.");
                } else {
                    try {
                        Integer.valueOf(paramValue);
                    }
                    catch (Exception e) {
                        if (!log.isLoggable(Level.WARNING)) break block380;
                        log.warning("Wrong value in context init parameter 'org.apache.myfaces.RESOURCE_HANDLER_CACHE_SIZE' (='" + paramValue + "'), using default value '500'");
                    }
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.RESOURCE_HANDLER_CACHE_ENABLED' (='" + paramValue + "'), using default value 'true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.USE_ENCRYPTION");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.USE_ENCRYPTION' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.USE_ENCRYPTION' (='" + paramValue + "'), using default value 'true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SECRET");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.SECRET' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ALGORITHM")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.ALGORITHM' found, using default value 'DES'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SECRET.CACHE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.SECRET.CACHE' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ALGORITHM.IV")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.ALGORITHM.IV' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ALGORITHM.PARAMETERS")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.ALGORITHM.PARAMETERS' found, using default value 'ECB/PKCS5Padding'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SERIAL_FACTORY")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.SERIAL_FACTORY' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.COMPRESS_STATE_IN_CLIENT")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.COMPRESS_STATE_IN_CLIENT' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.COMPRESS_STATE_IN_CLIENT' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.MAC_ALGORITHM");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.MAC_ALGORITHM' found, using default value 'HmacSHA1'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.MAC_SECRET")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.MAC_SECRET' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.MAC_SECRET.CACHE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.MAC_SECRET.CACHE' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.PROJECT_STAGE")) == null) {
                log.info("No context init parameter 'javax.faces.PROJECT_STAGE' found, using default value 'Production'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("Development, Production, SystemTest, UnitTest", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'javax.faces.PROJECT_STAGE' (='" + paramValue + "'), using default value 'Production'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.LAZY_LOAD_CONFIG_OBJECTS");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.LAZY_LOAD_CONFIG_OBJECTS' found, using default value 'true'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.STRICT_JSF_2_ALLOW_SLASH_LIBRARY_NAME' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RESOURCE_BUFFER_SIZE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RESOURCE_BUFFER_SIZE' found, using default value '2048'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN' found, using default value 'none'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("secureRandom, random", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN' (='" + paramValue + "'), using default value 'none'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_LENGTH");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_LENGTH' found, using default value '16'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_CLASS' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_PROVIDER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_SECURE_RANDOM_ALGORITM' found, using default value 'SHA1PRNG'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CLIENT_VIEW_STATE_TIMEOUT")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.CLIENT_VIEW_STATE_TIMEOUT' found, using default value '0'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SERIALIZE_STATE_IN_SESSION")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.SERIALIZE_STATE_IN_SESSION' found, using default value 'false'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.COMPRESS_STATE_IN_SESSION")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.COMPRESS_STATE_IN_SESSION' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.COMPRESS_STATE_IN_SESSION' (='" + paramValue + "'), using default value 'true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.USE_FLASH_SCOPE_PURGE_VIEWS_IN_SESSION' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN' found, using default value 'random'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("secureRandom, random", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN' (='" + paramValue + "'), using default value 'random'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH' found, using default value '8'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_CLASS' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_PROVIDER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_SECURE_RANDOM_ALGORITM' found, using default value 'SHA1PRNG'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("facelets.LIBRARIES")) == null) {
                log.info("No context init parameter 'facelets.LIBRARIES' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VALIDATE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.VALIDATE' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.VALIDATE' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.annotation.USE_CDI_FOR_ANNOTATION_SCANNING");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.annotation.USE_CDI_FOR_ANNOTATION_SCANNING' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.annotation.SCAN_PACKAGES")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.annotation.SCAN_PACKAGES' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.config.annotation.LifecycleProvider")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.config.annotation.LifecycleProvider' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.WEBSOCKET_ENDPOINT_PORT")) == null) {
                log.info("No context init parameter 'javax.faces.WEBSOCKET_ENDPOINT_PORT' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.EL_RESOLVER_COMPARATOR");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.EL_RESOLVER_COMPARATOR' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.EL_RESOLVER_PREDICATE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.EL_RESOLVER_PREDICATE' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DEFAULT_WINDOW_MODE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.DEFAULT_WINDOW_MODE' found, using default value 'url'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.WEBSOCKET_MAX_IDLE_TIMEOUT")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.WEBSOCKET_MAX_IDLE_TIMEOUT' found, using default value '300000'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN' found, using default value 'none'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("secureRandom, random", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.RANDOM_KEY_IN_WEBSOCKET_SESSION_TOKEN' (='" + paramValue + "'), using default value 'none'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ERROR_TEMPLATE_RESOURCE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.ERROR_TEMPLATE_RESOURCE' found, using default value 'META-INF/rsc/myfaces-dev-error.xml'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE' found, using default value 'META-INF/rsc/myfaces-dev-debug.xml'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ERROR_HANDLING")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.ERROR_HANDLING' found, using default value 'false, on Development Project stage: true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.ERROR_HANDLING' (='" + paramValue + "'), using default value 'false, on Development Project stage: true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.AUTOCOMPLETE_OFF_VIEW_STATE' (='" + paramValue + "'), using default value 'true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.USE_MULTIPLE_JS_FILES_FOR_JSF_UNCOMPRESSED_JS' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.JSF_JS_MODE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.JSF_JS_MODE' found, using default value 'normal'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("normal, minimal-modern, minimal", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.JSF_JS_MODE' (='" + paramValue + "'), using default value 'normal'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.TEMPORAL_RESOURCEHANDLER_CACHE_ENABLED' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.SERVICE_PROVIDER_FINDER");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.SERVICE_PROVIDER_FINDER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.spi.InjectionProvider")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.spi.InjectionProvider' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER")) == null) {
                log.info("No context init parameter 'javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true,false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CHECK_ID_PRODUCTION_MODE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.CHECK_ID_PRODUCTION_MODE' found, using default value 'auto'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, auto, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.CHECK_ID_PRODUCTION_MODE' (='" + paramValue + "'), using default value 'auto'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("facelets.BUFFER_SIZE");
            if (paramValue == null) {
                log.info("No context init parameter 'facelets.BUFFER_SIZE' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("facelets.REFRESH_PERIOD")) == null) {
                log.info("No context init parameter 'facelets.REFRESH_PERIOD' found, using default value '-1'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("javax.faces.FACELETS_RESOURCE_RESOLVER")) == null) {
                log.info("No context init parameter 'javax.faces.FACELETS_RESOURCE_RESOLVER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("facelets.RESOURCE_RESOLVER")) == null) {
                log.info("No context init parameter 'facelets.RESOURCE_RESOLVER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.MARK_INITIAL_STATE_WHEN_APPLY_BUILD_VIEW' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("facelets.DECORATORS");
            if (paramValue == null) {
                log.info("No context init parameter 'facelets.DECORATORS' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("facelets.SKIP_COMMENTS")) == null) {
                log.info("No context init parameter 'facelets.SKIP_COMMENTS' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.WRAP_TAG_EXCEPTIONS_AS_CONTEXT_AWARE' (='" + paramValue + "'), using default value 'true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CACHE_EL_EXPRESSIONS");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.CACHE_EL_EXPRESSIONS' found, using default value 'noCache'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("noCache, strict, allowCset, always, alwaysRecompile", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.CACHE_EL_EXPRESSIONS' (='" + paramValue + "'), using default value 'noCache'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VIEW_POOL_MAX_POOL_SIZE");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.VIEW_POOL_MAX_POOL_SIZE' found, using default value '5'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VIEW_POOL_MAX_DYNAMIC_PARTIAL_LIMIT")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.VIEW_POOL_MAX_DYNAMIC_PARTIAL_LIMIT' found, using default value '2'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VIEW_POOL_ENTRY_MODE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.VIEW_POOL_ENTRY_MODE' found, using default value 'soft'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("weak,soft", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.VIEW_POOL_ENTRY_MODE' (='" + paramValue + "'), using default value 'soft'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.VIEW_POOL_DEFERRED_NAVIGATION' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.validator.BEAN_BEFORE_JSF_VALIDATION");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.validator.BEAN_BEFORE_JSF_VALIDATION' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.validator.BEAN_BEFORE_JSF_VALIDATION' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.JSP_SUFFIX");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.JSP_SUFFIX' found, using default value '.jsp'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.EXPRESSION_FACTORY")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.EXPRESSION_FACTORY' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE' found, using default value 'false'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS' found, using default value 'auto'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, auto, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.LOG_WEB_CONTEXT_PARAMS' (='" + paramValue + "'), using default value 'auto'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.AUTOMATIC_EXTENSIONLESS_MAPPING");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.AUTOMATIC_EXTENSIONLESS_MAPPING' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equals(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.AUTOMATIC_EXTENSIONLESS_MAPPING' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.FACES_INITIALIZER");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.FACES_INITIALIZER' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.FACES_INIT_PLUGINS")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.FACES_INIT_PLUGINS' found.");
            }
        }
        if (log.isLoggable(Level.INFO) && myfacesConfig.isTomahawkAvailable()) {
            paramValue = null;
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.RESOURCE_VIRTUAL_PATH");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.RESOURCE_VIRTUAL_PATH' found.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.DETECT_JAVASCRIPT")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.DETECT_JAVASCRIPT' found, using default value 'false'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.AUTO_SCROLL")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.AUTO_SCROLL' found, using default value 'false'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.AUTO_SCROLL' (='" + paramValue + "'), using default value 'false'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.ADD_RESOURCE_CLASS");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.ADD_RESOURCE_CLASS' found, using default value 'org.apache.myfaces. renderkit.html.util. DefaultAddResource'.");
            }
            if ((paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.CHECK_EXTENSIONS_FILTER")) == null) {
                log.info("No context init parameter 'org.apache.myfaces.CHECK_EXTENSIONS_FILTER' found, using default value 'for JSF 2.0 since 1.1.11 false, otherwise true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.CHECK_EXTENSIONS_FILTER' (='" + paramValue + "'), using default value 'for JSF 2.0 since 1.1.11 false, otherwise true'");
                }
            }
            paramValue = facesContext.getExternalContext().getInitParameter("org.apache.myfaces.READONLY_AS_DISABLED_FOR_SELECTS");
            if (paramValue == null) {
                log.info("No context init parameter 'org.apache.myfaces.READONLY_AS_DISABLED_FOR_SELECTS' found, using default value 'true'.");
            } else {
                boolean found = false;
                expectedValues = StringUtils.trim(StringUtils.splitShortString("true, false, on, off, yes, no", ','));
                for (i = 0; i < expectedValues.length; ++i) {
                    if (!paramValue.equalsIgnoreCase(expectedValues[i])) continue;
                    found = true;
                    break;
                }
                if (!found && log.isLoggable(Level.WARNING)) {
                    log.warning("Wrong value in context init parameter 'org.apache.myfaces.READONLY_AS_DISABLED_FOR_SELECTS' (='" + paramValue + "'), using default value 'true'");
                }
            }
        }
    }
}

