/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import java.util.Collection;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.shared.webapp.webxml.WebXml;

public class FacesServletMappingUtils {
    private static final String FACES_SERVLET_REGISTRATION = "org.apache.myfaces.FACES_SERVLET_REGISTRATION";
    private static final String FACES_SERVLET_MAPPINGS = "org.apache.myfaces.FACES_SERVLET_MAPPINGS";

    public static ServletRegistration getFacesServletRegistration(FacesContext facesContext, ServletContext servletContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        ServletRegistration servletRegistration = (ServletRegistration)applicationMap.get(FACES_SERVLET_REGISTRATION);
        if (servletRegistration == null) {
            Map registrations = servletContext.getServletRegistrations();
            if (registrations != null) {
                for (Map.Entry entry : registrations.entrySet()) {
                    if (!FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) continue;
                    servletRegistration = (ServletRegistration)entry.getValue();
                    break;
                }
            }
            applicationMap.put(FACES_SERVLET_REGISTRATION, servletRegistration);
        }
        return servletRegistration;
    }

    public static String[] getFacesServletMappings(FacesContext facesContext, ServletContext servletContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        String[] mappings = (String[])applicationMap.get(FACES_SERVLET_MAPPINGS);
        if (mappings == null) {
            ServletRegistration servletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, servletContext);
            if (servletRegistration != null) {
                Collection mappingsCollection = servletRegistration.getMappings();
                mappings = mappingsCollection.toArray(new String[mappingsCollection.size()]);
            }
            if (mappings == null) {
                mappings = new String[]{};
            }
            applicationMap.put(FACES_SERVLET_MAPPINGS, mappings);
        }
        return mappings;
    }

    public static boolean isFacesServlet(FacesContext facesContext, String servletClassName) {
        Class servletClass = ClassUtils.simpleClassForName(servletClassName, false);
        if (servletClass != null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            return FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(WebXml.getWebXml(externalContext).getDelegateFacesServlet());
        }
        return false;
    }

    public static FacesServletMapping calculateFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo, boolean allowExactMapping) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, allowExactMapping);
            }
            String extension = FacesServletMappingUtils.extractExtensionFromUrl(servletPath);
            if (extension != null) {
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, allowExactMapping);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    private static FacesServletMapping createMappingFromServletRegistration(FacesContext facesContext, ServletContext servletContext, String servletPath, String pathInfo, boolean allowExactMatch) {
        try {
            ServletRegistration facesServletRegistration = FacesServletMappingUtils.getFacesServletRegistration(facesContext, servletContext);
            if (facesServletRegistration != null) {
                FacesServletMapping facesExtensionMapping = null;
                FacesServletMapping facesPrefixMapping = null;
                FacesServletMapping facesExactMapping = null;
                try {
                    String[] mappings;
                    for (String mapping : mappings = FacesServletMappingUtils.getFacesServletMappings(facesContext, servletContext)) {
                        if (FacesServletMappingUtils.isExtensionMapping(mapping)) {
                            facesExtensionMapping = FacesServletMapping.createExtensionMapping(FacesServletMappingUtils.extractExtension(mapping));
                            continue;
                        }
                        if (FacesServletMappingUtils.isPrefixMapping(mapping)) {
                            facesPrefixMapping = FacesServletMapping.createPrefixMapping(FacesServletMappingUtils.extractPrefix(mapping));
                            continue;
                        }
                        if (!allowExactMatch || !mapping.startsWith("/") || !mapping.equals(servletPath)) continue;
                        facesExactMapping = FacesServletMapping.createExactMapping(servletPath);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (allowExactMatch && facesExactMapping != null) {
                    return facesExactMapping;
                }
                if (facesPrefixMapping != null) {
                    return facesPrefixMapping;
                }
                if (facesExtensionMapping != null) {
                    return facesExtensionMapping;
                }
                return FacesServletMapping.createPrefixMapping(servletPath);
            }
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        catch (Exception ex) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
    }

    private static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        String extension = FacesServletMappingUtils.extractExtensionFromUrl(servletPath);
        if (extension != null) {
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createExactMapping(servletPath);
    }

    public static FacesServletMapping getExactMapping(FacesContext facesContext, String prefixedExactMappingViewId) {
        Object context;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext) {
            String[] mappings;
            for (String mapping : mappings = FacesServletMappingUtils.getFacesServletMappings(facesContext, (ServletContext)context)) {
                if (mapping.contains("*") || !prefixedExactMappingViewId.equals(mapping)) continue;
                return FacesServletMapping.createExactMapping(prefixedExactMappingViewId);
            }
        }
        return null;
    }

    public static FacesServletMapping getGenericPrefixOrSuffixMapping(FacesContext facesContext) {
        Object context;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext) {
            String[] mappings;
            for (String mapping : mappings = FacesServletMappingUtils.getFacesServletMappings(facesContext, (ServletContext)context)) {
                if (FacesServletMappingUtils.isExtensionMapping(mapping)) {
                    String extension = FacesServletMappingUtils.extractExtension(mapping);
                    return FacesServletMapping.createExtensionMapping(extension);
                }
                if (!FacesServletMappingUtils.isPrefixMapping(mapping)) continue;
                String prefix = FacesServletMappingUtils.extractPrefix(mapping);
                return FacesServletMapping.createPrefixMapping(prefix);
            }
        }
        return null;
    }

    private static String extractExtensionFromUrl(String url) {
        int slashPos = url.lastIndexOf(47);
        int extensionPos = url.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            return url.substring(extensionPos);
        }
        return null;
    }

    private static boolean isExtensionMapping(String mapping) {
        return mapping.startsWith("*.");
    }

    private static String extractExtension(String mapping) {
        return mapping.substring(1);
    }

    private static boolean isPrefixMapping(String mapping) {
        return mapping.startsWith("/") && mapping.endsWith("/*");
    }

    private static String extractPrefix(String mapping) {
        return mapping.substring(0, mapping.length() - 2);
    }
}

