/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.validator;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.validator.FacesValidator;
import org.apache.myfaces.cdi.validator.FacesValidatorInfo;
import org.apache.myfaces.cdi.validator.FacesValidatorProducer;

public class FacesValidatorExtension
implements Extension {
    private Set<FacesValidatorInfo> types = new HashSet<FacesValidatorInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesValidator.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            Type type = annotated.getBaseType();
            FacesValidator conv = (FacesValidator)annotated.getAnnotation(FacesValidator.class);
            if (conv.managed()) {
                boolean hasValue;
                boolean bl = hasValue = conv.value().length() > 0;
                if (hasValue) {
                    this.types.add(new FacesValidatorInfo(type, conv.value()));
                }
            }
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (FacesValidatorInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new FacesValidatorProducer(beanManager, typeInfo));
        }
    }
}

