/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.push;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIWebsocket;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.push.HtmlBufferResponseWriterWrapper;
import org.apache.myfaces.push.WebsocketInit;
import org.apache.myfaces.push.cdi.WebsocketApplicationBean;
import org.apache.myfaces.push.cdi.WebsocketChannelMetadata;
import org.apache.myfaces.push.cdi.WebsocketChannelTokenBuilderBean;
import org.apache.myfaces.push.cdi.WebsocketSessionBean;
import org.apache.myfaces.push.cdi.WebsocketViewBean;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class WebsocketComponentRenderer
extends Renderer
implements ComponentSystemEventListener {
    @Override
    public void processEvent(ComponentSystemEvent event) {
        if (event instanceof PostAddToViewEvent) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIWebsocket component = (UIWebsocket)event.getComponent();
            WebsocketInit initComponent = (WebsocketInit)facesContext.getViewRoot().findComponent((String)component.getAttributes().get("initComponentId"));
            if (initComponent == null) {
                initComponent = (WebsocketInit)facesContext.getApplication().createComponent(facesContext, "org.apache.myfaces.WebsocketInit", "org.apache.myfaces.WebsocketInit");
                initComponent.setId((String)component.getAttributes().get("initComponentId"));
                facesContext.getViewRoot().addComponentResource(facesContext, initComponent, "body");
            }
        }
    }

    private HtmlBufferResponseWriterWrapper getResponseWriter(FacesContext context) {
        return HtmlBufferResponseWriterWrapper.getInstance(context.getResponseWriter());
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
        writer.startElement("div", component);
        writer.writeAttribute("id", component.getClientId(), null);
        writer.writeAttribute("style", "display:none", null);
        writer.endElement("div");
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            facesContext.setResponseWriter(this.getResponseWriter(facesContext));
        }
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent c) throws IOException {
        super.encodeEnd(facesContext, c);
        UIWebsocket component = (UIWebsocket)c;
        WebsocketInit init = (WebsocketInit)facesContext.getViewRoot().findComponent((String)component.getAttributes().get("initComponentId"));
        ResponseWriter writer = facesContext.getResponseWriter();
        String channel = component.getChannel();
        BeanManager beanManager = CDIUtils.getBeanManager(facesContext.getExternalContext());
        WebsocketChannelTokenBuilderBean channelTokenBean = CDIUtils.lookup(beanManager, WebsocketChannelTokenBuilderBean.class);
        WebsocketViewBean viewTokenBean = CDIUtils.lookup(beanManager, WebsocketViewBean.class);
        WebsocketSessionBean sessionTokenBean = CDIUtils.lookup(beanManager, WebsocketSessionBean.class);
        String scope = component.getScope() == null ? "application" : component.getScope();
        WebsocketChannelMetadata metadata = new WebsocketChannelMetadata(channel, scope, component.getUser(), component.isConnected());
        String channelToken = null;
        if (!component.isConnected()) {
            channelToken = viewTokenBean.getChannelToken(metadata);
        }
        if (channelToken == null) {
            channelToken = channelTokenBean.createChannelToken(facesContext, channel);
            viewTokenBean.registerToken(channelToken, metadata);
            sessionTokenBean.registerToken(channelToken, metadata);
        }
        WebsocketApplicationBean appTokenBean = CDIUtils.getInstance(beanManager, WebsocketApplicationBean.class, false, new Annotation[0]);
        if (scope.equals("view")) {
            viewTokenBean.registerWebsocketSession(channelToken, metadata);
        } else if (scope.equals("session")) {
            sessionTokenBean = sessionTokenBean != null ? sessionTokenBean : CDIUtils.lookup(CDIUtils.getBeanManager(facesContext.getExternalContext()), WebsocketSessionBean.class);
            sessionTokenBean.registerWebsocketSession(channelToken, metadata);
        } else {
            appTokenBean = appTokenBean != null ? appTokenBean : CDIUtils.lookup(CDIUtils.getBeanManager(facesContext.getExternalContext()), WebsocketApplicationBean.class);
            appTokenBean.registerWebsocketSession(channelToken, metadata);
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", "text/javascript", null);
        StringBuilder sb = new StringBuilder(50);
        sb.append("jsf.push.init(");
        sb.append("'" + component.getClientId() + "'");
        sb.append(",");
        sb.append("'" + facesContext.getExternalContext().encodeWebsocketURL(facesContext.getApplication().getViewHandler().getWebsocketURL(facesContext, component.getChannel() + "?" + channelToken)) + "'");
        sb.append(",");
        sb.append("'" + component.getChannel() + "'");
        sb.append(",");
        sb.append(component.getOnopen());
        sb.append(",");
        sb.append(component.getOnmessage());
        sb.append(",");
        sb.append(component.getOnclose());
        sb.append(",");
        sb.append(this.getBehaviorScripts(facesContext, component));
        sb.append(",");
        sb.append(component.isConnected());
        sb.append(");");
        writer.write(sb.toString());
        writer.endElement("script");
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            HtmlBufferResponseWriterWrapper buffwriter = (HtmlBufferResponseWriterWrapper)facesContext.getResponseWriter();
            init.getUIWebsocketMarkupList().add(writer.toString());
            facesContext.setResponseWriter(buffwriter.getInitialWriter());
        }
    }

    private String getBehaviorScripts(FacesContext facesContext, UIWebsocket component) {
        Map<String, List<ClientBehavior>> clientBehaviorsByEvent = component.getClientBehaviors();
        if (clientBehaviorsByEvent.isEmpty()) {
            return "{}";
        }
        String clientId = component.getClientId(facesContext);
        StringBuilder scripts = new StringBuilder("{");
        for (Map.Entry<String, List<ClientBehavior>> entry : clientBehaviorsByEvent.entrySet()) {
            String event = entry.getKey();
            List<ClientBehavior> clientBehaviors = entry.getValue();
            scripts.append(scripts.length() > 1 ? "," : "").append(event).append(":[");
            for (int i = 0; i < clientBehaviors.size(); ++i) {
                scripts.append(i > 0 ? "," : "").append("function(event){");
                scripts.append(clientBehaviors.get(i).getScript(ClientBehaviorContext.createClientBehaviorContext(facesContext, component, event, clientId, null)));
                scripts.append("}");
            }
            scripts.append("]");
        }
        return scripts.append("}").toString();
    }
}

