/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.application;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.myfaces.shared.application.FacesServletMapping;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.shared.util.ExternalContextUtils;
import org.apache.myfaces.shared.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.shared.webapp.webxml.WebXml;

public class FacesServletMappingUtils {
    private static final String IS_FACES_SERVLET_CLASS_NAME_MAP = "org.apache.myfaces.IS_FACES_SERVLET_CLASS_NAME_MAP";

    public static FacesServletMapping calculateGenericFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, false);
            }
            int slashPos = servletPath.lastIndexOf(47);
            int extensionPos = servletPath.lastIndexOf(46);
            if (extensionPos > -1 && extensionPos > slashPos) {
                String extension = servletPath.substring(extensionPos);
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, false);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    public static FacesServletMapping calculateFacesServletMapping(FacesContext facesContext, String servletPath, String pathInfo) {
        if (ExternalContextUtils.isPortlet(facesContext.getExternalContext())) {
            return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
        }
        Object context = facesContext.getExternalContext().getContext();
        if (context instanceof ServletContext) {
            if (pathInfo != null) {
                return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, true);
            }
            int slashPos = servletPath.lastIndexOf(47);
            int extensionPos = servletPath.lastIndexOf(46);
            if (extensionPos > -1 && extensionPos > slashPos) {
                String extension = servletPath.substring(extensionPos);
                return FacesServletMapping.createExtensionMapping(extension);
            }
            return FacesServletMappingUtils.createMappingFromServletRegistration(facesContext, (ServletContext)context, servletPath, pathInfo, true);
        }
        return FacesServletMappingUtils.calculateFacesServletMapping(servletPath, pathInfo);
    }

    private static FacesServletMapping createMappingFromServletRegistration(FacesContext facesContext, ServletContext servletContext, String servletPath, String pathInfo, boolean allowExactMatch) {
        try {
            Map map = servletContext.getServletRegistrations();
            if (map != null) {
                FacesServletMapping facesExtensionMapping = null;
                FacesServletMapping facesPrefixMapping = null;
                FacesServletMapping facesExactMapping = null;
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        Collection mappings = ((ServletRegistration)entry.getValue()).getMappings();
                        if (FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) {
                            for (String mapping : mappings) {
                                if (mapping.startsWith("*.")) {
                                    facesExtensionMapping = FacesServletMapping.createExtensionMapping(mapping.substring(1));
                                    continue;
                                }
                                if (mapping.startsWith("/") && mapping.endsWith("/*")) {
                                    facesPrefixMapping = FacesServletMapping.createPrefixMapping(mapping.substring(0, mapping.length() - 2));
                                    continue;
                                }
                                if (!allowExactMatch || !mapping.startsWith("/") || !mapping.equals(servletPath)) continue;
                                facesExactMapping = FacesServletMapping.createPrefixMapping(servletPath);
                            }
                            continue;
                        }
                        Object servletPrefixMapping = null;
                        for (String mapping : mappings) {
                            if (mapping.startsWith("/") && mapping.endsWith("/*")) {
                                mapping = mapping.substring(0, mapping.length() - 2);
                            }
                            if (!mapping.equals(servletPath)) continue;
                            return FacesServletMapping.createPrefixMapping(mapping);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                if (allowExactMatch && facesExactMapping != null) {
                    return facesExactMapping;
                }
                if (facesPrefixMapping != null) {
                    return facesPrefixMapping;
                }
                if (facesExtensionMapping != null) {
                    return facesExtensionMapping;
                }
                return FacesServletMapping.createPrefixMapping(servletPath);
            }
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        catch (Exception ex) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
    }

    public static boolean isFacesServlet(FacesContext facesContext, String servletClassName) {
        Boolean isFacesServlet;
        ExternalContext eContext = facesContext.getExternalContext();
        ConcurrentHashMap<String, Boolean> servletClassNameMap = (ConcurrentHashMap<String, Boolean>)eContext.getApplicationMap().get(IS_FACES_SERVLET_CLASS_NAME_MAP);
        if (servletClassNameMap == null) {
            servletClassNameMap = new ConcurrentHashMap<String, Boolean>();
            eContext.getApplicationMap().put(IS_FACES_SERVLET_CLASS_NAME_MAP, servletClassNameMap);
        }
        if ((isFacesServlet = (Boolean)servletClassNameMap.get(servletClassName)) == null) {
            Class servletClass = ClassUtils.simpleClassForName(servletClassName, false);
            if (servletClass != null) {
                isFacesServlet = FacesServlet.class.isAssignableFrom(servletClass) || DelegatedFacesServlet.class.isAssignableFrom(servletClass) || servletClass.getName().equals(WebXml.getWebXml(eContext).getDelegateFacesServlet()) ? Boolean.TRUE : Boolean.FALSE;
                servletClassNameMap.put(servletClassName, isFacesServlet);
            } else {
                isFacesServlet = Boolean.FALSE;
                servletClassNameMap.put(servletClassName, isFacesServlet);
            }
        }
        return isFacesServlet;
    }

    private static FacesServletMapping calculateFacesServletMapping(String servletPath, String pathInfo) {
        if (pathInfo != null) {
            return FacesServletMapping.createPrefixMapping(servletPath);
        }
        int slashPos = servletPath.lastIndexOf(47);
        int extensionPos = servletPath.lastIndexOf(46);
        if (extensionPos > -1 && extensionPos > slashPos) {
            String extension = servletPath.substring(extensionPos);
            return FacesServletMapping.createExtensionMapping(extension);
        }
        return FacesServletMapping.createPrefixMapping(servletPath);
    }

    public static FacesServletMapping calculateFacesServletMappingFromPrefixedExactMappingViewId(FacesContext facesContext, String prefixedExactMappingViewId) {
        Map map;
        Object context;
        FacesServletMapping mapping = null;
        if (!ExternalContextUtils.isPortlet(facesContext.getExternalContext()) && (context = facesContext.getExternalContext().getContext()) instanceof ServletContext && (map = ((ServletContext)context).getServletRegistrations()) != null) {
            for (Map.Entry entry : map.entrySet()) {
                try {
                    if (!FacesServletMappingUtils.isFacesServlet(facesContext, ((ServletRegistration)entry.getValue()).getClassName())) continue;
                    Collection mappings = ((ServletRegistration)entry.getValue()).getMappings();
                    for (String m : mappings) {
                        if (m.contains("*") || !prefixedExactMappingViewId.equals(m)) continue;
                        mapping = FacesServletMapping.createPrefixMapping(prefixedExactMappingViewId);
                    }
                }
                catch (Exception exception) {}
            }
        }
        return mapping;
    }
}

