/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DuplexChannel;
import io.netty.util.Attribute;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.netty.NettyIoService;
import org.apache.sshd.netty.NettySupport;

public class NettyIoSession
extends AbstractCloseable
implements IoSession {
    protected final Map<Object, Object> attributes = new HashMap<Object, Object>();
    protected final NettyIoService service;
    protected final IoHandler handler;
    protected final long id;
    protected ChannelHandlerContext context;
    protected SocketAddress remoteAddr;
    protected ChannelFuture prev;
    protected final ChannelInboundHandlerAdapter adapter = new Adapter();
    protected final AtomicBoolean readSuspended = new AtomicBoolean();
    private final SocketAddress acceptanceAddress;

    public NettyIoSession(NettyIoService service, IoHandler handler, SocketAddress acceptanceAddress) {
        super(Objects.toString(acceptanceAddress, ""));
        this.service = service;
        this.handler = handler;
        this.id = service.sessionSeq.incrementAndGet();
        this.acceptanceAddress = acceptanceAddress;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttributeIfAbsent(Object key, Object value) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.putIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(Object key) {
        Map<Object, Object> map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddr;
    }

    public SocketAddress getLocalAddress() {
        Channel channel = this.context == null ? null : this.context.channel();
        return channel == null ? null : channel.localAddress();
    }

    public SocketAddress getAcceptanceAddress() {
        return this.acceptanceAddress;
    }

    public IoWriteFuture writeBuffer(Buffer buffer) {
        int bufLen = buffer.available();
        ByteBuf buf = Unpooled.buffer((int)bufLen);
        buf.writeBytes(buffer.array(), buffer.rpos(), bufLen);
        DefaultIoWriteFuture msg = new DefaultIoWriteFuture(this.getRemoteAddress(), null);
        ChannelPromise next = this.context.newPromise();
        this.prev.addListener(whatever -> {
            if (this.context != null) {
                this.context.writeAndFlush((Object)buf, next);
            }
        });
        this.prev = next;
        next.addListener(fut -> {
            if (fut.isSuccess()) {
                msg.setValue(Boolean.TRUE);
            } else {
                msg.setValue(fut.cause());
            }
        });
        return msg;
    }

    public IoService getService() {
        return this.service;
    }

    public void suspendRead() {
        if (!this.readSuspended.getAndSet(true) && this.context != null) {
            Channel ch = this.context.channel();
            ch.config().setAutoRead(false);
        }
    }

    public void resumeRead() {
        if (this.readSuspended.getAndSet(false) && this.context != null) {
            Channel ch = this.context.channel();
            ch.config().setAutoRead(true);
        }
    }

    public void shutdownOutputStream() throws IOException {
        Channel ch = this.context.channel();
        if (ch instanceof DuplexChannel) {
            ((DuplexChannel)ch).shutdownOutput();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("shutdownOutputStream({}) channel is not DuplexChannel: {}", (Object)this, ch == null ? null : ch.getClass().getSimpleName());
        }
    }

    protected CloseFuture doCloseGracefully() {
        if (this.context != null) {
            this.context.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE).addListener(fut -> this.closeFuture.setClosed());
        } else {
            this.closeFuture.setClosed();
        }
        return this.closeFuture;
    }

    protected void doCloseImmediately() {
        if (this.context != null) {
            this.context.close();
        }
        super.doCloseImmediately();
    }

    protected void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.context = ctx;
        Channel channel = ctx.channel();
        this.service.channelGroup.add((Object)channel);
        this.service.sessions.put(this.id, this);
        this.prev = this.context.newPromise().setSuccess();
        this.remoteAddr = channel.remoteAddress();
        this.handler.sessionCreated((IoSession)this);
        Attribute connectFuture = channel.attr(NettyIoService.CONNECT_FUTURE_KEY);
        IoConnectFuture future = (IoConnectFuture)connectFuture.get();
        if (future != null) {
            future.setSession((IoSession)this);
        }
    }

    protected void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.service.sessions.remove(this.id);
        this.handler.sessionClosed((IoSession)this);
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        try {
            this.handler.messageReceived((IoSession)this, NettySupport.asReadable(buf));
        }
        finally {
            buf.release();
        }
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.handler.exceptionCaught((IoSession)this, cause);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }

    protected class Adapter
    extends ChannelInboundHandlerAdapter {
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            ctx.channel().config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            NettyIoSession.this.channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            NettyIoSession.this.channelRead(ctx, msg);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            NettyIoSession.this.exceptionCaught(ctx, cause);
        }
    }

    protected static class DefaultIoWriteFuture
    extends AbstractIoWriteFuture {
        public DefaultIoWriteFuture(Object id, Object lock) {
            super(id, lock);
        }
    }
}

